/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.deployment;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.deployment.Binding")
@Searchable(root=false)
public class Binding
extends TModel {
    private static final long serialVersionUID = -2499871821906718599L;
    private Set<BindingOperation> bindingOps;
    private Set<Endpoint> endpoints = new HashSet<Endpoint>();
    @SearchableProperty
    private String fullName;
    @SearchableComponent
    private Set<Protocol> protocols;
    @SearchableComponent
    private Set<Transport> transports;
    @SearchableComponent
    private ServiceInterface serviceInterface;
    private Set<ServiceSpecification> serviceSpecifications;

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Binding)) {
            return false;
        }
        Binding castOther = (Binding)other;
        return new EqualsBuilder().append((Object)this.fullName, (Object)castOther.fullName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fullName).toHashCode();
    }

    public Binding() {
        this.bindingOps = new HashSet<BindingOperation>();
        this.serviceSpecifications = new HashSet<ServiceSpecification>();
        this.protocols = new HashSet<Protocol>();
        this.transports = new HashSet<Transport>();
    }

    public void addBindingOp(BindingOperation bindingOperation) {
        this.getBindingOps().add(bindingOperation);
        bindingOperation.setBinding(this);
    }

    public void addEndpoint(Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.setBinding(this);
    }

    public void addProtocol(Protocol protocol) {
        this.protocols.add(protocol);
    }

    public void addTransport(Transport transport) {
        this.transports.add(transport);
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="binding")
    public Set<BindingOperation> getBindingOps() {
        return this.bindingOps;
    }

    @OneToMany(mappedBy="binding")
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public String getFullName() {
        return this.fullName;
    }

    @ManyToOne
    @JoinColumn(name="serviceIntId", nullable=false)
    public ServiceInterface getServiceInterface() {
        return this.serviceInterface;
    }

    @ManyToMany(mappedBy="bindings")
    public Set<ServiceSpecification> getServiceSpecifications() {
        return this.serviceSpecifications;
    }

    public void setBindingOps(Set<BindingOperation> bindingOps) {
        this.bindingOps = bindingOps;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setServiceInterface(ServiceInterface serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setServiceSpecifications(Set<ServiceSpecification> serviceSpecifications) {
        this.serviceSpecifications = serviceSpecifications;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("serviceInterface", (Object)this.serviceInterface).append("bindingOps", this.bindingOps).append("fullName", (Object)this.fullName).toString();
    }

    @ManyToMany
    public Set<Protocol> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Set<Protocol> protocols) {
        this.protocols = protocols;
    }

    @ManyToMany
    public Set<Transport> getTransports() {
        return this.transports;
    }

    public void setTransports(Set<Transport> transports) {
        this.transports = transports;
    }
}

