/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.metadata;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.UDDIUseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.metadata.SimpleFile")
@Searchable(root=false)
public class SimpleFile
extends SearchableBaseObject {
    private static final long serialVersionUID = -4420806280865395128L;
    private String location;
    private Blob content;
    private ContentType fileType;
    private String fileName;
    private String author;
    private String title;
    private String extractedContent;
    private List<Description> descriptions = new ArrayList<Description>();
    private Set<SimpleFile> importedFiles = new HashSet<SimpleFile>();
    private UDDIUseType useType;

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addImportedFile(SimpleFile file) {
        this.getImportedFiles().add(file);
    }

    @Lob
    @Column(length=0x100000)
    public Blob getContent() {
        return this.content;
    }

    @Enumerated(value=EnumType.STRING)
    public ContentType getFileType() {
        return this.fileType;
    }

    public void setContent(Blob content) {
        this.content = content;
    }

    public void setFileType(ContentType fileType) {
        this.fileType = fileType;
    }

    @SearchableProperty
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @SearchableProperty
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(length=0x100000)
    @SearchableProperty
    public String getExtractedContent() {
        return this.extractedContent;
    }

    public void setExtractedContent(String extractedContent) {
        this.extractedContent = extractedContent;
    }

    @OneToMany(cascade={CascadeType.REMOVE})
    @SearchableComponent
    public Set<SimpleFile> getImportedFiles() {
        return this.importedFiles;
    }

    public void setImportedFiles(Set<SimpleFile> importedFiles) {
        this.importedFiles = importedFiles;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("fileType", (Object)this.fileType).append("descriptions", this.descriptions).append("fileName", (Object)this.fileName).append("importedFiles", this.importedFiles).append("title", (Object)this.title).append("location", (Object)this.location).append("author", (Object)this.author).toString();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Enumerated(value=EnumType.STRING)
    public UDDIUseType getUseType() {
        return this.useType;
    }

    public void setUseType(UDDIUseType useType) {
        this.useType = useType;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SimpleFile)) {
            return false;
        }
        SimpleFile castOther = (SimpleFile)other;
        return new EqualsBuilder().append((Object)this.location, (Object)castOther.location).append((Object)this.content, (Object)castOther.content).append((Object)this.fileType, (Object)castOther.fileType).append((Object)this.fileName, (Object)castOther.fileName).append((Object)this.author, (Object)castOther.author).append((Object)this.title, (Object)castOther.title).append((Object)this.extractedContent, (Object)castOther.extractedContent).append(this.descriptions, castOther.descriptions).append((Object)this.useType, (Object)castOther.useType).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.location).append((Object)this.content).append((Object)this.fileType).append((Object)this.fileName).append((Object)this.author).append((Object)this.title).append((Object)this.extractedContent).append(this.descriptions).append((Object)this.useType).toHashCode();
    }
}

