/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.service.ProposedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.service.Service")
@Searchable(root=false)
public class Service
extends SearchableBaseObject {
    private static final long serialVersionUID = 6423683917036741837L;
    private Set<String> alias;
    private Set<String> criticalSuccessFactors;
    private String infoProcessingStyle;
    private String intendedImplementationStyle;
    private XfaceStyle interfaceStyle;
    private boolean isBusinessService;
    private Set<String> nonFunctionalRqmts;
    private Set<ProposedOperation> proposedOps;
    private String responsabilities;
    private String stabilityExpectations;
    private Set<String> targetCustomers;
    private Set<TechnicalService> technicalServices = new HashSet<TechnicalService>();
    private Visibility visibility;
    private String uddiKey;
    @SearchableComponent
    private List<Name> names;
    @SearchableComponent
    private List<Description> descriptions;
    @SearchableComponent
    private CategoryBag categoryBag;

    public Service() {
        this.proposedOps = new HashSet<ProposedOperation>();
        this.names = new ArrayList<Name>();
        this.descriptions = new ArrayList<Description>();
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addName(Name name) {
        this.getNames().add(name);
    }

    public void addProposedOperation(ProposedOperation proposedOperation) {
        this.getProposedOps().add(proposedOperation);
        proposedOperation.setService(this);
    }

    public void addTechnicalService(TechnicalService technicalService) {
        this.getTechnicalServices().add(technicalService);
        technicalService.setService(this);
    }

    @CollectionOfElements
    public Set<String> getAlias() {
        return this.alias;
    }

    @CollectionOfElements
    public Set<String> getCriticalSuccessFactors() {
        return this.criticalSuccessFactors;
    }

    public String getInfoProcessingStyle() {
        return this.infoProcessingStyle;
    }

    public String getIntendedImplementationStyle() {
        return this.intendedImplementationStyle;
    }

    @Enumerated(value=EnumType.STRING)
    public XfaceStyle getInterfaceStyle() {
        return this.interfaceStyle;
    }

    @CollectionOfElements
    public Set<String> getNonFunctionalRqmts() {
        return this.nonFunctionalRqmts;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="service")
    public Set<ProposedOperation> getProposedOps() {
        return this.proposedOps;
    }

    public String getResponsabilities() {
        return this.responsabilities;
    }

    public String getStabilityExpectations() {
        return this.stabilityExpectations;
    }

    @CollectionOfElements
    public Set<String> getTargetCustomers() {
        return this.targetCustomers;
    }

    @OneToMany(mappedBy="service")
    public Set<TechnicalService> getTechnicalServices() {
        return this.technicalServices;
    }

    @Enumerated(value=EnumType.STRING)
    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isBusinessService() {
        return this.isBusinessService;
    }

    public void setAlias(Set<String> alias) {
        this.alias = alias;
    }

    public void setBusinessService(boolean isBusinessService) {
        this.isBusinessService = isBusinessService;
    }

    public void setCriticalSuccessFactors(Set<String> criticalSuccessFactors) {
        this.criticalSuccessFactors = criticalSuccessFactors;
    }

    public void setInfoProcessingStyle(String infoProcessingStyle) {
        this.infoProcessingStyle = infoProcessingStyle;
    }

    public void setIntendedImplementationStyle(String intendedImplementationStyle) {
        this.intendedImplementationStyle = intendedImplementationStyle;
    }

    public void setInterfaceStyle(XfaceStyle interfaceStyle) {
        this.interfaceStyle = interfaceStyle;
    }

    public void setNonFunctionalRqmts(Set<String> nonFunctionalRqmts) {
        this.nonFunctionalRqmts = nonFunctionalRqmts;
    }

    public void setProposedOps(Set<ProposedOperation> proposedOps) {
        this.proposedOps = proposedOps;
    }

    public void setResponsabilities(String responsabilities) {
        this.responsabilities = responsabilities;
    }

    public void setStabilityExpectations(String stabilityExpectations) {
        this.stabilityExpectations = stabilityExpectations;
    }

    public void setTargetCustomers(Set<String> targetCustomers) {
        this.targetCustomers = targetCustomers;
    }

    public void setTechnicalServices(Set<TechnicalService> technicalServices) {
        this.technicalServices = technicalServices;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public String getUddiKey() {
        return this.uddiKey;
    }

    public void setUddiKey(String uddiKey) {
        this.uddiKey = uddiKey;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Name> getNames() {
        return this.names;
    }

    public void setNames(List<Name> names) {
        this.names = names;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Service)) {
            return false;
        }
        Service castOther = (Service)other;
        return new EqualsBuilder().append((Object)this.uddiKey, (Object)castOther.uddiKey).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.uddiKey).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("intendedImplementationStyle", (Object)this.intendedImplementationStyle).append("descriptions", this.descriptions).append("visibility", (Object)this.visibility).append("interfaceStyle", (Object)this.interfaceStyle).append("isBusinessService", this.isBusinessService).append("responsabilities", (Object)this.responsabilities).append("criticalSuccessFactors", this.criticalSuccessFactors).append("proposedOps", this.proposedOps).append("alias", this.alias).append("targetCustomers", this.targetCustomers).append("categoryBag", (Object)this.categoryBag).append("infoProcessingStyle", (Object)this.infoProcessingStyle).append("names", this.names).append("uddiKey", (Object)this.uddiKey).append("stabilityExpectations", (Object)this.stabilityExpectations).append("technicalServices", this.technicalServices).append("nonFunctionalRqmts", this.nonFunctionalRqmts).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XfaceStyle {
        DIGITAL,
        DUAL,
        NONDIGITAL,
        UNDECIDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Visibility {
        CUSTOMERS,
        ENTERPRISE_INTERNAL,
        ORG_UNIT_INTERNAL,
        PARTITION_INTERNAL,
        PARTNER_ORGANIZATIONS,
        PUBLIC,
        SPECIFIC_CUSTOMERS,
        SPECIFIC_PARTNERS;

    }
}

