/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.specification.ServiceInterface")
@Searchable(root=false)
public class ServiceInterface
extends TModel {
    private static final long serialVersionUID = 4970986248323341443L;
    private Set<Binding> bindings;
    private String fullName;
    private Set<ServiceSpecification> serviceSpecs;
    private Set<SpecifiedOperation> specifiedOps = new HashSet<SpecifiedOperation>();

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ServiceInterface)) {
            return false;
        }
        ServiceInterface castOther = (ServiceInterface)other;
        return new EqualsBuilder().append((Object)this.fullName, (Object)castOther.fullName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fullName).toHashCode();
    }

    public ServiceInterface() {
        this.bindings = new HashSet<Binding>();
        this.serviceSpecs = new HashSet<ServiceSpecification>();
    }

    public void addBinding(Binding binding) {
        this.getBindings().add(binding);
        binding.setServiceInterface(this);
    }

    public void addSpecifiedOp(SpecifiedOperation specifiedOperation) {
        this.getSpecifiedOps().add(specifiedOperation);
        specifiedOperation.setServiceInterface(this);
    }

    @OneToMany(mappedBy="serviceInterface")
    public Set<Binding> getBindings() {
        return this.bindings;
    }

    public String getFullName() {
        return this.fullName;
    }

    @ManyToMany(mappedBy="serviceInterfaces")
    public Set<ServiceSpecification> getServiceSpecs() {
        return this.serviceSpecs;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="serviceInterface")
    @SearchableComponent
    public Set<SpecifiedOperation> getSpecifiedOps() {
        return this.specifiedOps;
    }

    public void setBindings(Set<Binding> bindings) {
        this.bindings = bindings;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setServiceSpecs(Set<ServiceSpecification> serviceSpecs) {
        this.serviceSpecs = serviceSpecs;
    }

    public void setSpecifiedOps(Set<SpecifiedOperation> specifiedOps) {
        this.specifiedOps = specifiedOps;
    }
}

