/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.service.ProposedOperation;
import org.ow2.dragon.persistence.bo.specification.MessageSpecification;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.specification.SpecifiedOperation")
@Searchable(root=false)
public class SpecifiedOperation
extends SearchableBaseObject {
    private static final long serialVersionUID = 319403999125489629L;
    private Set<BindingOperation> bindingOps;
    private boolean canParticipateInTransaction;
    private boolean isAtomicTransaction;
    private boolean isNonUpdating;
    private boolean isTransactionCoordNeeded;
    private Set<MessageSpecification> messageSpecs;
    private String name;
    private String signature;
    private Set<ProposedOperation> proposedOps = new HashSet<ProposedOperation>();
    private String purpose;
    private ServiceInterface serviceInterface;
    private String transactionCoordIsBy;
    private OpTmType transmission;

    public SpecifiedOperation() {
        this.messageSpecs = new HashSet<MessageSpecification>();
        this.bindingOps = new HashSet<BindingOperation>();
    }

    public void addBindingOp(BindingOperation bindingOperation) {
        this.getBindingOps().add(bindingOperation);
        bindingOperation.setSpecifiedOp(this);
    }

    public void addMessageSpec(MessageSpecification messageSpecification) {
        this.getMessageSpecs().add(messageSpecification);
    }

    public void addProposedOp(ProposedOperation proposedOperation) {
        this.getProposedOps().add(proposedOperation);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SpecifiedOperation)) {
            return false;
        }
        SpecifiedOperation castOther = (SpecifiedOperation)other;
        return new EqualsBuilder().append((Object)this.signature, (Object)castOther.signature).isEquals();
    }

    @OneToMany(mappedBy="specifiedOp")
    public Set<BindingOperation> getBindingOps() {
        return this.bindingOps;
    }

    @ManyToMany
    public Set<MessageSpecification> getMessageSpecs() {
        return this.messageSpecs;
    }

    @SearchableProperty
    public String getName() {
        return this.name;
    }

    @ManyToMany
    public Set<ProposedOperation> getProposedOps() {
        return this.proposedOps;
    }

    @SearchableProperty
    @Column(length=0x100000)
    public String getPurpose() {
        return this.purpose;
    }

    @ManyToOne
    @JoinColumn(name="serviceIntId", nullable=false)
    public ServiceInterface getServiceInterface() {
        return this.serviceInterface;
    }

    public String getTransactionCoordIsBy() {
        return this.transactionCoordIsBy;
    }

    @Enumerated(value=EnumType.STRING)
    public OpTmType getTransmission() {
        return this.transmission;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.signature).toHashCode();
    }

    public boolean isAtomicTransaction() {
        return this.isAtomicTransaction;
    }

    public boolean isCanParticipateInTransaction() {
        return this.canParticipateInTransaction;
    }

    public boolean isNonUpdating() {
        return this.isNonUpdating;
    }

    public boolean isTransactionCoordNeeded() {
        return this.isTransactionCoordNeeded;
    }

    public void setAtomicTransaction(boolean isAtomicTransaction) {
        this.isAtomicTransaction = isAtomicTransaction;
    }

    public void setBindingOps(Set<BindingOperation> bindingOps) {
        this.bindingOps = bindingOps;
    }

    public void setCanParticipateInTransaction(boolean canParticipateInTransaction) {
        this.canParticipateInTransaction = canParticipateInTransaction;
    }

    public void setMessageSpecs(Set<MessageSpecification> messageSpecs) {
        this.messageSpecs = messageSpecs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNonUpdating(boolean isNonUpdating) {
        this.isNonUpdating = isNonUpdating;
    }

    public void setProposedOps(Set<ProposedOperation> proposedOps) {
        this.proposedOps = proposedOps;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void setServiceInterface(ServiceInterface serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setTransactionCoordIsBy(String transactionCoordIsBy) {
        this.transactionCoordIsBy = transactionCoordIsBy;
    }

    public void setTransactionCoordNeeded(boolean isTransactionCoordNeeded) {
        this.isTransactionCoordNeeded = isTransactionCoordNeeded;
    }

    public void setTransmission(OpTmType transmission) {
        this.transmission = transmission;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("transmission", (Object)this.transmission).append("canParticipateInTransaction", this.canParticipateInTransaction).append("bindingOps", this.bindingOps).append("transactionCoordIsBy", (Object)this.transactionCoordIsBy).append("proposedOps", this.proposedOps).append("purpose", (Object)this.purpose).append("isNonUpdating", this.isNonUpdating).append("isTransactionCoordNeeded", this.isTransactionCoordNeeded).append("isAtomicTransaction", this.isAtomicTransaction).append("name", (Object)this.name).append("messageSpecs", this.messageSpecs).toString();
    }

    @Column(length=0x100000)
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpTmType {
        NOTIFICATION,
        ONEWAY,
        REQUEST_RESPONSE,
        SOLICIT_RESPONSE,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpStyleType {
        DOCUMENT,
        PARAMETERS,
        UNKNOWN;

    }
}

