/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.util;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.ow2.dragon.util.RegistryConfig;
import org.ow2.dragon.util.StringHelper;

public class UDDIIdentifierGenerator
implements IdentifierGenerator {
    public static final String UDDI_V3_SCHEME = "uddi";
    public static final String UDDI_V2_SCHEME = "uuid";
    private static final String PARTITION_SEPARATOR = ":";
    private static final String ROOT_DOMAIN = "root.domain";
    private Logger log = Logger.getLogger(UDDIIdentifierGenerator.class);
    private static DualHashBidiMap uddiV2toV3Key = new DualHashBidiMap();

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        Object id = session.getEntityPersister(null, object).getIdentifier(object, session.getEntityMode());
        if (id == null || id instanceof String && StringHelper.isNullOrEmpty((String)((String)id))) {
            id = UDDIIdentifierGenerator.getUddiV3KeyPrefix() + this.getUUID();
        }
        return id;
    }

    private synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGUID(SessionImplementor session) {
        String string;
        String sql = session.getFactory().getDialect().getSelectGUIDString();
        PreparedStatement st = session.getBatcher().prepareSelectStatement(sql);
        try {
            String result;
            ResultSet rs = st.executeQuery();
            try {
                rs.next();
                result = rs.getString(1);
            }
            finally {
                rs.close();
            }
            this.log.debug((Object)("GUID identifier generated: " + result));
            string = result;
        }
        catch (Throwable throwable) {
            try {
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert((SQLExceptionConverter)session.getFactory().getSQLExceptionConverter(), (SQLException)sqle, (String)"could not retrieve GUID", (String)sql);
            }
        }
        session.getBatcher().closeStatement(st);
        return string;
    }

    public static String toUddiV2Id(String uddiV3Id) {
        String v2Key = null;
        if (!StringHelper.isNullOrEmpty((String)uddiV3Id) && (v2Key = (String)uddiV2toV3Key.getKey((Object)(uddiV3Id = uddiV3Id.toLowerCase()))) == null) {
            if (!uddiV3Id.startsWith(UDDIIdentifierGenerator.getUddiV3KeyPrefix())) {
                throw new HibernateException("Trying to use an invalid uddi v3 key ('" + uddiV3Id + "'). Valid v3 key for this registry are: '" + UDDIIdentifierGenerator.getUddiV3KeyPrefix() + "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx'");
            }
            v2Key = UDDIIdentifierGenerator.getUddiV2KeyPrefix() + uddiV3Id.substring(UDDIIdentifierGenerator.getUddiV3KeyPrefix().length());
        }
        return v2Key;
    }

    private static String getUddiV3KeyPrefix() {
        String rootDomain = "";
        try {
            rootDomain = RegistryConfig.getConfiguration().getString(ROOT_DOMAIN);
        }
        catch (ConfigurationException ce) {
            throw new HibernateException("Can't retrieve root.domain property from registry config file", (Throwable)ce);
        }
        return "uddi:" + rootDomain + PARTITION_SEPARATOR;
    }

    private static String getUddiV2KeyPrefix() {
        return "uuid:";
    }

    public static String toUddiV3Id(String uddiV2Id) {
        String v3Key = null;
        if (!StringHelper.isNullOrEmpty((String)uddiV2Id) && (v3Key = (String)uddiV2toV3Key.get((Object)(uddiV2Id = uddiV2Id.toLowerCase()))) == null) {
            if (!uddiV2Id.startsWith(UDDIIdentifierGenerator.getUddiV2KeyPrefix())) {
                throw new HibernateException("Trying to use an invalid uddi v2 key ('" + uddiV2Id + "'). Valid v2 key are: '" + UDDIIdentifierGenerator.getUddiV2KeyPrefix() + "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx'");
            }
            v3Key = UDDIIdentifierGenerator.getUddiV3KeyPrefix() + uddiV2Id.substring(UDDIIdentifierGenerator.getUddiV2KeyPrefix().length());
        }
        return v3Key;
    }

    public static boolean isUddiV3ValidId(String uddiV3Id) {
        boolean result = uddiV2toV3Key.containsValue((Object)uddiV3Id);
        if (!result) {
            result = uddiV3Id.startsWith(UDDIIdentifierGenerator.getUddiV3KeyPrefix());
        }
        return result;
    }

    static {
        uddiV2toV3Key.put((Object)"uuid:C1ACF26D-9672-4404-9D70-39B756E62AB4", (Object)"uddi:uddi.org:categorization:types");
        uddiV2toV3Key.put((Object)"uuid:A035A07C-F362-44dd-8F95-E2B134BF43B4", (Object)"uddi:uddi.org:categorization:general_keywords");
        uddiV2toV3Key.put((Object)"uuid:327A56F0-3299-4461-BC23-5CD513E95C55", (Object)"uddi:uddi.org:categorization:nodes");
        uddiV2toV3Key.put((Object)"uuid:807A2C6A-EE22-470D-ADC7-E0424A337C03", (Object)"uddi:uddi.org:relationships");
        uddiV2toV3Key.put((Object)"uuid:4064C064-6D14-4F35-8953-9652106476A9", (Object)"uddi:uddi.org:categorization:owningbusiness");
        uddiV2toV3Key.put((Object)"uuid:E59AE320-77A5-11D5-B898-0004AC49CC1E", (Object)"uddi:uddi.org:identifier:isreplacedby");
        uddiV2toV3Key.put((Object)"uuid:25b22e3e-3dfa-3024-b02a-3438b9050b59", (Object)"uddi:uddi.org:categorization:validatedby");
        uddiV2toV3Key.put((Object)"uuid:5678dd4f-f95d-35f9-9ea6-f79a7dd64656", (Object)"uddi:uddi.org:categorization:derivedfrom");
        uddiV2toV3Key.put((Object)"uuid:916b87bf-0756-3919-8eae-97dfa325e5a4", (Object)"uddi:uddi.org:categorization:entitykeyvalues");
        uddiV2toV3Key.put((Object)"uuid:c8aea832-3faf-33c6-b32a-bbfd1b926294", (Object)"uddi:uddi.org:protocol:serverauthenticatedssl3");
        uddiV2toV3Key.put((Object)"uuid:9555b5b6-55d4-3b0e-bb17-e084fed4e33f", (Object)"uddi:uddi.org:protocol:mutualauthenticatedssl3");
        uddiV2toV3Key.put((Object)"uuid:68DE9E80-AD09-469D-8A37-088422BFBC36", (Object)"uddi:uddi.org:transport:http");
        uddiV2toV3Key.put((Object)"uuid:93335D49-3EFB-48A0-ACEA-EA102B60DDC6", (Object)"uddi:uddi.org:transport:smtp");
        uddiV2toV3Key.put((Object)"uuid:5FCF5CD0-629A-4C50-8B16-F94E9CF2A674", (Object)"uddi:uddi.org:transport:ftp");
        uddiV2toV3Key.put((Object)"uuid:1A2B00BE-6E2C-42F5-875B-56F32686E0E7", (Object)"uddi:uddi.org:transport:fax");
        uddiV2toV3Key.put((Object)"uuid:38E12427-5536-4260-A6F9-B5B530E63A07", (Object)"uddi:uddi.org:transport:telephone");
        uddiV2toV3Key.put((Object)"uuid:c0b9fe13-179f-413d-8a5b-5004db8e5bb2", (Object)"uddi:uddi.org:ubr:categorization:naics:1997");
        uddiV2toV3Key.put((Object)"uuid:1ff729f2-1948-46cf-b660-31ec107f1663", (Object)"uddi:uddi.org:ubr:categorization:naics:2002");
        uddiV2toV3Key.put((Object)"uuid:cd153257-086a-4237-b336-6bdcbdcc6634", (Object)"uddi:cd153257-086a-4237-b336-6bdcbdcc6634");
        uddiV2toV3Key.put((Object)"uuid:4614c240-b483-11d7-8be8-000629dc0a53", (Object)"uddi:uddi.org:ubr:categorization:unspsc");
        uddiV2toV3Key.put((Object)"uuid:4e49a8d6-d5a2-4fc2-93a0-0411d8d19e88", (Object)"uddi:uddi.org:ubr:categorization:iso3166");
        uddiV2toV3Key.put((Object)"uuid:8609c81e-ee1f-4d5a-b202-3eb13ad01823", (Object)"uddi:uddi.org:ubr:identifier:dnb.com:d-u-n-s");
        uddiV2toV3Key.put((Object)"uuid:B1B1BAF5-2329-43E6-AE13-BA8E97195039", (Object)"uddi:uddi.org:ubr:identifier:thomasregister.com:supplierid");
        uddiV2toV3Key.put((Object)"uuid:f1b347da-6cbb-3a10-93e7-7cd4328b88d3", (Object)"uddi:uddi.org:ubr:identifier:iso6523icd");
        uddiV2toV3Key.put((Object)"uuid:01b9bbff-a8f5-3735-9a5e-5ea5ade7daaf", (Object)"uddi:uddi.org:v3_inquiry");
        uddiV2toV3Key.put((Object)"uuid:72ade754-c6cc-315b-b014-7c94791fe15c", (Object)"uddi:uddi.org:v3_publication");
        uddiV2toV3Key.put((Object)"uuid:6e090afa-33e5-36eb-81b7-1ca18373f457", (Object)"uddi:uddi.org:wsdl:types");
        uddiV2toV3Key.put((Object)"uuid:d01987d1-ab2e-3013-9be2-2a66eb99d824", (Object)"uddi:uddi.org:xml:namespace");
        uddiV2toV3Key.put((Object)"uuid:2ec65201-9109-3919-9bec-c9dbefcaccf6", (Object)"uddi:uddi.org:xml:localname");
        uddiV2toV3Key.put((Object)"uuid:082b0851-25d8-303c-b332-f24a6d53e38e", (Object)"uddi:uddi.org:wsdl:porttypereference");
        uddiV2toV3Key.put((Object)"uuid:aa254698-93de-3870-8df3-a5c075d64a0e", (Object)"uddi:uddi.org:protocol:soap");
        uddiV2toV3Key.put((Object)"uuid:6e10b91b-babc-3442-b8fc-5a3c8fde0794", (Object)"uddi:uddi.org:protocol:http");
        uddiV2toV3Key.put((Object)"uuid:4dc74177-7806-34d9-aecd-33c57dc3a865", (Object)"uddi:uddi.org:wsdl:categorization:protocol");
        uddiV2toV3Key.put((Object)"uuid:e5c43936-86e4-37bf-8196-1d04b35c0099", (Object)"uddi:uddi.org:wsdl:categorization:transport");
        uddiV2toV3Key.put((Object)"uuid:ad61de98-4db8-31b2-a299-a2373dc97212", (Object)"uddi:uddi.org:wsdl:address");
    }
}

