/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Comment;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Rating;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.dao.UniversalUnifiedDAO;
import org.ow2.dragon.persistence.dao.deployment.CommentDAO;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointManagerImpl
implements EndpointManager {
    private EndpointDAO endpointDAO;
    private UniversalUnifiedDAO universalUnifiedDAO;
    private TransfertObjectAssembler transfertObjectAssembler;
    private CommentDAO commentDAO;

    public void setCommentDAO(CommentDAO commentDAO) {
        this.commentDAO = commentDAO;
    }

    @Override
    public String createEndpoint(EndpointTO endpointTO) throws DeploymentException {
        throw new RuntimeException("not implemented method");
    }

    @Override
    public List<EndpointTO> getAllEndpoints(RequestOptionsTO requestOptionsTO) throws DeploymentException {
        ArrayList<EndpointTO> result = new ArrayList<EndpointTO>();
        List<Endpoint> endpoints = this.endpointDAO.getAll(this.transfertObjectAssembler.toEndpointRequestOptions(requestOptionsTO));
        this.toEndpointsTO(result, endpoints);
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public EndpointTO getEndpoint(String endpointId, String user) throws DeploymentException {
        Endpoint endpointBO = (Endpoint)this.endpointDAO.get(endpointId);
        EndpointTO endpointTO = this.toEndpointTO(endpointBO, user);
        return endpointTO;
    }

    @Override
    public List<EndpointTO> getEndpointsByBinding(String bindingId, RequestOptionsTO requestOptionsTO) throws DeploymentException {
        throw new RuntimeException("not implemented method");
    }

    @Override
    public List<EndpointTO> getEndpointsByTechService(String techServiceId, RequestOptionsTO requestOptionsTO) throws DeploymentException {
        ArrayList<EndpointTO> result = new ArrayList<EndpointTO>();
        RequestOptions requestOptions = this.transfertObjectAssembler.toEndpointRequestOptions(requestOptionsTO);
        if (requestOptions != null) {
            requestOptions.setCaseSensitive(true);
        }
        List<Endpoint> endpoints = this.endpointDAO.searchEquals(new String[]{techServiceId}, new String[]{"technicalService.id"}, requestOptions);
        this.toEndpointsTO(result, endpoints);
        return result;
    }

    @Override
    public void removeEndpoint(String endpointId) throws DeploymentException {
        this.endpointDAO.remove(endpointId);
    }

    public void setEndpointDAO(EndpointDAO endpointDAO) {
        this.endpointDAO = endpointDAO;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    private void toEndpointsTO(List<EndpointTO> result, Collection<Endpoint> endpoints) {
        if (endpoints != null && !endpoints.isEmpty()) {
            for (Endpoint endpoint : endpoints) {
                EndpointTO endpointTO = this.toEndpointTO(endpoint, null);
                endpointTO.setGlobalRating(this.updateGlobalRating(endpointTO.getId()));
                result.add(endpointTO);
            }
        }
    }

    private EndpointTO toEndpointTO(Endpoint endpoint, String user) {
        return this.transfertObjectAssembler.toEndpointTO(endpoint, user);
    }

    @Override
    public String updateEndpoint(EndpointTO endpointTO) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(endpointTO.getId());
        if (endpoint == null) {
            throw new DeploymentException("Your are trying to update a non existing Endpoint with id: " + endpointTO.getId());
        }
        this.transfertObjectAssembler.toEndpointBO(endpointTO, endpoint);
        this.endpointDAO.save(endpoint);
        return endpoint.getId();
    }

    @Override
    public float updateGlobalRating(String endpointId) {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(endpointId);
        float globalRating = 0.0f;
        if (!endpoint.getRatings().isEmpty()) {
            Iterator<Rating> iter = endpoint.getRatings().iterator();
            int size = endpoint.getRatings().size();
            while (iter.hasNext()) {
                globalRating += (float)iter.next().getMyRating();
            }
            globalRating /= (float)size;
        }
        return globalRating;
    }

    @Override
    public void updateComments(String endpointId, CommentTO comment) {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(endpointId);
        if (endpoint != null) {
            Comment commentTemp = new Comment();
            commentTemp.setContent(comment.getContent());
            commentTemp.setDate(comment.getDate());
            commentTemp.setUserName(comment.getUserName());
            commentTemp.setId(comment.getId());
            endpoint.addComment(commentTemp);
        }
    }

    @Override
    public List<EndpointTO> getEndpointsByTag(String tag) {
        ArrayList<EndpointTO> result = new ArrayList<EndpointTO>();
        List allEndpoints = this.endpointDAO.getAll();
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (Endpoint endpointTemp : allEndpoints) {
            if (!endpointTemp.isTagged(tag)) continue;
            endpoints.add(endpointTemp);
        }
        this.toEndpointsTO(result, endpoints);
        return result;
    }

    @Override
    public void removeTag(String tag, String endpointId) {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(endpointId);
        Set<String> tags = endpoint.getTags();
        tags.remove(tag);
        endpoint.setTags(tags);
    }

    @Override
    public void removeComment(String endpointId, String commentId) {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(endpointId);
        Comment comment = (Comment)this.commentDAO.get(commentId);
        List<Comment> comments = endpoint.getComments();
        comments.remove(comment);
        endpoint.setComments(comments);
    }

    @Override
    public List<KeyedRefTO> getCategoriesForEndpoint(String endpointId) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(endpointId);
        if (endpoint == null) {
            throw new DeploymentException("No endpoint found for the given id: " + endpointId);
        }
        return this.transfertObjectAssembler.toCategoriesTO(endpoint.getCategoryBag());
    }

    @Override
    public void removeCategories(String techServiceId, List<String> categoryIds) {
        if (categoryIds != null) {
            Endpoint endpoint = (Endpoint)this.endpointDAO.get(techServiceId);
            List keyRefs = this.universalUnifiedDAO.getAll(KeyedReference.class, categoryIds);
            endpoint.getCategoryBag().getKeyedReferences().removeAll(keyRefs);
            this.universalUnifiedDAO.removeAll(keyRefs);
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addCategory(String techServiceId, String categoryId, String categoryValueId) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(techServiceId);
        Category category = (Category)this.universalUnifiedDAO.get(Category.class, (Serializable)((Object)categoryId));
        CategoryValue value = (CategoryValue)this.universalUnifiedDAO.get(CategoryValue.class, (Serializable)((Object)categoryValueId));
        if (endpoint != null && category != null) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(value.getDescription());
            keyedReference.setKeyValue(value.getValue());
            this.validateCategory(endpoint, keyedReference);
            CategoryBag categoryBag = endpoint.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                endpoint.setCategoryBag(categoryBag);
            }
        } else {
            throw new DeploymentException("You have specified unknown endpoint, category system or category value");
        }
        this.endpointDAO.save(endpoint);
    }

    private void validateCategory(Endpoint endpoint, KeyedReference keyedReference) throws DeploymentException {
        List<KeyedReference> keyedReferences;
        CategoryBag categoryBag = endpoint.getCategoryBag();
        if (categoryBag != null && (keyedReferences = categoryBag.getKeyedReferences()) != null && keyedReferences.contains(keyedReference)) {
            throw new DeploymentException("Category already added to this endpoint.");
        }
    }

    @Override
    @CheckArgumentsNotNull
    public void addCategory(String techServiceId, String categoryId, String categoryValue, String categoryDesc) throws DeploymentException {
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(techServiceId);
        Category category = (Category)this.universalUnifiedDAO.get(Category.class, (Serializable)((Object)categoryId));
        if (endpoint != null && category != null) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(categoryDesc);
            keyedReference.setKeyValue(categoryValue);
            this.validateCategory(endpoint, keyedReference);
            CategoryBag categoryBag = endpoint.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                endpoint.setCategoryBag(categoryBag);
            }
        } else {
            throw new DeploymentException("You have specified unknown endpoint, category system or category value");
        }
        this.endpointDAO.save(endpoint);
    }

    public void setUniversalUnifiedDAO(UniversalUnifiedDAO universalUnifiedDAO) {
        this.universalUnifiedDAO = universalUnifiedDAO;
    }
}

