/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.aop.annotation.NotNullParam;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.ServiceSearchProperties;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Comment;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Rating;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.dao.DAOLayerException;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.persistence.dao.UniversalUnifiedDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingDAO;
import org.ow2.dragon.persistence.dao.deployment.CommentDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceInterfaceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceSpecificationDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.util.SearchHelper;
import org.ow2.dragon.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechServiceManagerImpl
implements TechServiceManager {
    private GenericUnifiedDAO<TechnicalService, String> technicalServiceUnifiedDAO;
    private UniversalUnifiedDAO universalUnifiedDAO;
    private TransfertObjectAssembler transfertObjectAssembler;
    private MetadataService metadataService;
    private ServiceSpecificationDAO serviceSpecificationDAO;
    private BindingDAO bindingDAO;
    private ServiceInterfaceDAO serviceInterfaceDAO;
    private CommentDAO commentDAO;

    public void setCommentDAO(CommentDAO commentDAO) {
        this.commentDAO = commentDAO;
    }

    private String[] createSearchProperties(List<ServiceSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)ServiceSearchProperties.NAME)) {
                propertiesList.add("fullName");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.CATEGORY)) {
                propertiesList.add("categoryBag.keyedReferences.keyValue");
                propertiesList.add("categoryBag.keyedReferences.keyName");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.PURPOSE)) {
                propertiesList.add("descriptions.description");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.OPERATIONS)) {
                propertiesList.add("endpoints.binding.serviceInterface.specifiedOps.name");
                propertiesList.add("endpoints.binding.serviceInterface.specifiedOps.purpose");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.PROTOCOL)) {
                propertiesList.add("endpoints.binding.protocols.name.name");
                propertiesList.add("endpoints.binding.transports.name.name");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.ORGANIZATION)) {
                propertiesList.add("toLinks.type");
                propertiesList.add("toLinks.from.names.name");
            }
            if (searchedProperties.contains((Object)ServiceSearchProperties.RELATED_DOCS)) {
                propertiesList.add("relatedDocs.author");
                propertiesList.add("relatedDocs.title");
                propertiesList.add("relatedDocs.extractedContent");
            }
        } else {
            propertiesList.add("fullName");
            propertiesList.add("categoryBag.keyedReferences.keyValue");
            propertiesList.add("categoryBag.keyedReferences.keyName");
            propertiesList.add("descriptions.description");
            propertiesList.add("endpoints.binding.serviceInterface.specifiedOps.name");
            propertiesList.add("endpoints.binding.serviceInterface.specifiedOps.purpose");
            propertiesList.add("endpoints.binding.protocols.name.name");
            propertiesList.add("endpoints.binding.transports.name.name");
            propertiesList.add("toLinks.type");
            propertiesList.add("toLinks.from.names.name");
            propertiesList.add("relatedDocs.author");
            propertiesList.add("relatedDocs.title");
            propertiesList.add("relatedDocs.extractedContent");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    public String createTechService(TechnicalServiceTO techServiceTO) throws DeploymentException {
        throw new RuntimeException("not implemented method");
    }

    @Override
    public List<TechnicalServiceTO> getAllTechServices(RequestOptionsTO requestOptionsTO) throws DeploymentException {
        ArrayList<TechnicalServiceTO> result = new ArrayList<TechnicalServiceTO>();
        List<TechnicalService> techServices = this.technicalServiceUnifiedDAO.getAll(this.transfertObjectAssembler.toServiceRequestOptions(requestOptionsTO));
        this.toTechServicesTO(result, techServices);
        return result;
    }

    private void toTechServicesTO(List<TechnicalServiceTO> result, Collection<TechnicalService> techServices) {
        if (techServices != null && !techServices.isEmpty()) {
            for (TechnicalService techServ : techServices) {
                TechnicalServiceTO techTO = this.toTechServiceTO(techServ, null);
                techTO.setGlobalRating(this.updateGlobalRating(techTO.getId()));
                result.add(techTO);
            }
        }
    }

    private TechnicalServiceTO toTechServiceTO(TechnicalService techServ, String user) {
        return this.transfertObjectAssembler.toTechServiceTO(techServ, user);
    }

    @Override
    public EndpointTO getEndpoint(String techServiceName, String endpointName) throws DeploymentException {
        EndpointTO res = null;
        ArrayList<EndpointTO> results = new ArrayList<EndpointTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)techServiceName);
        List<TechnicalService> techServicesBO = this.technicalServiceUnifiedDAO.searchLike(criteria, null, null);
        for (TechnicalService service : techServicesBO) {
            Set<Endpoint> endpointsBO = service.getEndpoints();
            if (endpointsBO == null || endpointsBO.isEmpty()) continue;
            for (Endpoint endpoint : endpointsBO) {
                if (!endpoint.getName().equals(endpointName)) continue;
                results.add(this.toEndpointTO(endpoint));
            }
        }
        if (results.size() == 1) {
            res = (EndpointTO)results.get(0);
        }
        return res;
    }

    private EndpointTO toEndpointTO(Endpoint endpoint) {
        return this.transfertObjectAssembler.toEndpointTO(endpoint, null);
    }

    @Override
    public TechnicalServiceTO getTechService(String techServiceId, String user) throws DeploymentException {
        TechnicalService technicalServiceBO = this.technicalServiceUnifiedDAO.get(techServiceId);
        TechnicalServiceTO techServiceTO = this.toTechServiceTO(technicalServiceBO, user);
        return techServiceTO;
    }

    @Override
    public List<TechnicalServiceTO> loadServicesFromWSDL(String[] servicesId, RequestOptionsTO requestOptionsTO) throws DeploymentException {
        ArrayList<TechnicalServiceTO> techServs = new ArrayList<TechnicalServiceTO>();
        if (servicesId != null) {
            for (String servId : servicesId) {
                TechnicalServiceTO serviceTO = this.getTechService(servId, null);
                if (serviceTO == null) continue;
                techServs.add(serviceTO);
            }
        }
        return techServs;
    }

    @Override
    public void removeTechService(String techServiceId) throws DeploymentException {
        Set<ServiceSpecification> serviceSpecifications;
        TechnicalService technicalService = this.technicalServiceUnifiedDAO.get(techServiceId);
        if (technicalService != null && (serviceSpecifications = technicalService.getServiceSpecifications()) != null) {
            for (ServiceSpecification serviceSpecification : serviceSpecifications) {
                this.deleteTechServices(serviceSpecification);
                this.deleteBindings(serviceSpecification);
                this.deleteServiceInterfaces(serviceSpecification);
                this.serviceSpecificationDAO.remove(serviceSpecification.getId());
            }
        }
    }

    private void deleteServiceInterfaces(ServiceSpecification serviceSpecification) {
        Set<ServiceInterface> interfaces = serviceSpecification.getServiceInterfaces();
        if (interfaces != null) {
            for (ServiceInterface serviceInterface : interfaces) {
                this.serviceInterfaceDAO.remove(serviceInterface.getId());
            }
        }
    }

    private void deleteBindings(ServiceSpecification serviceSpecification) {
        Set<Binding> bindings = serviceSpecification.getBindings();
        if (bindings != null) {
            for (Binding binding : bindings) {
                this.bindingDAO.remove(binding.getId());
            }
        }
    }

    private void deleteTechServices(ServiceSpecification serviceSpecification) {
        Set<TechnicalService> techServs = serviceSpecification.getTechnicalServices();
        if (techServs != null) {
            for (TechnicalService technicalService2 : techServs) {
                this.technicalServiceUnifiedDAO.remove(technicalService2.getId());
            }
        }
    }

    @Override
    public List<TechnicalServiceTO> searchTechService(String searchCriteria, List<ServiceSearchProperties> searchedProperties, RequestOptionsTO options) throws DeploymentException {
        List<TechnicalService> techServices;
        ArrayList<TechnicalServiceTO> result = new ArrayList<TechnicalServiceTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createSearchProperties(searchedProperties);
        try {
            techServices = this.technicalServiceUnifiedDAO.searchORMResult(criteria, properties, this.transfertObjectAssembler.toServiceRequestOptions(options));
        }
        catch (DAOLayerException e) {
            throw new DeploymentException("You must specified non empty search criteria and properties.", e);
        }
        this.toTechServicesTO(result, techServices);
        return result;
    }

    public void setBindingDAO(BindingDAO bindingDAO) {
        this.bindingDAO = bindingDAO;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setServiceInterfaceDAO(ServiceInterfaceDAO serviceInterfaceDAO) {
        this.serviceInterfaceDAO = serviceInterfaceDAO;
    }

    public void setServiceSpecificationDAO(ServiceSpecificationDAO serviceSpecificationDAO) {
        this.serviceSpecificationDAO = serviceSpecificationDAO;
    }

    public void setTechnicalServiceUnifiedDAO(GenericUnifiedDAO<TechnicalService, String> technicalServiceUnifiedDAO) {
        this.technicalServiceUnifiedDAO = technicalServiceUnifiedDAO;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    @Override
    public String updateTechService(TechnicalServiceTO techServiceTO) throws DeploymentException {
        TechnicalService technicalService = this.technicalServiceUnifiedDAO.get(techServiceTO.getId());
        if (technicalService == null) {
            throw new DeploymentException("Your are trying to update a non existing Technical Service with id: " + techServiceTO.getId());
        }
        this.transfertObjectAssembler.toTechServiceBO(techServiceTO, technicalService);
        this.technicalServiceUnifiedDAO.save(technicalService);
        return technicalService.getId();
    }

    @Override
    public String getRelatedDocContentAsString(String relatedDocId) throws DeploymentException {
        String result = null;
        try {
            InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(relatedDocId);
            result = StringHelper.toString((InputStream)inputStream);
        }
        catch (MetadataServiceException e) {
            throw new DeploymentException("Can't load related doc content", e);
        }
        catch (IOException e) {
            throw new DeploymentException("Can't convert related doc content to String", e);
        }
        return result;
    }

    @Override
    public InputStream getRelatedDocContent(String relatedDocId) throws DeploymentException {
        InputStream result = null;
        try {
            result = this.metadataService.loadMetadataContentAsInputStream(relatedDocId);
        }
        catch (MetadataServiceException e) {
            throw new DeploymentException("Can't load related doc content", e);
        }
        return result;
    }

    @Override
    public List<SimpleFileTO> getRelatedDocsForTechServ(String techServiceId) throws DeploymentException {
        ArrayList<SimpleFileTO> result = new ArrayList<SimpleFileTO>();
        TechnicalService technicalServiceBO = this.technicalServiceUnifiedDAO.get(techServiceId);
        Set<SimpleFile> relatedDocs = technicalServiceBO.getRelatedDocs();
        for (SimpleFile simpleFile : relatedDocs) {
            result.add(this.transfertObjectAssembler.toSimpleFileTO(simpleFile));
        }
        return result;
    }

    private void addRelatedDocs(String serviceId, Set<SimpleFile> relatedDocs) {
        if (!relatedDocs.isEmpty()) {
            TechnicalService service = this.technicalServiceUnifiedDAO.get(serviceId);
            for (SimpleFile relatedDoc : relatedDocs) {
                service.addRelatedDoc(relatedDoc);
            }
            this.technicalServiceUnifiedDAO.save(service);
        }
    }

    @Override
    public String registerRelatedDoc(String serviceId, String mimetype, byte[] docContent) throws DeploymentException {
        SimpleFile doc = null;
        try {
            doc = this.metadataService.storeMetadataAndIndexContent(mimetype, docContent);
        }
        catch (MetadataServiceException e) {
            throw new DeploymentException("Can't store document in registry", e);
        }
        HashSet<SimpleFile> docs = new HashSet<SimpleFile>();
        docs.add(doc);
        this.addRelatedDocs(serviceId, docs);
        return doc.getId();
    }

    @Override
    public void removeRelatedDoc(String serviceId, String documentId) {
        TechnicalService technicalService = this.technicalServiceUnifiedDAO.get(serviceId);
        SimpleFile simpleFile = this.metadataService.loadMetadata(documentId);
        technicalService.getRelatedDocs().remove(simpleFile);
        this.metadataService.deleteMetadata(documentId);
    }

    @Override
    @CheckArgumentsNotNull
    public void addCategory(@NotNullParam String techServiceId, @NotNullParam String categoryId, @NotNullParam String categoryValue, String categoryDesc) throws DeploymentException {
        TechnicalService service = this.technicalServiceUnifiedDAO.get(techServiceId);
        Category category = (Category)this.universalUnifiedDAO.get(Category.class, (Serializable)((Object)categoryId));
        if (service != null && category != null) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(categoryDesc);
            keyedReference.setKeyValue(categoryValue);
            this.validateCategory(service, keyedReference);
            CategoryBag categoryBag = service.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                service.setCategoryBag(categoryBag);
            }
        } else {
            throw new DeploymentException("You have specified unknown service, category system or category value");
        }
        this.technicalServiceUnifiedDAO.save(service);
    }

    @Override
    @CheckAllArgumentsNotNull
    public void addCategory(String techServiceId, String categoryId, String categoryValueId) throws DeploymentException {
        TechnicalService service = this.technicalServiceUnifiedDAO.get(techServiceId);
        Category category = (Category)this.universalUnifiedDAO.get(Category.class, (Serializable)((Object)categoryId));
        CategoryValue value = (CategoryValue)this.universalUnifiedDAO.get(CategoryValue.class, (Serializable)((Object)categoryValueId));
        if (service != null && category != null) {
            KeyedReference keyedReference = new KeyedReference();
            keyedReference.setTmodel(category);
            keyedReference.setKeyName(value.getDescription());
            keyedReference.setKeyValue(value.getValue());
            this.validateCategory(service, keyedReference);
            CategoryBag categoryBag = service.getCategoryBag();
            if (categoryBag != null) {
                categoryBag.addKeyedReference(keyedReference);
            } else {
                categoryBag = new CategoryBag();
                categoryBag.addKeyedReference(keyedReference);
                service.setCategoryBag(categoryBag);
            }
        } else {
            throw new DeploymentException("You have specified unknown service, category system or category value");
        }
        this.technicalServiceUnifiedDAO.save(service);
    }

    private void validateCategory(TechnicalService techServ, KeyedReference keyedReference) throws DeploymentException {
        List<KeyedReference> keyedReferences;
        CategoryBag categoryBag = techServ.getCategoryBag();
        if (categoryBag != null && (keyedReferences = categoryBag.getKeyedReferences()) != null && keyedReferences.contains(keyedReference)) {
            throw new DeploymentException("Category already added to this service.");
        }
    }

    @Override
    public void removeCategories(String techServiceId, List<String> categoryIds) {
        if (categoryIds != null) {
            TechnicalService service = this.technicalServiceUnifiedDAO.get(techServiceId);
            List keyRefs = this.universalUnifiedDAO.getAll(KeyedReference.class, categoryIds);
            service.getCategoryBag().getKeyedReferences().removeAll(keyRefs);
            this.universalUnifiedDAO.removeAll(keyRefs);
        }
    }

    @Override
    public float updateGlobalRating(String serviceId) {
        TechnicalService technicalService = this.technicalServiceUnifiedDAO.get(serviceId);
        float globalRating = 0.0f;
        if (!technicalService.getRatings().isEmpty()) {
            Iterator<Rating> iter = technicalService.getRatings().iterator();
            int size = technicalService.getRatings().size();
            while (iter.hasNext()) {
                globalRating += (float)iter.next().getMyRating();
            }
            globalRating /= (float)size;
        }
        return globalRating;
    }

    @Override
    public void updateComments(String serviceId, CommentTO comment) {
        TechnicalService technicalService = this.technicalServiceUnifiedDAO.get(serviceId);
        if (technicalService != null) {
            Comment commentTemp = new Comment();
            commentTemp.setContent(comment.getContent());
            commentTemp.setDate(comment.getDate());
            commentTemp.setUserName(comment.getUserName());
            technicalService.addComment(commentTemp);
        }
    }

    @Override
    public List<TechnicalServiceTO> getTechServicesByTag(String tag) {
        ArrayList<TechnicalServiceTO> result = new ArrayList<TechnicalServiceTO>();
        List<TechnicalService> allTechServices = this.technicalServiceUnifiedDAO.getAll();
        ArrayList<TechnicalService> techServices = new ArrayList<TechnicalService>();
        for (TechnicalService techServiceTemp : allTechServices) {
            if (!techServiceTemp.isTagged(tag)) continue;
            techServices.add(techServiceTemp);
        }
        this.toTechServicesTO(result, techServices);
        return result;
    }

    @Override
    public void removeTag(String tag, String serviceId) {
        TechnicalService techService = this.technicalServiceUnifiedDAO.get(serviceId);
        Set<String> tags = techService.getTags();
        tags.remove(tag);
        techService.setTags(tags);
    }

    @Override
    public void removeComment(String serviceId, String commentId) {
        TechnicalService techService = this.technicalServiceUnifiedDAO.get(serviceId);
        Comment comment = (Comment)this.commentDAO.get(commentId);
        List<Comment> comments = techService.getComments();
        comments.remove(comment);
        techService.setComments(comments);
    }

    public void setUniversalUnifiedDAO(UniversalUnifiedDAO universalUnifiedDAO) {
        this.universalUnifiedDAO = universalUnifiedDAO;
    }

    @Override
    public List<KeyedRefTO> getCategoriesForTechServ(String techServiceId) throws DeploymentException {
        TechnicalService service = this.technicalServiceUnifiedDAO.get(techServiceId);
        if (service == null) {
            throw new DeploymentException("No service found for the given id: " + techServiceId);
        }
        return this.transfertObjectAssembler.toCategoriesTO(service.getCategoryBag());
    }
}

