/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.util.ArrayList;
import java.util.List;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PartyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PartyTO;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.dao.organization.PartyDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartyManagerImpl
implements PartyManager {
    private TransfertObjectAssembler transfertObjectAssembler;
    private PartyDAO partyDAO;

    @Override
    public List<PartyTO> getAllParties(RequestOptionsTO requestOptionsTO) {
        ArrayList<PartyTO> result = new ArrayList<PartyTO>();
        List parties = this.partyDAO.getAll(this.transfertObjectAssembler.toPartyRequestOptions(requestOptionsTO));
        if (parties != null && !parties.isEmpty()) {
            for (Party party : parties) {
                if (party instanceof OrganizationUnit) {
                    result.add(this.transfertObjectAssembler.toOrganizationUnitTO((OrganizationUnit)party));
                    continue;
                }
                if (!(party instanceof Person)) continue;
                result.add(this.transfertObjectAssembler.toPersonTO((Person)party));
            }
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public PartyTO getParty(String partyId) throws OrganizationException {
        Party partyBO = (Party)this.partyDAO.get(partyId);
        if (partyBO == null) {
            throw new OrganizationException("No party found for the given id: " + partyId);
        }
        PartyTO partyTO = null;
        if (partyBO instanceof OrganizationUnit) {
            partyTO = this.transfertObjectAssembler.toOrganizationUnitTO((OrganizationUnit)partyBO);
        } else if (partyBO instanceof Person) {
            partyTO = this.transfertObjectAssembler.toPersonTO((Person)partyBO);
        }
        return partyTO;
    }

    public PartyDAO getPartyDAO() {
        return this.partyDAO;
    }

    public void setPartyDAO(PartyDAO partyDAO) {
        this.partyDAO = partyDAO;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }
}

