/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PostManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostManagerImpl
implements PostManager {
    private TransfertObjectAssembler transfertObjectAssembler;
    private PostDAO postDAO;
    private OrganizationUnitDAO organizationUnitDAO;

    @Override
    @CheckAllArgumentsNotNull
    public String createPost(PostTO postTO) throws OrganizationException {
        this.validatePostBeforeCreation(postTO);
        Post postBO = new Post();
        this.transfertObjectAssembler.toPostBO(postTO, postBO);
        return this.postDAO.save(postBO).getId();
    }

    private void validatePostBeforeCreation(PostTO postTO) throws OrganizationException {
        if (postTO.getName() == null) {
            throw new OrganizationException("Post name must be specified");
        }
        List posts = this.postDAO.searchEquals(new String[]{postTO.getName()}, new String[]{"name"}, null);
        if (posts != null && !posts.isEmpty()) {
            throw new OrganizationException("A post with the same name already exists");
        }
    }

    private void validatePostBeforeUpdate(PostTO postTO) throws OrganizationException {
        if (StringHelper.isNullOrEmpty((String)postTO.getName())) {
            throw new OrganizationException("You're trying to update a post with a null or empty name");
        }
        List posts = this.postDAO.searchEquals(new String[]{postTO.getName()}, new String[]{"name"}, null);
        if (posts != null && !posts.isEmpty() && !((Post)posts.get(0)).getId().equals(postTO.getId())) {
            throw new OrganizationException("A post with the same name already exists");
        }
    }

    @Override
    public List<PostTO> getAllPosts(RequestOptionsTO requestOptionsTO) {
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        List<Post> posts = this.postDAO.getAll(this.transfertObjectAssembler.toPostRequestOptions(requestOptionsTO));
        this.toPostsTO(result, posts);
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public PostTO getPost(String postId) throws OrganizationException {
        Post postBO = (Post)this.postDAO.get(postId);
        if (postBO == null) {
            throw new OrganizationException("No post found for the given id: " + postId);
        }
        PostTO postTO = this.toPostTO(postBO);
        return postTO;
    }

    @Override
    public List<PostTO> getPostsNotLinkedToOrganization(String orgId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        OrganizationUnit org = (OrganizationUnit)this.organizationUnitDAO.get(orgId);
        Set<Object> postsInOrg = new HashSet();
        if (org == null) {
            throw new OrganizationException("No organization with id: " + orgId);
        }
        postsInOrg = org.getPosts();
        List allPost = this.postDAO.getAll(this.transfertObjectAssembler.toPostRequestOptions(requestOptionsTO));
        if (allPost != null) {
            if (!postsInOrg.isEmpty()) {
                allPost.removeAll(postsInOrg);
            }
            for (Post post : allPost) {
                result.add(this.toPostTO(post));
            }
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removePost(String postId) {
        this.postDAO.remove(postId);
    }

    public void setOrganizationUnitDAO(OrganizationUnitDAO organizationUnitDAO) {
        this.organizationUnitDAO = organizationUnitDAO;
    }

    public void setPostDAO(PostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    private void toPostsTO(List<PostTO> result, Collection<Post> posts) {
        if (posts != null && !posts.isEmpty()) {
            for (Post post : posts) {
                result.add(this.toPostTO(post));
            }
        }
    }

    private PostTO toPostTO(Post post) {
        return this.transfertObjectAssembler.toPostTO(post);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updatePost(PostTO postTO) throws OrganizationException {
        if (postTO.getId() == null) {
            throw new NullPointerException("Post id must be specified");
        }
        Post post = (Post)this.postDAO.get(postTO.getId());
        if (post == null) {
            throw new OrganizationException("Your are trying to update a non existing Person with id: " + postTO.getId());
        }
        this.validatePostBeforeUpdate(postTO);
        this.transfertObjectAssembler.toPostBO(postTO, post);
        this.postDAO.save(post);
        return post.getId();
    }
}

