/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.ow2.dragon.api.service.common.CommonException;
import org.ow2.dragon.api.service.common.EntityLinkManager;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.OrgToEndpointTO;
import org.ow2.dragon.api.to.organization.OrgToTechServiceTO;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.api.to.organization.PersonToTechServiceTO;
import org.ow2.dragon.persistence.bo.common.Link;
import org.ow2.dragon.persistence.bo.common.LinkedEntity;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.dao.UniversalORMDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleOfPartyManagerImpl
implements RoleOfPartyManager {
    private EntityLinkManager entityLinkManager;
    private UniversalORMDAO universalORMDAO;
    private TransfertObjectAssembler transfertObjectAssembler;

    @Override
    public String createEndpointRole(String partyId, String endpointId, String type) throws OrganizationException {
        String roleId;
        try {
            roleId = this.entityLinkManager.createLink(partyId, endpointId, type);
            Endpoint endpoint = (Endpoint)this.universalORMDAO.get(Endpoint.class, (Serializable)((Object)endpointId));
            this.entityLinkManager.createLink(partyId, endpoint.getTechnicalService().getId(), type);
        }
        catch (CommonException e) {
            throw new OrganizationException(e);
        }
        return roleId;
    }

    @Override
    public String createTechServiceRole(String partyId, String technicalServiceId, String type) throws OrganizationException {
        String roleId;
        try {
            roleId = this.entityLinkManager.createLink(partyId, technicalServiceId, type);
        }
        catch (CommonException e) {
            throw new OrganizationException(e);
        }
        return roleId;
    }

    @Override
    public List<OrgToEndpointTO> getOrgRolesByEndpoint(String endpointId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<OrgToEndpointTO> result = new ArrayList<OrgToEndpointTO>();
        List<Link> allRoles = this.entityLinkManager.getAllLinksForTo(endpointId, requestOptionsTO);
        for (Link partyToEndpoint : allRoles) {
            LinkedEntity party = partyToEndpoint.getFrom();
            if (!(party instanceof OrganizationUnit)) continue;
            OrgToEndpointTO orgToEndpointTO = new OrgToEndpointTO();
            orgToEndpointTO.setId(partyToEndpoint.getId());
            orgToEndpointTO.setEndpointTO(this.transfertObjectAssembler.toEndpointTO((Endpoint)partyToEndpoint.getTo(), null));
            orgToEndpointTO.setPartyTO(this.transfertObjectAssembler.toOrganizationUnitTO((OrganizationUnit)party));
            orgToEndpointTO.setType(partyToEndpoint.getType());
            result.add(orgToEndpointTO);
        }
        return result;
    }

    @Override
    public List<OrgToTechServiceTO> getOrgRolesByTechService(String techServiceId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<OrgToTechServiceTO> result = new ArrayList<OrgToTechServiceTO>();
        List<Link> allRoles = this.entityLinkManager.getAllLinksForTo(techServiceId, requestOptionsTO);
        for (Link partyToTechService : allRoles) {
            LinkedEntity party = partyToTechService.getFrom();
            if (!(party instanceof OrganizationUnit)) continue;
            OrgToTechServiceTO orgToTechServiceTO = new OrgToTechServiceTO();
            orgToTechServiceTO.setId(partyToTechService.getId());
            orgToTechServiceTO.setTechnicalServiceTO(this.transfertObjectAssembler.toTechServiceTO((TechnicalService)partyToTechService.getTo(), null));
            orgToTechServiceTO.setPartyTO(this.transfertObjectAssembler.toOrganizationUnitTO((OrganizationUnit)party));
            orgToTechServiceTO.setType(partyToTechService.getType());
            result.add(orgToTechServiceTO);
        }
        return result;
    }

    @Override
    public List<PersonToEndpointTO> getPersonRolesByEndpoint(String endpointId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<PersonToEndpointTO> result = new ArrayList<PersonToEndpointTO>();
        List<Link> allRoles = this.entityLinkManager.getAllLinksForTo(endpointId, requestOptionsTO);
        for (Link partyToEndpoint : allRoles) {
            LinkedEntity party = partyToEndpoint.getFrom();
            if (!(party instanceof Person)) continue;
            PersonToEndpointTO personToEndpointTO = new PersonToEndpointTO();
            personToEndpointTO.setId(partyToEndpoint.getId());
            personToEndpointTO.setEndpointTO(this.transfertObjectAssembler.toEndpointTO((Endpoint)partyToEndpoint.getTo(), null));
            personToEndpointTO.setPartyTO(this.transfertObjectAssembler.toPersonTO((Person)party));
            personToEndpointTO.setType(partyToEndpoint.getType());
            result.add(personToEndpointTO);
        }
        return result;
    }

    @Override
    public List<PersonToTechServiceTO> getPersonRolesByTechService(String techServiceId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<PersonToTechServiceTO> result = new ArrayList<PersonToTechServiceTO>();
        List<Link> allRoles = this.entityLinkManager.getAllLinksForTo(techServiceId, requestOptionsTO);
        for (Link partyToTechService : allRoles) {
            LinkedEntity party = partyToTechService.getFrom();
            if (!(party instanceof Person)) continue;
            PersonToTechServiceTO personToTechServiceTO = new PersonToTechServiceTO();
            personToTechServiceTO.setId(partyToTechService.getId());
            personToTechServiceTO.setTechnicalServiceTO(this.transfertObjectAssembler.toTechServiceTO((TechnicalService)partyToTechService.getTo(), null));
            personToTechServiceTO.setPartyTO(this.transfertObjectAssembler.toPersonTO((Person)party));
            personToTechServiceTO.setType(partyToTechService.getType());
            result.add(personToTechServiceTO);
        }
        return result;
    }

    @Override
    public String[] getRolesTypes(RoleOfPartyManager.LINK_TYPE linkType, RequestOptionsTO options) throws OrganizationException {
        String[] result = null;
        String[] personToTechServRoles = new String[]{"Architect", "Certifier", "Designer", "Developer", "Manager", "User"};
        String[] orgToTechServRoles = new String[]{"Analyst", "Consumer", "Owner", "Provider"};
        String[] personToEndpointRoles = new String[]{"Architect", "Certifier", "Designer", "Developer", "Manager", "User"};
        String[] orgToEndpointRoles = new String[]{"Analyst", "Consumer", "Owner", "Provider"};
        if (linkType.equals((Object)RoleOfPartyManager.LINK_TYPE.PERSON_TO_TECHSERVICE)) {
            result = personToTechServRoles;
        } else if (linkType.equals((Object)RoleOfPartyManager.LINK_TYPE.ORG_TO_TECHSERVICE)) {
            result = orgToTechServRoles;
        } else if (linkType.equals((Object)RoleOfPartyManager.LINK_TYPE.PERSON_TO_ENDPOINT)) {
            result = personToEndpointRoles;
        } else if (linkType.equals((Object)RoleOfPartyManager.LINK_TYPE.ORG_TO_ENDPOINT)) {
            result = orgToEndpointRoles;
        }
        return result;
    }

    @Override
    public void removeRole(String roleId) throws OrganizationException {
        this.entityLinkManager.removeLink(roleId);
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    public void setUniversalORMDAO(UniversalORMDAO universalORMDAO) {
        this.universalORMDAO = universalORMDAO;
    }

    public void setEntityLinkManager(EntityLinkManager entityLinkManager) {
        this.entityLinkManager = entityLinkManager;
    }
}

