/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.sla;

import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.sla.ManagedAgreement;
import org.ow2.dragon.persistence.dao.organization.PartyDAO;
import org.ow2.dragon.service.sla.SLATransfertObjectAssembler;

public class SLATransfertObjectAssemblerImpl
implements SLATransfertObjectAssembler {
    private PartyDAO partyDAO;

    public Party getPartyBO(String id) {
        Party party = null;
        if (id != null) {
            party = (Party)this.partyDAO.get(id);
        }
        return party;
    }

    public PartyDAO getPartyDAO() {
        return this.partyDAO;
    }

    public void setPartyDAO(PartyDAO partyDAO) {
        this.partyDAO = partyDAO;
    }

    public ManagedAgreement toManagedAgreementBO(ManagedAgreementTO maTO) throws WSAgreementException {
        ManagedAgreement maBO = new ManagedAgreement();
        maBO.setClient(this.getPartyBO(maTO.getIdClient()));
        maBO.setProvider(this.getPartyBO(maTO.getIdProvider()));
        maBO.setName(maTO.getAgreement().getName());
        if (maTO.getAgreement() instanceof AgreementLifeCycle) {
            maBO.setState(((AgreementLifeCycle)maTO.getAgreement()).getState().value());
        } else {
            maBO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        }
        return maBO;
    }

    public void toManagedAgreementBO(ManagedAgreementTO maTO, ManagedAgreement maBO) throws WSAgreementException {
        maBO.setClient(this.getPartyBO(maTO.getIdClient()));
        maBO.setProvider(this.getPartyBO(maTO.getIdProvider()));
        maBO.setName(maTO.getAgreement().getName());
        if (maTO.getAgreement() instanceof AgreementLifeCycle) {
            maBO.setState(((AgreementLifeCycle)maTO.getAgreement()).getState().value());
        } else {
            maBO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        }
    }

    public ManagedAgreementTO toManagedAgreementTO(ManagedAgreement maBO) throws WSAgreementException {
        ManagedAgreementTO maTO = new ManagedAgreementTO();
        maTO.setId(maBO.getId());
        if (maBO.getClient() != null) {
            maTO.setIdClient(maBO.getClient().getId());
        }
        if (maBO.getProvider() != null) {
            maTO.setIdProvider(maBO.getProvider().getId());
        }
        if (maBO.getState() == null) {
            maTO.setState(AgreementLifeCycle.State.OFFER_RECEIVE.value());
        } else {
            maTO.setState(maBO.getState());
        }
        return maTO;
    }
}

