/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.technology;

import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.persistence.bo.technology.EnvironmentFederation;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager;
import org.ow2.dragon.persistence.bo.technology.Processor;
import org.ow2.dragon.service.technology.TechnologyTransferObjectAssembler;

public class TechnologyTransferObjectAssemblerImpl
implements TechnologyTransferObjectAssembler {
    public ExecutionEnvironmentTO toExecutionEnvironmentTO(ExecutionEnvironment executionEnvironmentBO) {
        ExecutionEnvironmentTO executionEnvironmentTO = null;
        if (executionEnvironmentBO != null) {
            executionEnvironmentTO = new ExecutionEnvironmentTO();
            ExecutionEnvironment.EEType type = executionEnvironmentBO.getEnvType();
            if (type != null) {
                executionEnvironmentTO.setEnvType(type.toString());
            }
            executionEnvironmentTO.setNodeId(executionEnvironmentBO.getId());
            executionEnvironmentTO.setHostProcessorId(this.retrieveHostProcessorId(executionEnvironmentBO));
            executionEnvironmentTO.setIpv4Address(executionEnvironmentBO.getIpv4Address());
            executionEnvironmentTO.setName(executionEnvironmentBO.getName());
            EnvironmentFederation federation = executionEnvironmentBO.getParentFederation();
            if (federation != null) {
                executionEnvironmentTO.setParentFederationId(federation.getId());
            }
            executionEnvironmentTO.setRoleInFederation(executionEnvironmentBO.getRoleInFederation());
            executionEnvironmentTO.setType(executionEnvironmentBO.getType());
        }
        return executionEnvironmentTO;
    }

    private String retrieveHostProcessorId(ExecutionEnvironment executionEnvironmentBO) {
        String result = null;
        Processor host = executionEnvironmentBO.getHostProcessor();
        if (host != null) {
            result = host.getId();
        }
        return result;
    }

    public ExecutionEnvironmentManagerTO toExecutionEnvironmentManagerTO(ExecutionEnvironmentManager executionEnvironmentManagerBO) {
        ExecutionEnvironmentManagerTO executionEnvironmentManagerTO = null;
        if (executionEnvironmentManagerBO != null) {
            executionEnvironmentManagerTO = new ExecutionEnvironmentManagerTO();
            executionEnvironmentManagerTO.setAddress(executionEnvironmentManagerBO.getAddress());
            executionEnvironmentManagerTO.setExecEnvManagerId(executionEnvironmentManagerBO.getId());
            executionEnvironmentManagerTO.setName(executionEnvironmentManagerBO.getName());
        }
        return executionEnvironmentManagerTO;
    }

    public ProcessorTO toProcessorTO(Processor processorBO) {
        ProcessorTO processorTO = null;
        if (processorBO != null) {
            processorTO = new ProcessorTO();
            processorTO.setIpv4Address(processorBO.getIpv4Address());
            processorTO.setName(processorBO.getName());
            processorTO.setNodeId(processorBO.getId());
            processorTO.setType(processorBO.getType());
        }
        return processorTO;
    }

    public EnvironmentFederationTO toEnvironmentFederationTO(EnvironmentFederation environmentFederationBO) {
        EnvironmentFederationTO environmentFederationTO = null;
        if (environmentFederationBO != null) {
            environmentFederationTO = new EnvironmentFederationTO();
            environmentFederationTO.setPattern(environmentFederationBO.getPattern().toString());
            environmentFederationTO.setEnvFedId(environmentFederationBO.getId());
            environmentFederationTO.setName(environmentFederationBO.getName());
        }
        return environmentFederationTO;
    }
}

