/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.wsdl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.dao.UniversalUnifiedDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingDAO;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.deployment.ProtocolDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceInterfaceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceSpecificationDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.service.wsdl.EasyWSDLTimeout;
import org.ow2.dragon.service.wsdl.WSDLImportReport;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.StringHelper;
import org.ow2.dragon.util.XMLUtil;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Documentation;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.BindingOperation;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.easywsdl.wsdl.util.InputStreamForker;
import org.springframework.util.ResourceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLManagerImpl
implements WSDLManager {
    private MetadataService metadataService;
    private ServiceSpecificationDAO serviceSpecificationDAO;
    private GenericUnifiedDAO<ServiceSpecification, String> serviceSpecificationUnifiedDAO;
    private ServiceInterfaceDAO serviceInterfaceDAO;
    private BindingDAO bindingDAO;
    private TechnicalServiceDAO technicalServiceDAO;
    private EndpointDAO endpointDAO;
    private ProtocolDAO protocolDAO;
    private TransfertObjectAssembler transfertObjectAssembler;
    private WSDLReader wsdlReader;
    private SchemaReader schemaReader;
    private UniversalUnifiedDAO universalUnifiedDAO;
    private Logger logger = Logger.getLogger(this.getClass());

    public WSDLManagerImpl() throws WSDLServiceException {
        WSDLFactory wsdlFactory = null;
        try {
            wsdlFactory = WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            // empty catch block
        }
        try {
            this.wsdlReader = wsdlFactory.newWSDLReader();
        }
        catch (WSDLException e1) {
            throw new WSDLServiceException("Can't create wsdl reader", e1);
        }
        SchemaFactory schemaFactory = null;
        try {
            schemaFactory = SchemaFactory.newInstance();
            this.schemaReader = schemaFactory.newSchemaReader();
        }
        catch (SchemaException e) {
            throw new WSDLServiceException("Can't create schema reader factory", e);
        }
    }

    private void createBindingOps(Map<Operation, SpecifiedOperation> createdIntOps, Binding binding, org.ow2.dragon.persistence.bo.deployment.Binding dragonBinding) {
        List operations = binding.getBindingOperations();
        if (operations != null) {
            for (BindingOperation operation : operations) {
                String signature = ((Operation)operation.getOperation()).getQName().toString();
                org.ow2.dragon.persistence.bo.deployment.BindingOperation dragonBindingOp = new org.ow2.dragon.persistence.bo.deployment.BindingOperation();
                dragonBindingOp.setSignature(signature);
                dragonBindingOp.setStyle(this.getBindingOpStyle(operation));
                createdIntOps.get(operation.getOperation()).addBindingOp(dragonBindingOp);
                dragonBinding.addBindingOp(dragonBindingOp);
            }
        }
    }

    private void createBindings(Description description, ServiceSpecification serviceSpecification, Map<String, ServiceInterface> createdInterfaces, Map<Operation, SpecifiedOperation> createdIntOps, Map<String, org.ow2.dragon.persistence.bo.deployment.Binding> createdBindings) throws WSDLServiceException {
        List bindings = description.getBindings();
        if (bindings != null) {
            for (Binding binding : bindings) {
                QName bindingName = binding.getQName();
                org.ow2.dragon.persistence.bo.deployment.Binding dragonBinding = null;
                String interfaceName = ((InterfaceType)binding.getInterface()).getQName().toString();
                ServiceInterface linkedInterface = createdInterfaces.get(interfaceName);
                RequestOptions requestOptions = new RequestOptions();
                requestOptions.setCaseSensitive(true);
                List bindingsBO = this.bindingDAO.searchEquals(new String[]{bindingName.toString()}, new String[]{"fullName"}, requestOptions);
                if (bindingsBO != null && !bindingsBO.isEmpty()) {
                    dragonBinding = (org.ow2.dragon.persistence.bo.deployment.Binding)bindingsBO.get(0);
                } else {
                    dragonBinding = new org.ow2.dragon.persistence.bo.deployment.Binding();
                    dragonBinding.setFullName(bindingName.toString());
                    Name nameObject = new Name();
                    nameObject.setLangCode("en");
                    nameObject.setName(bindingName.getLocalPart());
                    dragonBinding.setName(nameObject);
                    Documentation bindingDoc = binding.getDocumentation();
                    String bindingDocContent = null;
                    if (bindingDoc != null) {
                        bindingDocContent = bindingDoc.getContent();
                    }
                    if (!StringHelper.isNullOrEmpty(bindingDocContent)) {
                        org.ow2.dragon.persistence.bo.common.Description description1 = new org.ow2.dragon.persistence.bo.common.Description();
                        description1.setLangCode("en");
                        description1.setDescription(bindingDocContent);
                        dragonBinding.addDescription(description1);
                    }
                    org.ow2.dragon.persistence.bo.common.Description description2 = new org.ow2.dragon.persistence.bo.common.Description();
                    description2.setLangCode("en");
                    description2.setDescription("This is a wsdl binding specification.");
                    dragonBinding.addDescription(description2);
                    this.setTModelCategory(dragonBinding, "uddi:uddi.org:xml:namespace", "binding namespace", bindingName.getNamespaceURI());
                    this.setTModelCategory(dragonBinding, "uddi:uddi.org:wsdl:types", "WSDL type", "binding");
                    this.setTModelCategory(dragonBinding, "uddi:uddi.org:wsdl:porttypereference", "portType reference", linkedInterface.getId());
                    this.setTModelCategory(dragonBinding, "uddi:uddi.org:categorization:types", "uddi-org:types", "wsdlSpec");
                    this.linkProtocolAndTransport(binding, dragonBinding);
                    this.createBindingOps(createdIntOps, binding, dragonBinding);
                }
                linkedInterface.addBinding(dragonBinding);
                serviceSpecification.addBinding(dragonBinding);
                createdBindings.put(bindingName.toString(), dragonBinding);
                this.bindingDAO.save(dragonBinding);
            }
        }
    }

    private String[] createDragonObjectModel(Description description, SimpleFile storedWSDL, String wsdlSha1) throws WSDLServiceException {
        this.validateDescription(description);
        ServiceSpecification serviceSpecification = this.createServiceSpecification(description, storedWSDL, wsdlSha1);
        HashMap<String, ServiceInterface> createdInterfaces = new HashMap<String, ServiceInterface>();
        HashMap<Operation, SpecifiedOperation> createdIntOps = new HashMap<Operation, SpecifiedOperation>();
        this.createInterfacesAndIntOps(description, serviceSpecification, createdInterfaces, createdIntOps);
        HashMap<String, org.ow2.dragon.persistence.bo.deployment.Binding> createdBindings = new HashMap<String, org.ow2.dragon.persistence.bo.deployment.Binding>();
        this.createBindings(description, serviceSpecification, createdInterfaces, createdIntOps, createdBindings);
        ArrayList<String> result = new ArrayList<String>();
        this.createServices(serviceSpecification, createdInterfaces, createdBindings, description, result);
        return result.toArray(new String[0]);
    }

    private void validateDescription(Description description) throws WSDLServiceException {
        List services = description.getServices();
        List bindings = description.getBindings();
        List interfaceTypes = description.getInterfaces();
        if (services == null || services.isEmpty() || bindings == null || bindings.isEmpty() || interfaceTypes == null || interfaceTypes.isEmpty()) {
            throw new WSDLServiceException("Abstract wsdl aren't supported for the moment. Supported wsdl must contains PortTypes (Interfaces), Bindings, Services.");
        }
    }

    private void createEndpoints(Map<String, org.ow2.dragon.persistence.bo.deployment.Binding> createdBindings, Service service, TechnicalService dragonTechnicalService, ServiceSpecification serviceSpecification) {
        List endpoints = service.getEndpoints();
        if (endpoints != null) {
            for (org.ow2.easywsdl.wsdl.api.Endpoint endpoint : endpoints) {
                Endpoint dragonEndpoint;
                String dragonEndpointName = endpoint.getName();
                RequestOptions requestOptions = new RequestOptions();
                requestOptions.setCaseSensitive(true);
                List endpointsBO = this.endpointDAO.searchEquals(new String[]{dragonEndpointName}, new String[]{"name"}, requestOptions);
                if (endpointsBO != null && !endpointsBO.isEmpty()) {
                    dragonEndpoint = (Endpoint)endpointsBO.get(0);
                } else {
                    dragonEndpoint = new Endpoint();
                    dragonEndpoint.setName(dragonEndpointName);
                    URI endpointAddress = URI.create(endpoint.getAddress());
                    if (endpointAddress != null) {
                        dragonEndpoint.setNetworkAddress(endpointAddress.toString());
                    } else {
                        dragonEndpoint.setNetworkAddress("Unknown");
                    }
                }
                dragonTechnicalService.addEndpoint(dragonEndpoint);
                dragonEndpoint.addServiceSpec(serviceSpecification);
                String bindingName = ((Binding)endpoint.getBinding()).getQName().toString();
                createdBindings.get(bindingName).addEndpoint(dragonEndpoint);
            }
        }
    }

    private void createInterfacesAndIntOps(Description description, ServiceSpecification serviceSpecification, Map<String, ServiceInterface> createdInterfaces, Map<Operation, SpecifiedOperation> createdIntOps) throws WSDLServiceException {
        List interfaces = description.getInterfaces();
        if (interfaces != null) {
            for (InterfaceType wsdlInterface : interfaces) {
                ServiceInterface serviceInterface;
                QName interfaceName = wsdlInterface.getQName();
                RequestOptions requestOptions = new RequestOptions();
                requestOptions.setCaseSensitive(true);
                List serviceInterfacesBO = this.serviceInterfaceDAO.searchEquals(new String[]{interfaceName.toString()}, new String[]{"fullName"}, requestOptions);
                if (serviceInterfacesBO != null && !serviceInterfacesBO.isEmpty()) {
                    serviceInterface = (ServiceInterface)serviceInterfacesBO.get(0);
                    this.mapIntOps(createdIntOps, wsdlInterface, serviceInterface);
                } else {
                    serviceInterface = new ServiceInterface();
                    serviceInterface.setFullName(interfaceName.toString());
                    Name nameObject = new Name();
                    nameObject.setLangCode("en");
                    nameObject.setName(interfaceName.getLocalPart());
                    serviceInterface.setName(nameObject);
                    Documentation interfaceDoc = wsdlInterface.getDocumentation();
                    String interfaceDocContent = null;
                    if (interfaceDoc != null) {
                        interfaceDocContent = interfaceDoc.getContent();
                    }
                    if (!StringHelper.isNullOrEmpty(interfaceDocContent)) {
                        org.ow2.dragon.persistence.bo.common.Description description1 = new org.ow2.dragon.persistence.bo.common.Description();
                        description1.setLangCode("en");
                        description1.setDescription(interfaceDocContent);
                        serviceInterface.addDescription(description1);
                    }
                    org.ow2.dragon.persistence.bo.common.Description description2 = new org.ow2.dragon.persistence.bo.common.Description();
                    description2.setLangCode("en");
                    description2.setDescription("This is a wsdl interface specification.");
                    serviceInterface.addDescription(description2);
                    this.setTModelCategory(serviceInterface, "uddi:uddi.org:xml:namespace", "portType namespace", interfaceName.getNamespaceURI());
                    this.setTModelCategory(serviceInterface, "uddi:uddi.org:wsdl:types", "WSDL type", "portType");
                    this.createIntOps(createdIntOps, wsdlInterface, serviceInterface);
                }
                serviceSpecification.addServiceInterface(serviceInterface);
                createdInterfaces.put(interfaceName.toString(), serviceInterface);
                this.serviceInterfaceDAO.save(serviceInterface);
            }
        }
    }

    private void mapIntOps(Map<Operation, SpecifiedOperation> createdIntOps, InterfaceType wsdlInterface, ServiceInterface serviceInterface) throws WSDLServiceException {
        List wsdlOps = wsdlInterface.getOperations();
        Set<SpecifiedOperation> specOps = serviceInterface.getSpecifiedOps();
        if (wsdlOps.size() == specOps.size()) {
            block0: for (Operation operation : wsdlOps) {
                for (SpecifiedOperation specifiedOperation : specOps) {
                    if (!specifiedOperation.getName().equals(operation.getQName().toString())) continue;
                    createdIntOps.put(operation, specifiedOperation);
                    continue block0;
                }
            }
            if (createdIntOps.keySet() != null && createdIntOps.keySet().size() < Math.max(wsdlOps.size(), specOps.size())) {
                throw new WSDLServiceException("You're trying to register an interface that already exist in registry but contains different operations: " + serviceInterface.getFullName());
            }
        } else {
            throw new WSDLServiceException("You're trying to register an interface that already exist in registry but contains different operations: " + serviceInterface.getFullName());
        }
    }

    private void createIntOps(Map<Operation, SpecifiedOperation> createdIntOps, InterfaceType wsdlInterface, ServiceInterface serviceInterface) {
        List intOps = wsdlInterface.getOperations();
        if (intOps != null) {
            for (Operation interfaceOperation : intOps) {
                String signature = interfaceOperation.getSignature();
                String name = interfaceOperation.getQName().toString();
                Documentation documentation = interfaceOperation.getDocumentation();
                String docContent = null;
                if (documentation != null) {
                    docContent = documentation.getContent();
                }
                SpecifiedOperation specOp = new SpecifiedOperation();
                specOp.setName(name);
                specOp.setSignature(signature);
                specOp.setPurpose(docContent);
                specOp.setTransmission(this.getInterfaceOpTransmission(interfaceOperation));
                serviceInterface.addSpecifiedOp(specOp);
                createdIntOps.put(interfaceOperation, specOp);
            }
        }
    }

    private void linkProtocolAndTransport(Binding binding, org.ow2.dragon.persistence.bo.deployment.Binding dragonBinding) {
        AbsItfBinding.BindingConstants protocol = binding.getTypeOfBinding();
        if (protocol != null) {
            if (protocol.equals((Object)AbsItfBinding.BindingConstants.SOAP11_BINDING4WSDL11)) {
                Protocol soap11Protocol = (Protocol)this.protocolDAO.get("uddi:uddi.org:protocol:soap");
                dragonBinding.addProtocol(soap11Protocol);
                URI transportURI = URI.create(binding.getTransportProtocol());
                Transport transport = this.detectTransport(transportURI);
                if (transport != null) {
                    dragonBinding.addTransport(transport);
                }
            } else if (protocol.equals((Object)AbsItfBinding.BindingConstants.SOAP12_BINDING4WSDL11) || protocol.equals((Object)AbsItfBinding.BindingConstants.SOAP_BINDING4WSDL20)) {
                Protocol soap12Protocol = (Protocol)this.protocolDAO.get("uddi:dragon.org:protocol:soap12");
                dragonBinding.addProtocol(soap12Protocol);
                URI transportURI = URI.create(binding.getTransportProtocol());
                Transport transport = this.detectTransport(transportURI);
                if (transport != null) {
                    dragonBinding.addTransport(transport);
                }
            } else if (protocol.equals((Object)AbsItfBinding.BindingConstants.HTTP11_BINDING4WSDL11) || protocol.equals((Object)AbsItfBinding.BindingConstants.HTTP_BINDING4WSDL20)) {
                Protocol httpProtocol = (Protocol)this.protocolDAO.get("uddi:uddi.org:protocol:http");
                Transport httpTransport = (Transport)this.universalUnifiedDAO.get(Transport.class, (Serializable)((Object)"uddi:uddi.org:transport:http"));
                dragonBinding.addProtocol(httpProtocol);
                dragonBinding.addTransport(httpTransport);
            }
        }
    }

    private Transport detectTransport(URI transportURI) {
        Transport transport = null;
        if (transportURI != null) {
            if (transportURI.toString().toLowerCase().contains("http")) {
                transport = (Transport)this.universalUnifiedDAO.get(Transport.class, (Serializable)((Object)"uddi:uddi.org:transport:http"));
            } else if (transportURI.toString().toLowerCase().contains("ftp")) {
                transport = (Transport)this.universalUnifiedDAO.get(Transport.class, (Serializable)((Object)"uddi:uddi.org:transport:ftp"));
            } else if (transportURI.toString().toLowerCase().contains("smtp")) {
                transport = (Transport)this.universalUnifiedDAO.get(Transport.class, (Serializable)((Object)"uddi:uddi.org:transport:smtp"));
            }
        }
        return transport;
    }

    private void createServices(ServiceSpecification serviceSpecification, Map<String, ServiceInterface> createdInterfaces, Map<String, org.ow2.dragon.persistence.bo.deployment.Binding> createdBindings, Description description, List<String> result) {
        List services = description.getServices();
        if (services != null) {
            for (Service service : services) {
                TechnicalService dragonTechnicalService;
                QName serviceName = service.getQName();
                Documentation serviceDoc = service.getDocumentation();
                String serviceDocContent = null;
                if (serviceDoc != null) {
                    serviceDocContent = serviceDoc.getContent();
                }
                RequestOptions requestOptions = new RequestOptions();
                requestOptions.setCaseSensitive(true);
                List servicesBO = this.technicalServiceDAO.searchEquals(new String[]{serviceName.toString()}, new String[]{"fullName"}, requestOptions);
                if (servicesBO != null && !servicesBO.isEmpty()) {
                    dragonTechnicalService = (TechnicalService)servicesBO.get(0);
                    this.createEndpoints(createdBindings, service, dragonTechnicalService, serviceSpecification);
                } else {
                    dragonTechnicalService = new TechnicalService();
                    dragonTechnicalService.setFullName(serviceName.toString());
                    Name nameObject = new Name();
                    nameObject.setLangCode("en");
                    nameObject.setName(serviceName.getLocalPart());
                    dragonTechnicalService.addName(nameObject);
                    this.setServiceCategory(dragonTechnicalService, "uddi:uddi.org:xml:localname", "service local name", serviceName.getLocalPart());
                    this.setServiceCategory(dragonTechnicalService, "uddi:uddi.org:xml:namespace", "service namespace", serviceName.getNamespaceURI());
                    this.setServiceCategory(dragonTechnicalService, "uddi:uddi.org:wsdl:types", "WSDL type", "service");
                    if (!StringHelper.isNullOrEmpty((String)serviceDocContent)) {
                        org.ow2.dragon.persistence.bo.common.Description descriptionObject = new org.ow2.dragon.persistence.bo.common.Description();
                        descriptionObject.setLangCode("en");
                        descriptionObject.setDescription(serviceDocContent);
                        dragonTechnicalService.addDescription(descriptionObject);
                    }
                    this.technicalServiceDAO.save(dragonTechnicalService);
                    this.createEndpoints(createdBindings, service, dragonTechnicalService, serviceSpecification);
                    result.add(dragonTechnicalService.getId());
                }
                serviceSpecification.addTechnicalService(dragonTechnicalService);
                this.technicalServiceDAO.save(dragonTechnicalService);
            }
        }
    }

    private void setTModelCategory(TModel tmodel, String tModelKey, String categoryName, String categoryValue) throws WSDLServiceException {
        CategoryBag bag = tmodel.getCategoryBag();
        if (bag == null) {
            bag = new CategoryBag();
            tmodel.setCategoryBag(bag);
        }
        List<KeyedReference> keyedReferences = bag.getKeyedReferences();
        boolean serviceCategoryExist = false;
        if (keyedReferences != null) {
            for (KeyedReference keyedReference : keyedReferences) {
                if (!tModelKey.equals(keyedReference.getTmodel().getId())) continue;
                keyedReference.setKeyValue(categoryValue);
                serviceCategoryExist = true;
                break;
            }
        }
        if (!serviceCategoryExist) {
            TModel tModelToLink = (TModel)this.universalUnifiedDAO.get(TModel.class, (Serializable)((Object)tModelKey));
            if (tModelToLink == null) {
                throw new WSDLServiceException("Can't find tmodel for key: " + tModelKey);
            }
            this.addKeyedReference(bag, categoryName, categoryValue, tModelToLink);
        }
    }

    private void setServiceCategory(TechnicalService service, String tModelKey, String categoryName, String categoryValue) {
        CategoryBag bag = service.getCategoryBag();
        if (bag == null) {
            bag = new CategoryBag();
            service.setCategoryBag(bag);
        }
        List<KeyedReference> keyedReferences = bag.getKeyedReferences();
        boolean serviceCategoryExist = false;
        if (keyedReferences != null) {
            for (KeyedReference keyedReference : keyedReferences) {
                if (!tModelKey.equals(keyedReference.getTmodel().getId())) continue;
                keyedReference.setKeyValue(categoryValue);
                serviceCategoryExist = true;
                break;
            }
        }
        if (!serviceCategoryExist) {
            TModel tModelToLink = (TModel)this.universalUnifiedDAO.get(TModel.class, (Serializable)((Object)tModelKey));
            this.addKeyedReference(bag, categoryName, categoryValue, tModelToLink);
        }
    }

    private void addKeyedReference(CategoryBag bag, String name, String value, TModel tModel) {
        KeyedReference keyedReference = new KeyedReference();
        keyedReference.setKeyName(name);
        keyedReference.setKeyValue(value);
        keyedReference.setTmodel(tModel);
        bag.addKeyedReference(keyedReference);
    }

    private ServiceSpecification createServiceSpecification(Description description, SimpleFile storedWSDL, String wsdlSha1) throws WSDLServiceException {
        ServiceSpecification serviceSpecification = new ServiceSpecification();
        Name nameObject = new Name();
        nameObject.setLangCode("en");
        nameObject.setName(this.retrieveServSpecName(description));
        serviceSpecification.setName(nameObject);
        Documentation descriptionDoc = description.getDocumentation();
        String descriptionDocContent = null;
        if (descriptionDoc != null) {
            descriptionDocContent = descriptionDoc.getContent();
        }
        if (!StringHelper.isNullOrEmpty(descriptionDocContent)) {
            org.ow2.dragon.persistence.bo.common.Description description1 = new org.ow2.dragon.persistence.bo.common.Description();
            description1.setLangCode("en");
            description1.setDescription(descriptionDocContent);
            serviceSpecification.addDescription(description1);
        }
        org.ow2.dragon.persistence.bo.common.Description description2 = new org.ow2.dragon.persistence.bo.common.Description();
        description2.setLangCode("en");
        description2.setDescription("This is a wsdl specification.");
        serviceSpecification.addDescription(description2);
        serviceSpecification.setWsdlSha1(wsdlSha1);
        serviceSpecification.addOverviewDoc(storedWSDL);
        this.serviceSpecificationDAO.save(serviceSpecification);
        return serviceSpecification;
    }

    private String retrieveServSpecName(Description description) throws WSDLServiceException {
        String name = null;
        try {
            QName qname = description.getQName();
            name = qname != null ? qname.toString() : "{" + description.getTargetNamespace() + "}Undefined";
        }
        catch (WSDLException e) {
            throw new WSDLServiceException("Can't retrieve service spec name", e);
        }
        return name;
    }

    public BindingDAO getBindingDAO() {
        return this.bindingDAO;
    }

    private SpecifiedOperation.OpStyleType getBindingOpStyle(BindingOperation bindingOperation) {
        SpecifiedOperation.OpStyleType opStyle = SpecifiedOperation.OpStyleType.UNKNOWN;
        AbsItfBinding.StyleConstant style = bindingOperation.getStyle();
        if (style != null) {
            if (AbsItfBinding.StyleConstant.RPC.equals((Object)style)) {
                opStyle = SpecifiedOperation.OpStyleType.PARAMETERS;
            } else if (AbsItfBinding.StyleConstant.DOCUMENT.equals((Object)style)) {
                opStyle = SpecifiedOperation.OpStyleType.DOCUMENT;
            }
        }
        return opStyle;
    }

    private SpecifiedOperation.OpTmType getInterfaceOpTransmission(Operation interfaceOperation) {
        SpecifiedOperation.OpTmType opTransmission = SpecifiedOperation.OpTmType.UNKNOWN;
        if (AbsItfOperation.MEPPatternConstants.IN_ONLY.equals((Object)interfaceOperation.getPattern()) || AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.equals((Object)interfaceOperation.getPattern()) || AbsItfOperation.MEPPatternConstants.OUT_ONLY.equals((Object)interfaceOperation.getPattern()) || AbsItfOperation.MEPPatternConstants.ROBUST_OUT_ONLY.equals((Object)interfaceOperation.getPattern())) {
            opTransmission = SpecifiedOperation.OpTmType.ONEWAY;
        } else if (AbsItfOperation.MEPPatternConstants.IN_OUT.equals((Object)interfaceOperation.getPattern()) || AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.equals((Object)interfaceOperation.getPattern()) || AbsItfOperation.MEPPatternConstants.OUT_IN.equals((Object)interfaceOperation.getPattern()) || AbsItfOperation.MEPPatternConstants.OUT_OPTIONAL_IN.equals((Object)interfaceOperation.getPattern())) {
            opTransmission = SpecifiedOperation.OpTmType.REQUEST_RESPONSE;
        }
        return opTransmission;
    }

    private String getLanguageFileName(String wsdlURI) throws WSDLServiceException {
        URI uri = URI.create(wsdlURI);
        String path = uri.getPath();
        String[] pathElements = path.split("/");
        String languageFileName = pathElements[pathElements.length - 1];
        return languageFileName;
    }

    public MetadataService getMetadataManager() {
        return this.metadataService;
    }

    public ServiceInterfaceDAO getServiceInterfaceDAO() {
        return this.serviceInterfaceDAO;
    }

    public ServiceSpecificationDAO getServiceSpecificationDAO() {
        return this.serviceSpecificationDAO;
    }

    public TechnicalServiceDAO getTechnicalServiceDAO() {
        return this.technicalServiceDAO;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<ServiceSpecificationTO> getServSpecsForEndpoint(String epId) throws WSDLServiceException {
        ArrayList<ServiceSpecificationTO> result = new ArrayList<ServiceSpecificationTO>();
        Endpoint endpoint = (Endpoint)this.endpointDAO.get(epId);
        if (endpoint == null) {
            throw new WSDLServiceException("Can't find endpoint for the given id: " + epId);
        }
        Set<ServiceSpecification> specs = endpoint.getServiceSpecifications();
        for (ServiceSpecification serviceSpecification : specs) {
            result.add(this.transfertObjectAssembler.toServiceSpecTO(serviceSpecification));
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public List<ServiceSpecificationTO> getServSpecsForTechServ(String techServiceId) throws WSDLServiceException {
        ArrayList<ServiceSpecificationTO> result = new ArrayList<ServiceSpecificationTO>();
        TechnicalService technicalService = (TechnicalService)this.technicalServiceDAO.get(techServiceId);
        if (technicalService == null) {
            throw new WSDLServiceException("Can't find technical service for the given id: " + techServiceId);
        }
        Set<ServiceSpecification> specs = technicalService.getServiceSpecifications();
        for (ServiceSpecification serviceSpecification : specs) {
            result.add(this.transfertObjectAssembler.toServiceSpecTO(serviceSpecification));
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String[] importServiceDefFile(Document domDocument) throws WSDLServiceException, TimeoutException {
        return this.importServiceDefFile(domDocument, null);
    }

    @Override
    public String[] importServiceDefFile(Element domElement) throws WSDLServiceException {
        throw new RuntimeException("not implemented method");
    }

    @Override
    @CheckArgumentsNotNull
    public String[] importServiceDefFile(InputSource inputSource, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        return this.importServiceDefFile(inputSource, null, wsdlFileName);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String[] importServiceDefFile(InputSource inputSource) throws WSDLServiceException, TimeoutException {
        return this.importServiceDefFile(inputSource, null, null);
    }

    @Override
    @CheckArgumentsNotNull
    public String[] importServiceDefFile(String wsdlContent, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        return this.importServiceDefFile(wsdlContent, null, wsdlFileName);
    }

    @Override
    @CheckArgumentsNotNull
    public String[] importServiceDefFile(String wsdlContent, Map<String, String> imports, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        InputSource wsdlSource = new InputSource(new ByteArrayInputStream(wsdlContent.getBytes()));
        HashMap<String, InputSource> importSources = new HashMap<String, InputSource>();
        if (imports != null && imports.size() > 0) {
            Set<String> keys = imports.keySet();
            for (String key : keys) {
                InputSource importSource = new InputSource(new ByteArrayInputStream(imports.get(key).getBytes()));
                importSources.put(key, importSource);
            }
        }
        return this.importServiceDefFile(wsdlSource, importSources, wsdlFileName);
    }

    private boolean isSchema(Document importDoc) {
        boolean result = false;
        String ns = importDoc.getDocumentElement().getNamespaceURI();
        if ("http://www.w3.org/2001/XMLSchema".equals(ns)) {
            result = true;
        }
        return result;
    }

    private boolean isWSDL(Document importDoc) {
        boolean result = false;
        String ns = importDoc.getDocumentElement().getNamespaceURI();
        if ("http://www.w3.org/ns/wsdl".equals(ns) || "http://schemas.xmlsoap.org/wsdl/".equals(ns)) {
            result = true;
        }
        return result;
    }

    @Override
    @CheckArgumentsNotNull
    public String[] importServiceDefFile(URI wsdlURI, Map<String, URI> imports, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        InputSource inputSource;
        try {
            InputStream inputStream = ResourceUtils.getURL((String)wsdlURI.toString()).openStream();
            inputSource = new InputSource(inputStream);
        }
        catch (Exception e) {
            throw new WSDLServiceException("Can't read WSDL file at URL: " + wsdlURI.toString());
        }
        HashMap<String, InputSource> importSources = null;
        if (imports != null && imports.size() > 0) {
            importSources = new HashMap<String, InputSource>();
            Set<String> keys = imports.keySet();
            for (String key : keys) {
                InputSource importSource = null;
                try {
                    importSource = new InputSource(ResourceUtils.getURL((String)wsdlURI.toString()).openStream());
                }
                catch (Exception e) {
                    throw new WSDLServiceException("Can't create input source from the given import Document.", e);
                }
                importSources.put(key, importSource);
            }
        }
        return this.importServiceDefFile(inputSource);
    }

    @Override
    @CheckArgumentsNotNull
    public String[] importServiceDefFile(URI wsdlURI, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        return this.importServiceDefFile(wsdlURI, null, wsdlFileName);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String[] importServiceDefFile(URI wsdlURI) throws WSDLServiceException, TimeoutException {
        return this.importServiceDefFile(wsdlURI, null, null);
    }

    private boolean alreadyRegisteredDesc(String originalXmlSHA1) {
        boolean result = false;
        this.logger.debug((Object)("Provided wsdl hash : " + originalXmlSHA1));
        String[] criteria = new String[]{originalXmlSHA1};
        String[] searchedProperties = new String[]{"wsdlSha1"};
        List<ServiceSpecification> specs = this.serviceSpecificationUnifiedDAO.searchEquals(criteria, searchedProperties, null);
        if (specs != null && !specs.isEmpty()) {
            result = true;
            this.logger.info((Object)"You try to register an already registered WSDL");
        }
        return result;
    }

    public void setBindingDAO(BindingDAO bindingDAO) {
        this.bindingDAO = bindingDAO;
    }

    public void setEndpointDAO(EndpointDAO endpointDAO) {
        this.endpointDAO = endpointDAO;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setServiceInterfaceDAO(ServiceInterfaceDAO serviceInterfaceDAO) {
        this.serviceInterfaceDAO = serviceInterfaceDAO;
    }

    public void setServiceSpecificationDAO(ServiceSpecificationDAO serviceSpecificationDAO) {
        this.serviceSpecificationDAO = serviceSpecificationDAO;
    }

    public void setTechnicalServiceDAO(TechnicalServiceDAO technicalServiceDAO) {
        this.technicalServiceDAO = technicalServiceDAO;
    }

    public ProtocolDAO getProtocolDAO() {
        return this.protocolDAO;
    }

    public void setProtocolDAO(ProtocolDAO protocolDAO) {
        this.protocolDAO = protocolDAO;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String getWsdlDescAsString(String servSpecId) throws WSDLServiceException {
        String result = null;
        try {
            InputStream inputStream = this.getWsdlDesc(servSpecId);
            result = StringHelper.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new WSDLServiceException("Can't convert WSDL file content to String", e);
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public InputStream getWsdlDesc(String servSpecId) throws WSDLServiceException {
        InputStream result = null;
        ServiceSpecification serviceSpecification = (ServiceSpecification)this.serviceSpecificationDAO.get(servSpecId);
        if (serviceSpecification != null) {
            SimpleFile descFile = serviceSpecification.getOverviewDocs().get(0);
            try {
                result = this.metadataService.loadMetadataContentAsInputStream(descFile.getId());
            }
            catch (MetadataServiceException e) {
                throw new WSDLServiceException("Can't load WSDL file content", e);
            }
        } else {
            throw new WSDLServiceException("Can't find a service specification for id: " + servSpecId);
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public String[] importServiceDefFile(String wsdlContent) throws WSDLServiceException, TimeoutException {
        return this.importServiceDefFile(wsdlContent, null);
    }

    private void addRelatedDocs(String serviceId, Set<SimpleFile> relatedDocs) {
        if (!relatedDocs.isEmpty()) {
            TechnicalService service = (TechnicalService)this.technicalServiceDAO.get(serviceId);
            for (SimpleFile relatedDoc : relatedDocs) {
                service.addRelatedDoc(relatedDoc);
            }
            this.technicalServiceDAO.save(service);
        }
    }

    public String registerRelatedDoc(String serviceId, String mimetype, byte[] docContent) throws WSDLServiceException {
        SimpleFile doc = null;
        try {
            doc = this.metadataService.storeMetadataAndIndexContent(mimetype, docContent);
        }
        catch (MetadataServiceException e) {
            throw new WSDLServiceException("Can't store document in registry", e);
        }
        HashSet<SimpleFile> docs = new HashSet<SimpleFile>();
        docs.add(doc);
        this.addRelatedDocs(serviceId, docs);
        return doc.getId();
    }

    @Override
    @CheckArgumentsNotNull
    public String[] importServiceDefFile(Document domDocument, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        return this.importServiceDefFile(domDocument, null, wsdlFileName);
    }

    @Override
    @CheckArgumentsNotNull
    public String[] importServiceDefFile(Document domDocument, Map<String, Document> imports, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        InputSource wsdlSource = null;
        try {
            wsdlSource = new InputSource(new ByteArrayInputStream(XMLUtil.createStringFromDOMDocument((Node)domDocument).getBytes()));
        }
        catch (TransformerException e) {
            throw new WSDLServiceException("Can't create input source from the given wsdl Document.", e);
        }
        HashMap<String, InputSource> importSources = null;
        if (imports != null && imports.size() > 0) {
            importSources = new HashMap<String, InputSource>();
            Set<String> keys = imports.keySet();
            for (String key : keys) {
                InputSource importSource = null;
                try {
                    importSource = new InputSource(new ByteArrayInputStream(XMLUtil.createStringFromDOMDocument((Node)imports.get(key)).getBytes()));
                }
                catch (TransformerException e) {
                    throw new WSDLServiceException("Can't create input source from the given import Document.", e);
                }
                importSources.put(key, importSource);
            }
        }
        return this.importServiceDefFile(wsdlSource, importSources, wsdlFileName);
    }

    @CheckArgumentsNotNull
    public String[] importServiceDefFile2(Document domDocument, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        String wsdlSha1;
        String xmlString;
        try {
            xmlString = XMLUtil.createStringFromDOMDocument((Node)domDocument);
        }
        catch (TransformerException e) {
            throw new WSDLServiceException("Can't convert Dom to String", e);
        }
        try {
            wsdlSha1 = XMLUtil.getXMLSHA1Sign((InputStream)new ByteArrayInputStream(xmlString.getBytes()), (boolean)true);
        }
        catch (Exception e2) {
            throw new WSDLServiceException("Can't get WSDL SHA1 signature", e2);
        }
        String[] result = null;
        if (!this.alreadyRegisteredDesc(wsdlSha1)) {
            EasyWSDLTimeout easyWSDLTimeout = new EasyWSDLTimeout(this.wsdlReader, null, null, null);
            Description description = ((WSDLImportReport)easyWSDLTimeout.execute(5000)).getResult();
            SimpleFile storedWSDL = null;
            try {
                storedWSDL = this.metadataService.storeMetadata(ContentType.XML, xmlString, wsdlFileName);
            }
            catch (MetadataServiceException e1) {
                throw new WSDLServiceException("Can't register wsdl file to persistent storage", e1);
            }
            result = this.createDragonObjectModel(description, storedWSDL, wsdlSha1);
        }
        return result;
    }

    @Override
    @CheckArgumentsNotNull
    public String[] importServiceDefFile(InputSource wsdlSource, Map<String, InputSource> imports, String wsdlFileName) throws WSDLServiceException, TimeoutException {
        String wsdlSha1;
        InputStream originalInputStream = wsdlSource.getByteStream();
        InputStreamForker isf1 = new InputStreamForker(originalInputStream);
        InputStreamForker isf2 = new InputStreamForker(isf1.getInputStreamOne());
        try {
            wsdlSha1 = XMLUtil.getXMLSHA1Sign((InputStream)isf1.getInputStreamTwo(), (boolean)true);
        }
        catch (Exception e2) {
            throw new WSDLServiceException("Can't get WSDL SHA1 signature", e2);
        }
        String[] result = null;
        if (!this.alreadyRegisteredDesc(wsdlSha1)) {
            Description description = null;
            try {
                HashMap<URI, AbsItfDescription> importedWsdls = null;
                HashMap<URI, AbsItfSchema> importedSchemas = null;
                if (imports != null && imports.size() > 0) {
                    importedWsdls = new HashMap<URI, AbsItfDescription>();
                    importedSchemas = new HashMap<URI, AbsItfSchema>();
                    Set<String> keys = imports.keySet();
                    for (String key : keys) {
                        InputSource importSource = imports.get(key);
                        InputStream originalImportInputStream = importSource.getByteStream();
                        InputStreamForker isfImp1 = new InputStreamForker(originalImportInputStream);
                        Document importDoc = XMLUtil.createDocument((InputStream)isfImp1.getInputStreamOne());
                        importSource.setByteStream(isfImp1.getInputStreamTwo());
                        importDoc.setDocumentURI(".");
                        if (this.isWSDL(importDoc)) {
                            Description desc = this.wsdlReader.read(importSource);
                            importedWsdls.put(URI.create(key), (AbsItfDescription)desc);
                            continue;
                        }
                        if (!this.isSchema(importDoc)) continue;
                        Schema schema = this.schemaReader.read(importSource);
                        importedSchemas.put(URI.create(key), (AbsItfSchema)schema);
                    }
                }
                wsdlSource.setByteStream(isf2.getInputStreamOne());
                EasyWSDLTimeout easyWSDLTimeout = new EasyWSDLTimeout(this.wsdlReader, wsdlSource, importedWsdls, importedSchemas);
                WSDLImportReport wsdlImportReport = (WSDLImportReport)easyWSDLTimeout.execute(500000);
                description = wsdlImportReport.getResult();
                if (description == null) {
                    throw wsdlImportReport.getError();
                }
            }
            catch (WSDLException e) {
                throw new WSDLServiceException("Can't parse wsdl content. Check the wsdl validity.", e);
            }
            catch (SchemaException e) {
                throw new WSDLServiceException("Can't parse imported schema. Check the schema validity.", e);
            }
            catch (MalformedURLException e) {
                throw new WSDLServiceException("Can't parse wsdl content. Check the wsdl validity.", e);
            }
            catch (URISyntaxException e) {
                throw new WSDLServiceException("Can't parse wsdl content. Check the wsdl validity.", e);
            }
            catch (IllegalArgumentException e) {
                throw new WSDLServiceException("Can't parse wsdl content. Check the wsdl validity.", e);
            }
            catch (SAXException e) {
                throw new WSDLServiceException("Can't create document from InputSource.", e);
            }
            catch (IOException e) {
                throw new WSDLServiceException("Can't create document from InputSource.", e);
            }
            SimpleFile storedWSDL = null;
            try {
                storedWSDL = this.metadataService.storeMetadata(ContentType.XML, InputStreamUtil.getBytes((InputStream)isf2.getInputStreamTwo()), wsdlFileName);
            }
            catch (MetadataServiceException e1) {
                throw new WSDLServiceException("Can't register wsdl file to persistent storage", e1);
            }
            catch (IOException e) {
                throw new WSDLServiceException("Can't register wsdl file to persistent storage", e);
            }
            result = this.createDragonObjectModel(description, storedWSDL, wsdlSha1);
        }
        return result;
    }

    public void setServiceSpecificationUnifiedDAO(GenericUnifiedDAO<ServiceSpecification, String> serviceSpecificationUnifiedDAO) {
        this.serviceSpecificationUnifiedDAO = serviceSpecificationUnifiedDAO;
    }

    public void setUniversalUnifiedDAO(UniversalUnifiedDAO universalUnifiedDAO) {
        this.universalUnifiedDAO = universalUnifiedDAO;
    }
}

