/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * DataLoader.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.service.dataloader;

import java.io.InputStream;

import org.springframework.transaction.annotation.Transactional;

/**
 * DataLoader provides methods to load dataset into Dragon database
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public interface DataLoader {

    /**
     * Fill the database with information extracted from the given XML dataset,
     * referenced by the given URI String. The dataset schema
     * (dragon-dataset.xsd) is included in the Dragon web app (in the
     * 'WEB-INF/classes/dataset' folder).
     * 
     * @param xmlDataSetURI
     *            an URI String pointing on a xml dataset.
     * @throws DataLoaderException
     *             if an error occurs during dataset loading
     */
    @Transactional
    public void loadDataSet(String xmlDataSetURI) throws DataLoaderException;

    /**
     * Fill the database with information extracted from the given XML dataset,
     * provided as an {@link InputStream}. The dataset schema
     * (dragon-dataset.xsd) is included in the Dragon web app (in the
     * 'WEB-INF/classes/dataset' folder).
     * 
     * @param datasetStream
     * @throws DataLoaderException
     */
    @Transactional
    void loadDataset(InputStream datasetStream) throws DataLoaderException;

    /**
     * Rebuild the lucene search index synchronized with the database state.
     */
    public void rebuildIndex();

    /**
     * Rebuild the database schema. Remove all information from the database. Be
     * careful, it can't be reversed. Don't forget to reload Dragon base
     * TModels, before registering new data into Dragon DB.
     */
    @Transactional
    void recreateDatabase();

}
