/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * WSDLImporter.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.service.sla;

import java.util.List;

import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.persistence.bo.sla.ManagedAgreement;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/**
 * @author nsalatge - eBM WebSourcing
 * 
 */
@Transactional
public interface SLAManager {

    /**
     * JBI deploiement
     * 
     * @throws SLAServiceException
     */
    String createJBIXml(ManagedAgreementTO maTO) throws SLAServiceException;

    /**
     * ManagedAgreement Management
     */
    String createManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException;


    String createProbeSettingsXml(ManagedAgreementTO maTO) throws SLAServiceException;

  
    /**
     * export WS-agreement description
     * 
     * @param the
     *            id where the agreement is stored
     * @return the agreement
     * @throws SLAServiceException
     *             error to export
     */
    @Transactional(readOnly = true)
    String exportServiceDefFile(String id) throws SLAServiceException;


    @Transactional(readOnly = true)
    List<ManagedAgreementTO> getAllManagedAgreements(RequestOptionsTO requestOptionsTO)
            throws SLAServiceException;

 
    String importServiceDefFile(Document domDocument) throws SLAServiceException;

    String importServiceDefFile(Element domElement) throws SLAServiceException;

    String importServiceDefFile(InputSource inputSource) throws SLAServiceException;

    /**
     * import WS-agreement description
     * 
     * @param wsdlURI
     *            the uri of ws-agreement description
     * @return the id where the agreement is stored
     * @throws SLAServiceException
     *             error to import
     */
    String importServiceDefFile(String slaURI) throws SLAServiceException;
    
    ManagedAgreementTO getManagedAgreement(final String id) throws SLAServiceException;

    void removeManagedAgreement(String agreementId) throws SLAServiceException;

    @Transactional(readOnly = true)
    List<ManagedAgreementTO> searchManagedAgreement(String searchCriteria, List<String> searchedProperties, RequestOptionsTO iOptions)
            throws SLAServiceException;

    String updateManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException;

}
