/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * BindingOperationTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.deployment;

/**
 * This type gives the description of a an operation which is part of
 * {@link BindingTO}
 * 
 * @author ambarthe - eBM WebSourcing
 * 
 */
public class BindingOperationTO {

    private BindingTO binding;

    private String id;

    private String signature;

    private String style;

    private String pattern;

    /**
     * @return the binding
     */
    public BindingTO getBinding() {
        return this.binding;
    }

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    public String getPattern() {
        return this.pattern;
    }

    /**
     * @return the signature
     */
    public String getSignature() {
        return this.signature;
    }

    /**
     * @return the style
     */
    public String getStyle() {
        return this.style;
    }

    /**
     * @param binding
     *            the binding to set
     */
    public void setBinding(final BindingTO binding) {
        this.binding = binding;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    public void setPattern(final String pattern) {
        this.pattern = pattern;
    }

    /**
     * @param signature
     *            the signature to set
     */
    public void setSignature(final String signature) {
        this.signature = signature;
    }

    /**
     * @param style
     *            the style to set
     */
    public void setStyle(final String style) {
        this.style = style;
    }

}
