/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ServiceSearchProperties.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.deployment;

import java.util.HashMap;
import java.util.Map;

/**
 * An enumeration of Dragon supported person search properties
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public enum ServiceSearchProperties {
    NAME("name"), CATEGORY("category"), PURPOSE("purpose"), OPERATIONS("operations"), PROTOCOL(
            "protocol"), ORGANIZATION("organization"), RELATED_DOCS("relatedDocs");

    private final String property;

    private static final Map<String, ServiceSearchProperties> stringToEnum = new HashMap<String, ServiceSearchProperties>();

    static {
        for (ServiceSearchProperties type : values()) {
            stringToEnum.put(type.toString(), type);
        }
    }

    private ServiceSearchProperties(String type) {
        this.property = type;
    }

    @Override
    public String toString() {
        return this.property;
    }

    /**
     * Return the ServiceSearchProperties related to the given string or null if
     * it isn't supported
     * 
     * @param property
     *            the string representing a potential search property
     * @return the {@link ServiceSearchProperties} enum related to the given
     *         String
     */
    public static ServiceSearchProperties fromString(String property) {
        return stringToEnum.get(property);
    }

}
