/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TechnicalServiceTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.ow2.dragon.api.to.common.KeyedRefTO;

/**
 * This type gives a description of a service
 * 
 * @author ambarthe - eBM WebSourcing
 * 
 */

public class TechnicalServiceTO {

    /*
     * Attributes
     */
    private String id;

    private String name;

    private String purpose;

    private List<KeyedRefTO> categories;

    // Added By TIAR abderrahmane
    private RatingTO ratingTO;

    private float globalRating;

    private List<CommentTO> comments;

    private Set<String> tags;

    /**
     * @return the RatingTO
     */
    public RatingTO getRatingTO() {
        if (ratingTO == null) {
            ratingTO = new RatingTO();
        }
        return this.ratingTO;
    }

    /**
     * @return the globalRating
     */
    public float getGlobalRating() {
        return this.globalRating;
    }

    /**
     * @param the
     *            RatingTO the ratingTO to set
     */
    public void setRatingTO(final RatingTO ratingTO) {
        this.ratingTO = ratingTO;
    }

    /**
     * @param the
     *            new global rating the global rating to set
     */
    public void setGlobalRating(final float globalRating) {
        this.globalRating = globalRating;
    }

    /**
     * @return the set of tags
     */
    public Set<String> getTags() {
        if (tags == null) {
            this.tags = new HashSet<String>();
        }
        return this.tags;
    }

    /**
     * @param tags
     *            the tags (Strings) to set.
     */
    public void setTags(final Set<String> tags) {
        this.tags = tags;
    }

    /**
     * @return the list of comments
     */
    public List<CommentTO> getComments() {
        if (comments == null) {
            comments = new ArrayList<CommentTO>();
        }
        return this.comments;
    }

    /**
     * @param comments
     *            the list of CommentTO to set.
     */
    public void setComments(List<CommentTO> comments) {
        this.comments = comments;
    }

    // End of what's added By TIAR

    /*
     * Getters and setters
     */

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @return the purpose
     */
    public String getPurpose() {
        return this.purpose;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * @param purpose
     *            the purpose to set
     */
    public void setPurpose(final String purpose) {
        this.purpose = purpose;
    }

    public List<KeyedRefTO> getCategories() {
        return categories;
    }

    public void setCategories(List<KeyedRefTO> categories) {
        this.categories = categories;
    }

}
