/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PersonTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.organization;

/**
 * This type gives the description of a person.
 * 
 * @author ambarthe - eBM WebSourcing
 */
public class PersonTO extends PartyTO {
    // ==========================================================
    // === Attributes
    // ==========================================================

    private String title;

    private String firstname;

    private String middlename;

    private String lastname;

    private String email;

    private String phone;

    private String localization;

    private OrganizationUnitTO organization;

    private PostTO post;
    
    private boolean contact;

    /*
     * Getters and setters
     */

    /**
     * Returns the person's email
     * 
     * @return
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * Returns the person's firstname
     * 
     * @return
     */
    public String getFirstname() {
        return this.firstname;
    }

    public String getFullname() {
        String result = null;
        if (this.firstname != null) {
            result = this.lastname + " " + this.firstname;
        } else {
            result = this.lastname;
        }
        return result;
    }

    /**
     * Returns the person's lastname
     * 
     * @return
     */
    public String getLastname() {
        return this.lastname;
    }

    /**
     * Returns the person's localization
     * 
     * @return
     */
    public String getLocalization() {
        return this.localization;
    }

    /**
     * Returns the person's middlename
     * 
     * @return
     */
    public String getMiddlename() {
        return this.middlename;
    }

    /**
     * Returns the organization object
     * 
     * @return
     */
    public OrganizationUnitTO getOrganization() {
        return this.organization;
    }

    /**
     * Returns the person's phone
     * 
     * @return
     */
    public String getPhone() {
        return this.phone;
    }

    /**
     * Returns the person's post
     * 
     * @return
     */
    public PostTO getPost() {
        return this.post;
    }

    /**
     * Returns the person's title
     * 
     * @return
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * Sets the person's email
     * 
     * @param email
     */
    public void setEmail(final String email) {
        this.email = email;
    }

    /**
     * Sets the person's firstname
     * 
     * @param firstname
     */
    public void setFirstname(final String firstname) {
        this.firstname = firstname;
    }

    /**
     * Sets the person's lastname
     * 
     * @param lastname
     */
    public void setLastname(final String lastname) {
        this.lastname = lastname;
    }

    /**
     * Sets the person's localization
     * 
     * @param localization
     */
    public void setLocalization(final String localization) {
        this.localization = localization;
    }

    /**
     * Sets the person's middlename
     * 
     * @param middlename
     */
    public void setMiddlename(final String middlename) {
        this.middlename = middlename;
    }

    /**
     * Sets the organization's director
     * 
     * @param organization
     */
    public void setOrganization(final OrganizationUnitTO organization) {
        this.organization = organization;
    }

    /**
     * Sets the person's phone
     * 
     * @param email
     */
    public void setPhone(final String phone) {
        this.phone = phone;
    }

    /**
     * Sets the person's post
     * 
     * @param post
     */
    public void setPost(final PostTO post) {
        this.post = post;
    }

    /**
     * Sets the person's title
     * 
     * @param title
     */
    public void setTitle(final String title) {
        this.title = title;
    }

    public boolean isContact() {
        return contact;
    }

    public void setContact(boolean contact) {
        this.contact = contact;
    }

}
