/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ExecEnvManagerSearchProperties.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.technology;

import java.util.HashMap;
import java.util.Map;

/**
 * An enumeration of Dragon supported exec env manager search properties
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public enum ExecEnvManagerSearchProperties {
    NAME("name");

    private final String property;

    private static final Map<String, ExecEnvManagerSearchProperties> stringToEnum = new HashMap<String, ExecEnvManagerSearchProperties>();

    static {
        for (ExecEnvManagerSearchProperties type : values()) {
            stringToEnum.put(type.toString(), type);
        }
    }

    private ExecEnvManagerSearchProperties(String type) {
        this.property = type;
    }

    @Override
    public String toString() {
        return this.property;
    }

    /**
     * Return the ExecEnvManagerSearchProperties related to the given string or
     * null if it isn't supported
     * 
     * @param property
     *            the string representing a potential
     *            ExecEnvManagerSearchProperties
     * @return the {@link ExecEnvManagerSearchProperties} enum related to the
     *         given String
     */
    public static ExecEnvManagerSearchProperties fromString(String property) {
        return stringToEnum.get(property);
    }

}
