/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * KeyedReferenceGroup.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.common.KeyedReferenceGroup")
@Searchable(root = false)
public class KeyedReferenceGroup extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = -7029749458079059745L;

    public KeyedReferenceGroup(TModel tmodel, List<KeyedReference> keyedReferences) {
        super();
        this.tmodel = tmodel;
        if (keyedReferences != null) {
            this.keyedReferences = keyedReferences;
        } else {
            this.keyedReferences = new ArrayList<KeyedReference>();
        }
    }

    private TModel tmodel;

    @SearchableComponent
    private List<KeyedReference> keyedReferences;

    public KeyedReferenceGroup() {
        this.keyedReferences = new ArrayList<KeyedReference>();
    }

    public void addKeyedReference(KeyedReference keyedReference) {
        this.getKeyedReferences().add(keyedReference);
    }

    @OneToOne
    public TModel getTmodel() {
        return tmodel;
    }

    public void setTmodel(TModel tmodel) {
        this.tmodel = tmodel;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<KeyedReference> getKeyedReferences() {
        return keyedReferences;
    }

    public void setKeyedReferences(List<KeyedReference> keyedReferences) {
        this.keyedReferences = keyedReferences;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof KeyedReferenceGroup))
            return false;
        KeyedReferenceGroup castOther = (KeyedReferenceGroup) other;
        return new EqualsBuilder().append(tmodel, castOther.tmodel).append(keyedReferences,
                castOther.keyedReferences).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(tmodel).append(keyedReferences).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("keyedReferences",
                this.keyedReferences).append("tmodelKey", this.tmodel).toString();
    }

}
