/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Rating.java
 * -------------------------------------------------------------------------
 */


package org.ow2.dragon.persistence.bo.common;

import javax.persistence.Column;
import javax.persistence.Entity;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * @author atiar (Abderrahmane TIAR)
 * 
 */

@Entity(name = "org.ow2.dragon.persistence.bo.common.Rating")
public class Rating extends NonSearchableBaseObject {
    
    /**
     * 
     */
    private static final long serialVersionUID = 8677522476415242188L;
    
    private String userName;
    
    private int myRating ;
    
    public Rating(String userName) {
        super() ;
        this.userName = userName ;
        this.myRating = 0 ;
    }
    
    public Rating(String userName, int myRating) {
        super() ;
        this.userName = userName ;
        this.myRating = myRating ;
    }
    
    // Default Constructor
    public Rating() {
        super() ;
    }
    
    public void setUserName(String userName) {
        this.userName = userName ; 
    }
    
    @Column(nullable = false)
    public String getUserName() {
        return this.userName ;
    }
    
    public void setMyRating(int myRating) {
        this.myRating = myRating ;
    }
    
    public int getMyRating() {
        return this.myRating ;
    }
    
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof Rating))
            return false;
        Rating castOther = (Rating) other;
        return new EqualsBuilder().append(userName, castOther.userName)
                .append(this.getId(), castOther.getId()).
                append(myRating, castOther.myRating).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(userName).append(this.getId()).
        append(myRating).toHashCode();
    }
    
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("id", this.getId()).
        append("user", userName).append("myRating", myRating).toString();
    }
    
}
