/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ModelListener.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import java.util.Date;

import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.def.DefaultSaveOrUpdateEventListener;

/**
 * @author ofabre - ebmwebsourcing
 * 
 */
public class SaveOrUpdateBaseObject extends DefaultSaveOrUpdateEventListener {

    public void setDatesAndUser(BaseObject modelBase) {

        //System.out.println("############### Called on pre persist ");

        // TODO set createdBy and updatedBy User information
        /*
         * User currentUser = UserUtil.getCurrentUser(); UserUtil uses
         * ThreadLocal to store user
         * 
         * // check to see if modelBase and currentUser are // the same, if so,
         * make currentUser modelBase. if (modelBase.equals(currentUser)) {
         * currentUser = (User) modelBase; }
         * 
         * if (currentUser != null) { if (modelBase.getCreatedByUser() == null)
         * { modelBase.setCreatedByUser(currentUser); }
         * modelBase.setUpdatedByUser(currentUser); }
         */

        // set dateCreated and dateUpdated fields
        Date now = new Date();
        if (modelBase.getCreated() == null) {
            modelBase.setCreated(now);
        }
        modelBase.setLastUpdated(now);
    }

    @Override
    public void onSaveOrUpdate(SaveOrUpdateEvent event) {
        if (event.getObject() instanceof BaseObject) {
            this.setDatesAndUser((BaseObject) event.getObject());
        }

        super.onSaveOrUpdate(event);
    }

}
