/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Protocol.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.deployment;

import java.util.List;

import javax.persistence.Entity;

import org.compass.annotations.Searchable;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.deployment.Protocol")
@Searchable(root = false)
public class Protocol extends Standard {

    /**
     * 
     */
    private static final long serialVersionUID = 5330500768102579977L;

    public Protocol() {
        super();
    }

    public Protocol(Name name, boolean deleted, List<Description> descriptions,
            List<SimpleFile> overviewDocs, List<KeyedReference> identifierBag,
            CategoryBag categoryBag) {
        super(name, deleted, descriptions, overviewDocs, identifierBag, categoryBag);
    }

}
