/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SimpleFile.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.metadata;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.UDDIUseType;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.metadata.SimpleFile")
@Searchable(root = false)
public class SimpleFile extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = -4420806280865395128L;

    /*
     * Used if the metadata manager is setup with the filesystem repository
     * option
     */
    private String location;

    /*
     * Used if the metadata manager is setup with the database repository option
     */
    private Blob content;

    private ContentType fileType;

    private String fileName;

    private String author;

    private String title;

    private String extractedContent;

    private List<Description> descriptions;

    private Set<SimpleFile> importedFiles;

    private UDDIUseType useType;

    public SimpleFile() {
        super();
        this.descriptions = new ArrayList<Description>();
        this.importedFiles = new HashSet<SimpleFile>();
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addImportedFile(SimpleFile file) {
        this.getImportedFiles().add(file);
    }

    @Lob
    @Column(length = 1048576)
    public Blob getContent() {
        return this.content;
    }

    @Enumerated(EnumType.STRING)
    public ContentType getFileType() {
        return this.fileType;
    }

    public void setContent(final Blob content) {
        this.content = content;
    }

    public void setFileType(final ContentType fileType) {
        this.fileType = fileType;
    }

    @SearchableProperty
    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @SearchableProperty
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(length = 1048576)
    @SearchableProperty
    public String getExtractedContent() {
        return extractedContent;
    }

    public void setExtractedContent(String extractedContent) {
        this.extractedContent = extractedContent;
    }

    @OneToMany(cascade = CascadeType.REMOVE)
    @SearchableComponent
    public Set<SimpleFile> getImportedFiles() {
        return importedFiles;
    }

    public void setImportedFiles(Set<SimpleFile> importedFiles) {
        this.importedFiles = importedFiles;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @OneToMany(cascade = CascadeType.ALL)
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<Description> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("fileType",
                this.fileType).append("descriptions", this.descriptions).append("fileName",
                this.fileName).append("importedFiles", this.importedFiles).append("title",
                this.title).append("location", this.location).append("author", this.author)
                .toString();
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Enumerated(EnumType.STRING)
    public UDDIUseType getUseType() {
        return useType;
    }

    public void setUseType(UDDIUseType useType) {
        this.useType = useType;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof SimpleFile))
            return false;
        SimpleFile castOther = (SimpleFile) other;
        return new EqualsBuilder().append(location, castOther.location).append(content,
                castOther.content).append(fileType, castOther.fileType).append(fileName,
                castOther.fileName).append(author, castOther.author).append(title, castOther.title)
                .append(extractedContent, castOther.extractedContent).append(descriptions,
                        castOther.descriptions).append(useType, castOther.useType).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(location).append(content).append(fileType).append(
                fileName).append(author).append(title).append(extractedContent)
                .append(descriptions).append(useType).toHashCode();
    }

}
