/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EnvironmentFederation.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.technology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.CollectionOfElements;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;

/**
 * @author ofabre - eBM Websourcing
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.technology.EnvironmentFederation")
@Searchable
public class EnvironmentFederation extends SearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 357424309465096843L;

    public enum FedPattern {
        HUB_AND_SPOKE, FEDERATED, GRID, DISTRIBUTED
    }

    private String name;

    private FedPattern pattern;

    private List<String> possibleRole;

    private Set<ExecutionEnvironment> execEnvs;

    public EnvironmentFederation() {
        this.execEnvs = new HashSet<ExecutionEnvironment>();
        this.possibleRole = new ArrayList<String>();
    }

    public void addExecEnv(ExecutionEnvironment executionEnvironment) {
        this.execEnvs.add(executionEnvironment);
        executionEnvironment.setParentFederation(this);
    }

    public void addPossibleRole(String possibleRole) {
        this.possibleRole.add(possibleRole);
    }

    public void removeExecEnv(final ExecutionEnvironment executionEnvironment) {
        this.getExecEnvs().remove(executionEnvironment);
        executionEnvironment.setParentFederation(null);
    }

    @OneToMany(mappedBy = "parentFederation")
    public Set<ExecutionEnvironment> getExecEnvs() {
        return execEnvs;
    }

    public void setExecEnvs(Set<ExecutionEnvironment> execEnvs) {
        this.execEnvs = execEnvs;
    }

    @SearchableProperty
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Enumerated(EnumType.STRING)
    @SearchableProperty
    public FedPattern getPattern() {
        return pattern;
    }

    public void setPattern(FedPattern pattern) {
        this.pattern = pattern;
    }

    @CollectionOfElements
    public List<String> getPossibleRole() {
        return possibleRole;
    }

    public void setPossibleRole(List<String> possibleRole) {
        this.possibleRole = possibleRole;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof EnvironmentFederation))
            return false;
        EnvironmentFederation castOther = (EnvironmentFederation) other;
        return new EqualsBuilder().append(name, castOther.name).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("execEnvs",
                this.execEnvs).append("pattern", this.pattern).append("possibleRole",
                this.possibleRole).append("name", this.name).toString();
    }

}
