/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CategoryDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao.common.impl;

import java.util.List;

import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.dao.GenericHibernateDAOImpl;
import org.ow2.dragon.persistence.dao.common.IdentifierDAO;

import com.trg.search.Filter;
import com.trg.search.Search;

/**
 * @author ofabre
 * 
 */
public class IdentifierDAOImpl extends GenericHibernateDAOImpl<Identifier, String> implements
        IdentifierDAO {

    public List<Identifier> loadOrganizationRelatedIdentifierSystems() {
        return search(createSearchRequest("businessEntity"));
    }

    private Search createSearchRequest(String expectedEntityType) {
        Search search = new Search();
        search.addFilter(Filter.some("categoryBag.keyedReferences", Filter.or(Filter.and(Filter
                .equal("tmodel.id", "uddi:uddi.org:categorization:general_keywords"), Filter.equal(
                "keyName", "dragon.org:category:type"), Filter.equal("keyValue", "all")), Filter
                .and(Filter.equal("tmodel.id", "uddi:uddi.org:categorization:general_keywords"),
                        Filter.equal("keyName", "dragon.org:category:type"), Filter.equal(
                                "keyValue", expectedEntityType)))));
        search.addSortAsc("name.name");
        return search;
    }
}
