/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * OrganizationUnitUnifiedDAOImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.dao.organization.unified;

import java.util.List;

import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.dao.DAOLayerException;
import org.ow2.dragon.persistence.dao.GenericHibernateCompassDAOImpl;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitUnifiedDAO;

/**
 * @author ofabre
 * 
 */
public class OrganizationUnitUnifiedDAOImpl extends
        GenericHibernateCompassDAOImpl<OrganizationUnit, String> implements
        OrganizationUnitUnifiedDAO {

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.persistence.dao.organization.OrganizationUnitUnifiedDAO
     * #getOrgUnitByNameAndCity(java.lang.String, java.lang.String)
     */
    public OrganizationUnit getOrgUnitByNameAndCity(String name, String city) {
        return ((OrganizationUnitDAO) getGenericORMDAO()).getOrgUnitByNameAndCity(name, city);
    }

    public List<OrganizationUnit> getAllWithoutMeAndMyChildren(String initialOrgId)
            throws DAOLayerException {
        return ((OrganizationUnitDAO) getGenericORMDAO())
                .getAllWithoutMeAndMyChildren(initialOrgId);
    }

    public List<OrganizationUnit> getOrgAndChildren(String initialOrgId) {
        return ((OrganizationUnitDAO) getGenericORMDAO()).getOrgAndChildren(initialOrgId);
    }
}
