/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SLAImporterImpl.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.service.sla;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.api.service.sla.SLAManager;
import org.ow2.dragon.api.service.sla.SLAServiceException;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.sla.ManagedAgreement;
import org.ow2.dragon.persistence.dao.DAOLayerException;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.SearchHelper;
import org.ow2.dragon.util.StringHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;

/**
 * @author nsalatge - eBM WebSourcing
 * 
 */
public class SLAManagerImpl implements SLAManager {

    private MetadataService metadataService;

    private GenericUnifiedDAO<ManagedAgreement, String> managedAgreementUnifiedDAO;

    private SLATransfertObjectAssembler slatransfertObjectAssembler;

    private TransfertObjectAssembler transfertObjectAssembler;

    private TechServiceManager techServiceManager;

    /**
     * @param probesNS
     * @param protocolNS
     * @param prefixProbes
     * @param prefixProtocol
     * @param doc
     * @param entity
     * @param alarmElmt
     */
    private void createAlarm(final String probesNS, final String protocolNS,
            final String prefixProbes, final String prefixProtocol, final Document doc,
            final Party entity, final String type, final Element alarmElmt) {
        Element toElmt;
        Element protocolElmt;
        Element addressElmt;
        String email = null;
        String name = null;
        if (entity != null) {
            if (entity instanceof Person) {
                email = ((Person) entity).getEmailAddresses().get(0).getEmail();
                name = ((Person) entity).getFirstName() + " " + ((Person) entity).getLastName();
            } else if (entity instanceof OrganizationUnit) {
                email = ((OrganizationUnit) entity).getEmailAddresses().get(0).getEmail();
                name = ((OrganizationUnit) entity).getNames().get(0).getName();
            }

            if ((email != null) && (name != null)) {
                toElmt = doc.createElementNS(probesNS, "to");
                toElmt.setPrefix(prefixProbes);
                toElmt.setAttribute("name", name);
                toElmt.setAttribute("type", type);
                protocolElmt = doc.createElementNS(probesNS, "protocol");
                protocolElmt.setPrefix(prefixProbes);
                protocolElmt.setAttributeNS(protocolNS, "type", "mail");
                addressElmt = doc.createElementNS(protocolNS, "address");
                addressElmt.setPrefix(prefixProtocol);
                addressElmt.setTextContent(email);

                protocolElmt.appendChild(addressElmt);
                toElmt.appendChild(protocolElmt);
                alarmElmt.appendChild(toElmt);
            }
        }
    }

    /**
     * JBI deploiement
     */
    public String createJBIXml(final ManagedAgreementTO maTO) throws SLAServiceException {
        String jbiXmlForSu = null;
        // try {

        // final EndpointTO endpoint =
        // this.techServiceManager.getEndpoint(maTO.getAgreement()
        // .getServiceReference().getServiceName(), maTO.getAgreement()
        // .getServiceReference().getEpr());
        // if (endpoint == null) {
        // throw new SLAServiceException("Not endpoint found");
        // }

        // final SuBean suBean = new SuBean();

        // // Basic data.
        // suBean.setBc(true);
        // suBean.setConsume(true);
        // suBean.setInterfaceName(QName.valueOf(
        // endpoint.getBinding().getServiceInterface().getName()).getLocalPart());
        // suBean.setInterfaceNamespaceUri(QName.valueOf(
        // endpoint.getBinding().getServiceInterface().getName()).getNamespaceURI());
        // suBean
        // .setServiceName(QName.valueOf(endpoint.getTechService().getName())
        // .getLocalPart());
        // suBean.setServiceNamespaceUri(QName.valueOf(endpoint.getTechService().getName())
        // .getNamespaceURI());
        // suBean.setEndpointName(endpoint.getName());

        // suBean.setComponentName("Binding Component SOAP");
        // suBean.setComponentVersion("3.1");

        // // Complex data.
        // final ArrayList<XmlElement> cdkElements =
        // BasicBuilderForCdkElements.getCdkElements30(
        // SuMode.consume, null, null, null, null);

        // // probes.
        // final XmlElement probe = new XmlElement();
        // probe.setName("petalsCDK:probe");
        // probe.setValue("probesSettings.xml");
        // cdkElements.add(probe);
        // suBean.cdkElements.addAll(cdkElements);

        // final ArrayList<XmlElement> componentElements = new
        // ArrayList<XmlElement>();

        // // address.
        // final XmlElement address = new XmlElement();
        // address.setName("soap:address");
        // address.setValue(QName.valueOf(endpoint.getTechService().getName()).getLocalPart()
        // + "_" + maTO.getAgreement().getName());
        // componentElements.add(address);

        // // mode.
        // final XmlElement mode = new XmlElement();
        // mode.setName("soap:mode");
        // mode.setValue("SOAP");
        // componentElements.add(mode);

        // suBean.specificElements.addAll(componentElements);

        // jbiXmlForSu =
        // JbiXmlGenerator.getInstance().generateJbiXmlFileForSu(suBean);

        // } catch (final DeploymentException e) {
        // throw new SLAServiceException(e);
        // }
        return jbiXmlForSu;
    }

    /**
     * ManagedAgreement Management
     */

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.ui.businessdelegate.sla.SLAManager#createAgreement(org
     * .ow2.dragon.ui.model.to.sla.AgreementTO)
     */
    public String createManagedAgreement(final ManagedAgreementTO managedAgreementTO)
            throws SLAServiceException {
        String res = null;
        try {
            final ManagedAgreement a = this.slatransfertObjectAssembler
                    .toManagedAgreementBO(managedAgreementTO);

            String buffer = WSAgreementFactory.newInstance().newWSAgreementWriter().writeAgreement(
                    managedAgreementTO.getAgreement());

            final SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML,
                    buffer.getBytes());
            a.setAgreementFile(agreementFile);

            res = this.managedAgreementUnifiedDAO.save(a).getId();

        } catch (final WSAgreementException e) {
            throw new SLAServiceException(e);
        } catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }
        return res;
    }

    public String createProbeSettingsXml(final ManagedAgreementTO maTO) throws SLAServiceException {
        String res = null;
        // final String probesNS = "http://petals.ow2.org/probes";
        // final String protocolNS = "http://petals.ow2.org/protocols";
        // final String prefixProbes = "probe";
        // final String prefixProtocol = "pap";
        // try {
        // final Document doc =
        // DocumentBuilderFactory.newInstance().newDocumentBuilder()
        // .newDocument();

        // final Element confElmt = doc.createElementNS(probesNS,
        // "configuration");
        // confElmt.setPrefix(prefixProbes);
        // confElmt.setAttribute("name", "probesSettings4_" +
        // maTO.getAgreement().getName());

        // Party client = null;
        // Party provider = null;
        // Element contextElmt = null;
        // Element alarmElmt = null;
        // final Element toElmt = null;
        // final Element protocolElmt = null;
        // final Element addressElmt = null;
        // Element guaranteeElmt = null;
        // GuaranteeTermType guaranteeBO = null;
        // final Marshaller marshaller =
        // AgreementDescriptorBuilder.getJaxbContext()
        // .createMarshaller();
        // Document docGuarantee = null;
        // for (final GuaranteeTO guaranteeTO :
        // maTO.getAgreement().getGuarantee()) {
        // contextElmt = doc.createElementNS(probesNS, "context");
        // contextElmt.setPrefix(prefixProbes);
        // contextElmt.setAttribute("name", guaranteeTO.getName() + "_context");

        // guaranteeBO = (GuaranteeTermType)
        // this.guaranteeDAO.get(guaranteeTO.getId());
        // final JAXBElement<GuaranteeTermType> element = new
        // JAXBElement<GuaranteeTermType>(
        // new QName(probesNS, "guarantee"), GuaranteeTermType.class,
        // guaranteeBO);
        // docGuarantee =
        // DocumentBuilderFactory.newInstance().newDocumentBuilder()
        // .newDocument();
        // marshaller.marshal(element, docGuarantee);

        // guaranteeElmt = docGuarantee.getDocumentElement();

        // guaranteeElmt = (Element) doc.adoptNode(guaranteeElmt);
        // contextElmt.appendChild(guaranteeElmt);

        // alarmElmt = doc.createElementNS(probesNS, "alarm");
        // alarmElmt.setPrefix(prefixProbes);
        // alarmElmt.setAttribute("name", guaranteeTO.getName() + "_alarm");

        // client =
        // this.slatransfertObjectAssembler.getPartyBO(maTO.getIdClient());
        // provider =
        // this.slatransfertObjectAssembler.getPartyBO(maTO.getIdProvider());
        // this.createAlarm(probesNS, protocolNS, prefixProbes, prefixProtocol,
        // doc, client,
        // "client", alarmElmt);
        // this.createAlarm(probesNS, protocolNS, prefixProbes, prefixProtocol,
        // doc, provider,
        // "provider", alarmElmt);

        // contextElmt.appendChild(alarmElmt);
        // confElmt.appendChild(contextElmt);
        // }

        // doc.appendChild(confElmt);

        // res = XMLUtil.createStringFromDOMDocument(doc);
        // } catch (final ParserConfigurationException e) {
        // throw new SLAServiceException(e);
        // } catch (final TransformerException e) {
        // throw new SLAServiceException(e);
        // } catch (final JAXBException e) {
        // throw new SLAServiceException(e);
        // }
        return res;
    }

    private String[] createSearchProperties(List<String> searchedProperties) {
        final List<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains("name")) {
                propertiesList.add("name");
            }
            if (searchedProperties.contains("initiator")) {
                propertiesList.add("initiator");
            }
            if (searchedProperties.contains("responder")) {
                propertiesList.add("responder");
            }
        } else {
            // search on all properties
            propertiesList.add("name");
            propertiesList.add("initiator");
            propertiesList.add("responder");
        }
        return propertiesList.toArray(new String[0]);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.sla.SLAManager#exportServiceDefFile(java.lang.
     * String)
     */
    public String exportServiceDefFile(final String id) throws SLAServiceException {
        String result = null;
        try {
            final ManagedAgreement ag = this.managedAgreementUnifiedDAO.get(id);

            if (ag == null) {
                throw new SLAServiceException("Impossible to find managed agreement with id: " + id);
            }

            // Retrieve Agreement file content
            InputStream inputStream = null;
            try {
                inputStream = this.metadataService.loadMetadataContentAsInputStream(ag
                        .getAgreementFile().getId());
                result = StringHelper.toString(inputStream);
            } catch (final MetadataServiceException e) {
                throw new WSDLServiceException("Can't load agreement file content", e);
            } catch (final IOException e) {
                throw new WSDLServiceException("Can't convert agreement file content to String", e);
            }

        } catch (final Exception e) {
            throw new SLAServiceException("Can't retrieve sla agreement", e);
        }

        return result;

    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.ui.businessdelegate.sla.SLAManager#getAllAgreements(org
     * .ow2.dragon.ui.model.to.RequestOptions)
     */
    public List<ManagedAgreementTO> getAllManagedAgreements(final RequestOptionsTO requestOptionsTO)
            throws SLAServiceException {
        final List<ManagedAgreementTO> result = new ArrayList<ManagedAgreementTO>();
        final List<ManagedAgreement> agreements = this.managedAgreementUnifiedDAO
                .getAll(this.transfertObjectAssembler.toAgreementRequestOptions(requestOptionsTO));
        try {
            if ((agreements != null) && !agreements.isEmpty()) {
                for (final ManagedAgreement agreement : agreements) {
                    ManagedAgreementTO maTO = this.slatransfertObjectAssembler
                            .toManagedAgreementTO(agreement);

                    // load file
                    InputStream inputStream = metadataService
                            .loadMetadataContentAsInputStream(agreement.getAgreementFile().getId());
                    Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader()
                            .readAgreement(new URI("."), new InputSource(inputStream));
                    maTO.setAgreement(a);

                    if (a instanceof AgreementLifeCycle) {
                        ((AgreementLifeCycle) a).setState(AgreementLifeCycle.State.fromValue(maTO
                                .getState()));
                    }

                    result.add(maTO);
                }
            }
        } catch (final WSAgreementException e) {
            throw new SLAServiceException("Cannot convert agreement to agreement TO", e);
        } catch (URISyntaxException e) {
            throw new SLAServiceException("Cannot convert agreement to agreement TO", e);
        } catch (MetadataServiceException e) {
            throw new SLAServiceException("Cannot convert agreement to agreement TO", e);
        }
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.ui.businessdelegate.sla.SLAManager#getAgreement(java.lang
     * .Long)
     */
    public ManagedAgreementTO getManagedAgreement(final String id) throws SLAServiceException {
        ManagedAgreementTO agreementTO = null;
        final ManagedAgreement ag = this.managedAgreementUnifiedDAO.get(id);

        if (ag == null) {
            throw new SLAServiceException("Impossible to find agreement with id: " + id);
        }

        try {

            // create tech serv to from bo
            agreementTO = this.slatransfertObjectAssembler.toManagedAgreementTO(ag);

            // load file
            InputStream inputStream = metadataService.loadMetadataContentAsInputStream(ag
                    .getAgreementFile().getId());
            Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader().readAgreement(
                    new URI("."), new InputSource(inputStream));
            agreementTO.setAgreement(a);

            if (a instanceof AgreementLifeCycle) {
                ((AgreementLifeCycle) a).setState(AgreementLifeCycle.State.fromValue(agreementTO
                        .getState()));
            }

        } catch (final WSAgreementException e) {
            throw new SLAServiceException("Can't parse sla agreement", e);
        } catch (URISyntaxException e) {
            throw new SLAServiceException("Can't parse sla agreement", e);
        } catch (MetadataServiceException e) {
            throw new SLAServiceException("Can't parse sla agreement", e);
        }

        return agreementTO;
    }

    /**
     * @return the managedAgreementDAO
     */
    public GenericUnifiedDAO<ManagedAgreement, String> getManagedAgreementUnifiedDAO() {
        return this.managedAgreementUnifiedDAO;
    }

    public SLATransfertObjectAssembler getSlatransfertObjectAssembler() {
        return this.slatransfertObjectAssembler;
    }

    /**
     * @return the techServiceManager
     */
    public TechServiceManager getTechServiceManager() {
        return this.techServiceManager;
    }

    /**
     * @return the transfertObjectAssembler
     */
    public TransfertObjectAssembler getTransfertObjectAssembler() {
        return this.transfertObjectAssembler;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.sla.SLAManager#importServiceDefFile(org.w3c.dom
     * .Document)
     */
    public String importServiceDefFile(final Document domDocument) throws SLAServiceException {

        /*
         * Store WSDL file in persistent storage
         */

        /*
         * Parse wsdl with Woden
         */

        /*
         * Convert Woden wsdl object model to Dragon object model
         */

        /*
         * Persist Dragon object model
         */
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.sla.SLAManager#importServiceDefFile(org.w3c.dom
     * .Element)
     */
    public String importServiceDefFile(final Element domElement) throws SLAServiceException {
        /*
         * Store WSDL file in persistent storage
         */

        /*
         * Parse wsdl with Woden
         */

        /*
         * Convert Woden wsdl object model to Dragon object model
         */

        /*
         * Persist Dragon object model
         */
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.service.sla.SLAManager#importServiceDefFile(org.xml.sax
     * .InputSource)
     */
    public String importServiceDefFile(final InputSource inputSource) throws SLAServiceException {

        /*
         * Store WSDL file in persistent storage
         */

        /*
         * Parse wsdl with Woden
         */

        /*
         * Convert Woden wsdl object model to Dragon object model
         */

        /*
         * Persist Dragon object model
         */
        return null;
    }

    /*
     * (non-Javadoc)
     * 
     * see
     * org.ow2.dragon.service.sla.SLAManager#importServiceDefFile(java.lang.String
     * )
     */
    public String importServiceDefFile(final String slaURI) throws SLAServiceException {
        String storedSLAId = null;
        try {
            /*
             * Store SLA file in persistent storage
             */
            final SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML,
                    URI.create(slaURI));

            /*
             * set transformer
             */
            System.setProperty("javax.xml.transform.TransformerFactory",
                    "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");

            ManagedAgreement managedAgreement = null;
            InputStream inputStream = metadataService
                    .loadMetadataContentAsInputStream(agreementFile.getId());
            Agreement agreement = WSAgreementFactory.newInstance().newWSAgreementReader()
                    .readAgreement(URI.create(slaURI), new InputSource(inputStream));

            if (isEditable(agreement)) {
                managedAgreement = new ManagedAgreement(true);
            } else {
                managedAgreement = new ManagedAgreement(false);
            }
            managedAgreement.setAgreementFile(agreementFile);

            /*
             * persist agreement
             */
            storedSLAId = this.managedAgreementUnifiedDAO.save(managedAgreement).getId();

            managedAgreement.setAgreementFile(agreementFile);

        } catch (final MetadataServiceException e) {
            throw new SLAServiceException("Can't register sla file to persistent storage", e);
        } catch (final WSAgreementException e) {
            throw new SLAServiceException("Can't create sla agreement", e);
        }

        return storedSLAId;

    }

    /**
     * @param ag
     * @throws AddressingException
     * @throws SLAServiceException
     */
    private boolean isEditable(final Agreement ag) throws SLAServiceException {
        boolean res = true;
        try {
            if (ag.getContext() != null) {

                if (!(ag.getContext().getInitiator() instanceof EndpointReferenceType)) {
                    res = false;
                }

                if (!(ag.getContext().getResponder() instanceof EndpointReferenceType)) {
                    res = false;
                }
            }
        } catch (WSAddressingException e) {
            throw new SLAServiceException(e);
        }

        if (res) {
            // for (final ExactlyOneOrOneOrMoreOrAllItem item :
            // mag.getAgreement().getTerms().getAll()
            // .getExactlyOneOrOneOrMoreOrAllItems()) {
            // if (item.getItemServiceDescriptionTerm() != null) {
            // if ((!(item.getItemServiceDescriptionTerm().getAny() instanceof
            // ReferenceProperties))
            // && (!(item.getItemServiceDescriptionTerm().getAny() instanceof
            // JAXBElement) && (((JAXBElement) item
            // .getItemServiceDescriptionTerm().getAny()).getValue() instanceof
            // ReferenceProperties))) {
            // return false;
            // }
            // }
            // if (item.getItemServiceReference() != null) {
            // if ((!(item.getItemServiceReference().getAny() instanceof
            // EndpointReferenceType))
            // && (!(item.getItemServiceReference().getAny() instanceof
            // JAXBElement) && (((JAXBElement) item
            // .getItemServiceReference().getAny()).getValue() instanceof
            // EndpointReferenceType))) {
            // {
            // return false;
            // }
            // }
            // if (item.getItemGuaranteeTerm() != null) {
            // if (!(item.getItemGuaranteeTerm().getQualifyingCondition()
            // instanceof TExpression)) {
            // return false;
            // }
            // if
            // (!(item.getItemGuaranteeTerm().getServiceLevelObjective().getKPITarget()
            // .getTarget() instanceof TExpression)) {
            // return false;
            // }
            // for (final CompensationType c : item.getItemGuaranteeTerm()
            // .getBusinessValueList().getPenalty()) {
            // if (!(c.getValueExpression() instanceof TExpression)) {
            // return false;
            // }
            // }
            // for (final CompensationType c : item.getItemGuaranteeTerm()
            // .getBusinessValueList().getReward()) {
            // if (!(c.getValueExpression() instanceof TExpression)) {
            // return false;
            // }
            // }
            // }
            // }
            // }
        }
        return res;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.ui.businessdelegate.sla.SLAManager#removeAgreement(java
     * .lang.Long)
     */
    public void removeManagedAgreement(final String id) throws SLAServiceException {
        this.managedAgreementUnifiedDAO.remove(id);
    }

    /*
     * (non-Javadoc)
     * 
     * @seeorg.ow2.dragon.ui.businessdelegate.deployment.TechServiceManager#
     * searchTechService(java.lang.String, boolean, boolean, boolean, boolean,
     * boolean, boolean, org.ow2.dragon.ui.model.to.RequestOptions)
     */
    public List<ManagedAgreementTO> searchManagedAgreement(final String searchCriteria,
            List<String> searchedProperties, final RequestOptionsTO options)
            throws SLAServiceException {
        final List<ManagedAgreementTO> result = new ArrayList<ManagedAgreementTO>();

        // Split searchCriteria
        final String[] criteria = SearchHelper.splitSearchCriteria(searchCriteria);

        // Create search properties
        final String[] properties = this.createSearchProperties(searchedProperties);

        // Search for bo
        List<ManagedAgreement> agreementsBO;
        try {
            agreementsBO = this.managedAgreementUnifiedDAO.searchORMResult(criteria, properties,
                    this.transfertObjectAssembler.toAgreementRequestOptions(options));
        } catch (DAOLayerException e) {
            throw new SLAServiceException(
                    "You must specified non empty search criteria and properties.", e);
        }
        try {
            // Create result array
            if ((agreementsBO != null) && !agreementsBO.isEmpty()) {
                for (final ManagedAgreement managedAgreement : agreementsBO) {
                    ManagedAgreementTO mabTO = this.slatransfertObjectAssembler
                            .toManagedAgreementTO(managedAgreement);

                    // load file
                    InputStream inputStream = metadataService
                            .loadMetadataContentAsInputStream(managedAgreement.getAgreementFile()
                                    .getId());
                    Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader()
                            .readAgreement(new URI("."), new InputSource(inputStream));
                    mabTO.setAgreement(a);

                    if (a instanceof AgreementLifeCycle) {
                        ((AgreementLifeCycle) a).setState(AgreementLifeCycle.State.fromValue(mabTO
                                .getState()));
                    }

                    result.add(mabTO);
                }
            }
        } catch (final WSAgreementException e) {
            throw new SLAServiceException(e);
        } catch (URISyntaxException e) {
            throw new SLAServiceException(e);
        } catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }
        return result;
    }

    /**
     * @param managedAgreementDAO
     *            the managedAgreementDAO to set
     */
    public void setManagedAgreementUnifiedDAO(
            final GenericUnifiedDAO<ManagedAgreement, String> managedAgreementUnifiedDAO) {
        this.managedAgreementUnifiedDAO = managedAgreementUnifiedDAO;
    }

    public void setMetadataService(final MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setSlatransfertObjectAssembler(
            final SLATransfertObjectAssembler slatransfertObjectAssembler) {
        this.slatransfertObjectAssembler = slatransfertObjectAssembler;
    }

    /**
     * @param techServiceManager
     *            the techServiceManager to set
     */
    public void setTechServiceManager(final TechServiceManager techServiceManager) {
        this.techServiceManager = techServiceManager;
    }

    /**
     * @param transfertObjectAssembler
     *            the transfertObjectAssembler to set
     */
    public void setTransfertObjectAssembler(final TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.dragon.ui.businessdelegate.sla.SLAManager#updateAgreement(org
     * .ow2.dragon.ui.model.to.agreement.AgreementTO)
     */
    public String updateManagedAgreement(final ManagedAgreementTO managedAgreementTO)
            throws SLAServiceException {
        // Retrieve agreeement
        final ManagedAgreement managedAgreement = this.managedAgreementUnifiedDAO
                .get(managedAgreementTO.getId());
        if (managedAgreement == null) {
            throw new SLAServiceException(
                    "Your are trying to update a non existing agreement with id: "
                            + managedAgreementTO.getId());
        }

        try {
            // update fields
            this.slatransfertObjectAssembler.toManagedAgreementBO(managedAgreementTO,
                    managedAgreement);
            this.managedAgreementUnifiedDAO.save(managedAgreement);

            // save file
            String buffer = WSAgreementFactory.newInstance().newWSAgreementWriter().writeAgreement(
                    managedAgreementTO.getAgreement());

            /*
             * Blob content = new BlobImpl(buffer.getBytes());
             * managedAgreement.getAgreementFile().setContent(content);
             */
            // Remove old file
            metadataService.deleteMetadata(managedAgreement.getAgreementFile().getId());

            // Write new one
            final SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML,
                    buffer.getBytes());
            managedAgreement.setAgreementFile(agreementFile);

        } catch (WSAgreementException e) {
            throw new SLAServiceException(e);
        } catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }

        return managedAgreement.getId();
    }

    public MetadataService getMetadataService() {
        return metadataService;
    }

}
