/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.compass.annotations.SearchableProperty;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CommunityObj;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.deployment.TechnicalService")
@Searchable
public class TechnicalService
extends CommunityObj {
    private static final long serialVersionUID = 1731694441773447781L;
    @SearchableComponent
    private Set<Endpoint> endpoints = new HashSet<Endpoint>();
    private Set<ServiceSpecification> serviceSpecifications = new HashSet<ServiceSpecification>();
    @SearchableComponent
    private Set<SimpleFile> relatedDocs = new HashSet<SimpleFile>();
    @SearchableComponent
    private List<Name> names = new ArrayList<Name>();
    @SearchableProperty
    private String fullName;
    @SearchableComponent
    private List<Description> descriptions = new ArrayList<Description>();
    @SearchableComponent
    private CategoryBag categoryBag;

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof TechnicalService)) {
            return false;
        }
        TechnicalService castOther = (TechnicalService)other;
        return new EqualsBuilder().append(this.names, castOther.names).append((Object)this.fullName, (Object)castOther.fullName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.names).append((Object)this.fullName).toHashCode();
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addName(Name name) {
        this.getNames().add(name);
    }

    public void addEndpoint(Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.setTechnicalService(this);
    }

    public void addRelatedDoc(SimpleFile relatedDoc) {
        this.getRelatedDocs().add(relatedDoc);
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Name> getNames() {
        return this.names;
    }

    public void setNames(List<Name> names) {
        this.names = names;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="technicalService")
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @ManyToMany(mappedBy="technicalServices")
    public Set<ServiceSpecification> getServiceSpecifications() {
        return this.serviceSpecifications;
    }

    public void setServiceSpecifications(Set<ServiceSpecification> serviceSpecifications) {
        this.serviceSpecifications = serviceSpecifications;
    }

    @ManyToMany
    public Set<SimpleFile> getRelatedDocs() {
        return this.relatedDocs;
    }

    public void setRelatedDocs(Set<SimpleFile> relatedDocs) {
        this.relatedDocs = relatedDocs;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("descriptions", this.descriptions).append("categoryBag", (Object)this.categoryBag).append("names", this.names).append("endpoints", this.endpoints).append("relatedDocs", this.relatedDocs).toString();
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }
}

