/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.organization;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableComponent;
import org.hibernate.annotations.Cascade;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.LinkedEntity;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.organization.Party")
@Inheritance(strategy=InheritanceType.JOINED)
@Searchable(root=false)
public class Party
extends LinkedEntity {
    private static final long serialVersionUID = 4264025768507516327L;
    @SearchableComponent
    private List<Description> descriptions;
    private List<Email> emailAddresses;
    private boolean isExternal;
    @SearchableComponent
    private List<Name> names = new ArrayList<Name>();
    private OrganizationUnit parentOrganization;
    private String responsabilities;
    private List<Address> addresses;

    public Party() {
        this.descriptions = new ArrayList<Description>();
        this.emailAddresses = new ArrayList<Email>();
        this.addresses = new ArrayList<Address>();
    }

    public void addAddress(Address address) {
        this.getAddresses().add(address);
    }

    public void addEmail(Email email) {
        this.getEmailAddresses().add(email);
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addName(Name name) {
        this.getNames().add(name);
    }

    @OneToMany(cascade={CascadeType.ALL})
    @OrderBy(value="name ASC")
    @SearchableComponent
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Name> getNames() {
        return this.names;
    }

    @ManyToOne
    @SearchableComponent
    public OrganizationUnit getParentOrganization() {
        return this.parentOrganization;
    }

    public String getResponsabilities() {
        return this.responsabilities;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setNames(List<Name> name) {
        this.names = name;
    }

    public void setParentOrganization(OrganizationUnit parentOrganization) {
        this.parentOrganization = parentOrganization;
    }

    public void setResponsabilities(String responsabilities) {
        this.responsabilities = responsabilities;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Email> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(List<Email> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @SearchableComponent
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Party)) {
            return false;
        }
        Party castOther = (Party)other;
        return new EqualsBuilder().append(this.names, castOther.names).append(this.addresses, castOther.addresses).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.names).append(this.addresses).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("addresses", this.addresses).append("isExternal", this.isExternal).append("descriptions", this.descriptions).append("responsabilities", (Object)this.responsabilities).append("names", this.names).append("emailAddresses", this.emailAddresses).toString();
    }
}

