/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.technology;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.compass.annotations.Searchable;
import org.compass.annotations.SearchableProperty;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="org.ow2.dragon.persistence.bo.technology.Node")
@Inheritance(strategy=InheritanceType.JOINED)
@Searchable(root=false)
public class Node
extends SearchableBaseObject {
    private static final long serialVersionUID = 8132001335710138670L;
    private String name;
    private String type;
    private String ipv4Address;
    private boolean isPrototypical;
    private int expectedQuantity;
    private Set<Endpoint> endpoints = new HashSet<Endpoint>();
    private ExecutionEnvironmentManager manager;

    @OneToMany(mappedBy="hostNode")
    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Set<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void addEndpoint(Endpoint endpoint) {
        this.getEndpoints().add(endpoint);
        endpoint.setHostNode(this);
    }

    @SearchableProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPrototypical() {
        return this.isPrototypical;
    }

    public void setPrototypical(boolean isPrototypical) {
        this.isPrototypical = isPrototypical;
    }

    public int getExpectedQuantity() {
        return this.expectedQuantity;
    }

    public void setExpectedQuantity(int expectedQuantity) {
        this.expectedQuantity = expectedQuantity;
    }

    @SearchableProperty
    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public void setIpv4Address(String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    @ManyToOne
    @JoinColumn(name="execEnvManagerId")
    public ExecutionEnvironmentManager getManager() {
        return this.manager;
    }

    public void setManager(ExecutionEnvironmentManager manager) {
        this.manager = manager;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Node)) {
            return false;
        }
        Node castOther = (Node)other;
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("isPrototypical", this.isPrototypical).append("ipv4Address", (Object)this.ipv4Address).append("type", (Object)this.type).append("expectedQuantity", this.expectedQuantity).append("endpoints", this.endpoints).append("name", (Object)this.name).toString();
    }
}

