/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.annotations.Searchable;
import org.compass.core.Compass;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassConfigurationFactory;
import org.compass.core.config.InputStreamMappingResolver;
import org.compass.core.converter.Converter;
import org.compass.core.lucene.engine.store.jdbc.ExternalDataSourceProvider;
import org.compass.core.spi.InternalCompass;
import org.compass.spring.LocalCompassBean;
import org.compass.spring.LocalCompassBeanPostProcessor;
import org.compass.spring.transaction.SpringSyncTransactionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedLocalCompassBean
implements FactoryBean,
InitializingBean,
DisposableBean,
BeanNameAware,
ApplicationContextAware,
BeanClassLoaderAware,
ResourceLoaderAware {
    private static final String RESOURCE_PATTERN = "**/*.class";
    private String[] packagesToScan;
    private TypeFilter[] entityTypeFilters = new TypeFilter[]{new AnnotationTypeFilter(Searchable.class, false)};
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    protected static final Log log = LogFactory.getLog(LocalCompassBean.class);
    private Resource connection;
    private Resource configLocation;
    private String mappingScan;
    private Resource[] configLocations;
    private Resource[] resourceLocations;
    private Resource[] resourceJarLocations;
    private Resource[] resourceDirectoryLocations;
    private String[] classMappings;
    private InputStreamMappingResolver[] mappingResolvers;
    private Properties compassSettings;
    private Map<String, Object> settings;
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;
    private Map<String, Converter> convertersByName;
    private Compass compass;
    private String beanName;
    private ClassLoader classLoader;
    private ApplicationContext applicationContext;
    private CompassConfiguration config;
    private LocalCompassBeanPostProcessor postProcessor;

    public void setPackagesToScan(String[] packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = resourceLoader != null ? ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader) : new PathMatchingResourcePatternResolver();
    }

    public void setPostProcessor(LocalCompassBeanPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setConnection(Resource connection) {
        this.connection = connection;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }

    public void setMappingScan(String basePackage) {
        this.mappingScan = basePackage;
    }

    public void setCompassSettings(Properties compassSettings) {
        this.compassSettings = compassSettings;
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    public void setResourceLocations(Resource[] resourceLocations) {
        this.resourceLocations = resourceLocations;
    }

    public void setResourceJarLocations(Resource[] resourceJarLocations) {
        this.resourceJarLocations = resourceJarLocations;
    }

    public void setResourceDirectoryLocations(Resource[] resourceDirectoryLocations) {
        this.resourceDirectoryLocations = resourceDirectoryLocations;
    }

    public void setClassMappings(String[] classMappings) {
        this.classMappings = classMappings;
    }

    public void setMappingResolvers(InputStreamMappingResolver[] mappingResolvers) {
        this.mappingResolvers = mappingResolvers;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        if (!(dataSource instanceof TransactionAwareDataSourceProxy)) {
            this.dataSource = new TransactionAwareDataSourceProxy(dataSource);
        }
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setConvertersByName(Map<String, Converter> convertersByName) {
        this.convertersByName = convertersByName;
    }

    public void setCompassConfiguration(CompassConfiguration config) {
        this.config = config;
    }

    public void afterPropertiesSet() throws Exception {
        String string;
        CompassConfiguration config = this.config;
        if (config == null) {
            config = this.newConfiguration();
        }
        if (this.classLoader != null) {
            config.setClassLoader(this.getClassLoader());
        }
        if (this.configLocation != null) {
            config.configure(this.configLocation.getURL());
        }
        if (this.configLocations != null) {
            for (Resource resource : this.configLocations) {
                config.configure(resource.getURL());
            }
        }
        if (this.mappingScan != null) {
            config.addScan(this.mappingScan);
        }
        if (this.compassSettings != null) {
            config.getSettings().addSettings(this.compassSettings);
        }
        if (this.settings != null) {
            config.getSettings().addSettings(this.settings);
        }
        if (this.resourceLocations != null) {
            for (Resource resource : this.resourceLocations) {
                config.addInputStream(resource.getInputStream(), resource.getFilename());
            }
        }
        if (this.resourceJarLocations != null) {
            for (Resource resource : this.resourceJarLocations) {
                config.addJar(resource.getFile());
            }
        }
        if (this.classMappings != null) {
            for (String string2 : this.classMappings) {
                config.addClass(ClassUtils.forName((String)string2, (ClassLoader)this.getClassLoader()));
            }
        }
        this.scanPackages(config);
        if (this.resourceDirectoryLocations != null) {
            for (Resource resource : this.resourceDirectoryLocations) {
                File file = resource.getFile();
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Resource directory location [" + resource + "] does not denote a directory");
                }
                config.addDirectory(file);
            }
        }
        if (this.mappingResolvers != null) {
            for (InputStreamMappingResolver inputStreamMappingResolver : this.mappingResolvers) {
                config.addMappingResolver(inputStreamMappingResolver);
            }
        }
        if (this.dataSource != null) {
            ExternalDataSourceProvider.setDataSource((DataSource)this.dataSource);
            if (config.getSettings().getSetting("compass.engine.store.jdbc.connection.provider.class") == null) {
                config.getSettings().setSetting("compass.engine.store.jdbc.connection.provider.class", ExternalDataSourceProvider.class.getName());
            }
        }
        if ((string = config.getSettings().getSetting("compass.transaction.factory")) == null && this.transactionManager != null) {
            config.getSettings().setSetting("compass.transaction.factory", SpringSyncTransactionFactory.class.getName());
        }
        if (string != null && string.equals(SpringSyncTransactionFactory.class.getName()) && this.transactionManager == null) {
            throw new IllegalArgumentException("When using SpringSyncTransactionFactory the transactionManager property must be set");
        }
        SpringSyncTransactionFactory.setTransactionManager((PlatformTransactionManager)this.transactionManager);
        if (this.convertersByName != null) {
            for (Map.Entry<String, Converter> entry : this.convertersByName.entrySet()) {
                config.registerConverter(entry.getKey(), entry.getValue());
            }
        }
        if (config.getSettings().getSetting("compass.name") == null) {
            config.getSettings().setSetting("compass.name", this.beanName);
        }
        if (config.getSettings().getSetting("compass.engine.connection") == null && this.connection != null) {
            config.getSettings().setSetting("compass.engine.connection", this.connection.getFile().getAbsolutePath());
        }
        if (this.applicationContext != null) {
            String[] names;
            for (String name : names = this.applicationContext.getBeanNamesForType(PropertyPlaceholderConfigurer.class)) {
                try {
                    PropertyPlaceholderConfigurer propConfigurer = (PropertyPlaceholderConfigurer)this.applicationContext.getBean(name);
                    Method method = this.findMethod(propConfigurer.getClass(), "mergeProperties", new Class[0]);
                    method.setAccessible(true);
                    Properties props = (Properties)method.invoke((Object)propConfigurer, new Object[0]);
                    method = this.findMethod(propConfigurer.getClass(), "convertProperties", Properties.class);
                    method.setAccessible(true);
                    method.invoke((Object)propConfigurer, props);
                    method = this.findMethod(propConfigurer.getClass(), "parseStringValue", String.class, Properties.class, Set.class);
                    method.setAccessible(true);
                    String nullValue = null;
                    try {
                        Field field = propConfigurer.getClass().getDeclaredField("nullValue");
                        field.setAccessible(true);
                        nullValue = (String)field.get(propConfigurer);
                    }
                    catch (NoSuchFieldException e) {
                        // empty catch block
                    }
                    for (Map.Entry<Object, Object> entry : config.getSettings().getProperties().entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        value = (String)method.invoke((Object)propConfigurer, value, props, new HashSet());
                        config.getSettings().setSetting(key, value.equals(nullValue) ? null : value);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to apply property placeholder defined in bean [" + name + "]"), (Throwable)e);
                }
            }
        }
        if (this.postProcessor != null) {
            this.postProcessor.process(config);
        }
        this.compass = this.newCompass(config);
        this.compass = (Compass)Proxy.newProxyInstance(SpringCompassInvocationHandler.class.getClassLoader(), new Class[]{InternalCompass.class}, (InvocationHandler)new SpringCompassInvocationHandler(this.compass));
    }

    protected CompassConfiguration newConfiguration() {
        return CompassConfigurationFactory.newConfiguration();
    }

    protected Compass newCompass(CompassConfiguration config) throws CompassException {
        return config.buildCompass();
    }

    public Object getObject() throws Exception {
        return this.compass;
    }

    public Class getObjectType() {
        return this.compass != null ? this.compass.getClass() : Compass.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        this.compass.close();
    }

    protected ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private Method findMethod(Class clazz, String methodName, Class ... parameterTypes) {
        if (clazz.equals(Object.class)) {
            return null;
        }
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return this.findMethod(clazz.getSuperclass(), methodName, parameterTypes);
        }
    }

    protected void scanPackages(CompassConfiguration config) {
        if (this.packagesToScan != null) {
            try {
                for (String pkg : this.packagesToScan) {
                    String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                    for (Resource resource : resources) {
                        if (!resource.isReadable()) continue;
                        MetadataReader reader = readerFactory.getMetadataReader(resource);
                        String className = reader.getClassMetadata().getClassName();
                        if (!this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                        config.addClass(ClassUtils.forName((String)className, (ClassLoader)this.getClassLoader()));
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Failed to scan classpath for unlisted classes", ex);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Failed to load annotated classes from classpath", ex);
            }
        }
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        if (this.entityTypeFilters != null) {
            for (TypeFilter filter : this.entityTypeFilters) {
                if (!filter.match(reader, readerFactory)) continue;
                return true;
            }
        }
        return false;
    }

    private class SpringCompassInvocationHandler
    implements InvocationHandler {
        private static final String GET_TARGET_COMPASS_METHOD_NAME = "getTargetCompass";
        private static final String CLONE_METHOD = "clone";
        private Compass targetCompass;

        public SpringCompassInvocationHandler(Compass targetCompass) {
            this.targetCompass = targetCompass;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals(GET_TARGET_COMPASS_METHOD_NAME)) {
                return ExtendedLocalCompassBean.this.compass;
            }
            if (method.getName().equals(CLONE_METHOD) && args.length == 1) {
                if (ExtendedLocalCompassBean.this.dataSource != null) {
                    ExternalDataSourceProvider.setDataSource((DataSource)ExtendedLocalCompassBean.this.dataSource);
                }
                SpringSyncTransactionFactory.setTransactionManager((PlatformTransactionManager)ExtendedLocalCompassBean.this.transactionManager);
            }
            try {
                return method.invoke((Object)this.targetCompass, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

