/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.util;

import com.trg.search.Filter;
import com.trg.search.ISearch;
import com.trg.search.Search;
import com.trg.search.Sort;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.springframework.orm.hibernate3.HibernateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateQueryHelper {
    public static final String CLAUSE_SELECT = "select";
    public static final String OPERATOR_DISTINCT = "distinct";
    public static final String CLAUSE_FROM = "from";
    public static final String CLAUSE_WHERE = "where";
    public static final String CLAUSE_GROUPBY = "group by";
    public static final String CLAUSE_ORDERBY = "order by";
    public static final String CLAUSE_HAVING = "having";
    public static final String OPERATOR_OR = "or";
    public static final String OPERATOR_AND = "and";
    public static final String PREDICATE_EQUALS = "=";
    public static final String PREDICATE_NOTEQUALS = "!=";
    public static final String PREDICATE_LIKE = "like";
    public static final String PREDICATE_IN = "in";
    public static final String SORT_ASC = "asc";
    public static final String SORT_DESC = "desc";
    public static final String WILDCARD = "%";
    public static final String INNER_JOIN = "inner join";
    public static final String LEFT_OUTER_JOIN = "left outer join";
    public static final String OPERATOR_UPPER = "UPPER";
    private Vector<Object> values = new Vector();
    private StringBuffer sql = null;

    public HibernateQueryHelper() {
        this.sql = new StringBuffer();
    }

    public HibernateQueryHelper(String sql) {
        this.sql = new StringBuffer(sql);
    }

    public HibernateQueryHelper append(String sql) {
        this.sql.append(sql);
        return this;
    }

    public HibernateQueryHelper pad() {
        this.sql.append(" ");
        return this;
    }

    public HibernateQueryHelper dot() {
        this.sql.append(".");
        return this;
    }

    public HibernateQueryHelper openParen() {
        this.sql.append("(");
        return this;
    }

    public HibernateQueryHelper closeParen() {
        this.sql.append(")");
        return this;
    }

    public HibernateQueryHelper param() {
        this.sql.append("?");
        return this;
    }

    public HibernateQueryHelper comma() {
        this.sql.append(",");
        return this;
    }

    public HibernateQueryHelper SELECT() {
        this.sql.append(CLAUSE_SELECT);
        return this;
    }

    public HibernateQueryHelper DISTINCT() {
        this.sql.append(OPERATOR_DISTINCT);
        return this;
    }

    public HibernateQueryHelper FROM() {
        this.sql.append(CLAUSE_FROM);
        return this;
    }

    public HibernateQueryHelper AND() {
        this.sql.append(OPERATOR_AND);
        return this;
    }

    public HibernateQueryHelper OR() {
        this.sql.append(OPERATOR_OR);
        return this;
    }

    public HibernateQueryHelper UPPER() {
        this.sql.append(OPERATOR_UPPER);
        return this;
    }

    public HibernateQueryHelper WHERE() {
        this.sql.append(CLAUSE_WHERE);
        return this;
    }

    public HibernateQueryHelper IN() {
        this.sql.append(PREDICATE_IN);
        return this;
    }

    public HibernateQueryHelper GROUPBY() {
        this.sql.append(CLAUSE_GROUPBY);
        return this;
    }

    public HibernateQueryHelper ORDERBY() {
        this.sql.append(CLAUSE_ORDERBY);
        return this;
    }

    public HibernateQueryHelper HAVING() {
        this.sql.append(CLAUSE_HAVING);
        return this;
    }

    public HibernateQueryHelper INNER_JOIN() {
        this.sql.append(INNER_JOIN);
        return this;
    }

    public HibernateQueryHelper LEFT_OUTER_JOIN() {
        this.sql.append(LEFT_OUTER_JOIN);
        return this;
    }

    public HibernateQueryHelper appendGroupedAnd(Parameter ... params) {
        return this.appendCondition(OPERATOR_AND, params);
    }

    public HibernateQueryHelper appendGroupedOr(Parameter ... params) {
        return this.appendCondition(OPERATOR_OR, params);
    }

    public HibernateQueryHelper appendCondition(String operator, Parameter ... params) {
        if (params == null || operator == null) {
            return this;
        }
        this.openParen();
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            this.append(params[i].getName()).pad().append(params[i].getPredicate()).pad().param();
            this.addValue(params[i].getValue());
            if (i + 1 >= params.length) continue;
            this.pad().append(operator).pad();
        }
        this.closeParen().pad();
        return this;
    }

    public HibernateQueryHelper appendSearchCriteriaInQuery(String[] criterii, String[] properties, String clazzAlias, String predicate, boolean caseSensitive) {
        this.WHERE().pad();
        for (int i = 0; i < criterii.length; ++i) {
            this.openParen();
            List<Parameter> parameters = this.createSearchParameters(properties, criterii[i], clazzAlias, predicate, caseSensitive);
            this.appendGroupedOr(parameters.toArray(new Parameter[0]));
            this.closeParen();
            if (i + 1 >= criterii.length) continue;
            this.pad().AND().pad();
        }
        this.pad();
        return this;
    }

    private List<Parameter> createSearchParameters(String[] properties, String criteria, String clazzAlias, String predicate, boolean caseSensitive) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (String p : properties) {
            Parameter parameter = new Parameter(this.createSearchedProperty(clazzAlias, p, caseSensitive), this.createSearchedValue(criteria, caseSensitive, predicate), predicate);
            parameters.add(parameter);
        }
        return parameters;
    }

    private String createSearchedValue(String criteria, boolean caseSensitive, String predicate) {
        String value = PREDICATE_EQUALS.equals(predicate) ? (caseSensitive ? criteria : criteria.toUpperCase()) : WILDCARD + (caseSensitive ? criteria : criteria.toUpperCase()) + WILDCARD;
        return value;
    }

    public String createSearchedProperty(String clazzAlias, String p, boolean caseSensitive) {
        StringBuffer property = new StringBuffer("");
        if (!caseSensitive) {
            property.append(OPERATOR_UPPER).append("(");
        }
        if (!p.contains(".")) {
            property.append(clazzAlias).append(".").append(p);
        } else {
            String[] pSplit = p.split("\\.");
            int length = pSplit.length;
            property.append(pSplit[length - 2]).append(".").append(pSplit[length - 1]);
        }
        if (!caseSensitive) {
            property.append(") ");
        }
        return property.toString();
    }

    public HibernateQueryHelper appendInnerJoinStatement(String parentAlias, String fieldName, String joinedAlias) {
        if (parentAlias == null || fieldName == null || joinedAlias == null) {
            return this;
        }
        this.INNER_JOIN().pad().append(parentAlias).dot().append(fieldName).pad().append(joinedAlias).pad();
        return this;
    }

    public HibernateQueryHelper appendLeftOuterJoinStatement(String parentAlias, String fieldName, String joinedAlias) {
        if (parentAlias == null || fieldName == null || joinedAlias == null) {
            return this;
        }
        this.LEFT_OUTER_JOIN().pad().append(parentAlias).dot().append(fieldName).pad().append(joinedAlias).pad();
        return this;
    }

    public HibernateQueryHelper appendMultipleInnerJoinStatement(String parentAlias, String ... properties) {
        if (properties == null || properties.length == 0) {
            return this;
        }
        for (String property : properties) {
            if (!property.contains(".")) continue;
            String[] propSplit = property.split("\\.");
            String fieldName = propSplit[0];
            this.appendInnerJoinStatement(parentAlias, fieldName, fieldName);
            for (int i = 1; i < propSplit.length - 1; ++i) {
                this.appendInnerJoinStatement(propSplit[i - 1], propSplit[i], propSplit[i]);
            }
        }
        return this;
    }

    public HibernateQueryHelper appendMultipleLeftOuterJoinStatement(String parentAlias, String ... properties) {
        if (properties == null || properties.length == 0) {
            return this;
        }
        for (String property : properties) {
            if (!property.contains(".")) continue;
            String[] propSplit = property.split("\\.");
            String fieldName = propSplit[0];
            this.appendLeftOuterJoinStatement(parentAlias, fieldName, fieldName);
            for (int i = 1; i < propSplit.length - 1; ++i) {
                this.appendLeftOuterJoinStatement(propSplit[i - 1], propSplit[i], propSplit[i]);
            }
        }
        return this;
    }

    public HibernateQueryHelper appendSelectDistinctStatement(String simpleClazzName, String fullClazzName) {
        this.SELECT().pad().DISTINCT().pad().append(simpleClazzName.toLowerCase()).pad().FROM().pad().append(fullClazzName).pad().append(simpleClazzName.toLowerCase()).pad();
        return this;
    }

    public HibernateQueryHelper appendSelectStatement(String simpleClazzName, String fullClazzName) {
        this.SELECT().pad().append(simpleClazzName.toLowerCase()).pad().FROM().pad().append(fullClazzName).pad().append(simpleClazzName.toLowerCase()).pad();
        return this;
    }

    public HibernateQueryHelper appendSortOption(RequestOptions requestOptions, String clazzAlias) {
        if (requestOptions != null && requestOptions.hasSortOption()) {
            this.ORDERBY().pad().append(clazzAlias).dot().append(requestOptions.getSortCriteria()).pad();
            if (requestOptions.isSortAscendingly()) {
                this.append(SORT_ASC).pad();
            } else {
                this.append(SORT_DESC).pad();
            }
        }
        return this;
    }

    public HibernateQueryHelper appendInListWithAnd(String term, List<?> list) {
        if (list == null || list.size() == 0) {
            return this;
        }
        this.AND().pad();
        return this.appendInList(term, list);
    }

    public HibernateQueryHelper appendInList(String term, List<?> list) {
        if (list == null || list.size() == 0) {
            return this;
        }
        this.append(term).pad().IN().pad().openParen().pad();
        int count = 0;
        for (Object item : list) {
            this.param();
            this.addValue(item);
            if (count + 1 < list.size()) {
                this.comma().pad();
            }
            ++count;
        }
        this.closeParen().pad();
        return this;
    }

    public void addValue(Object obj) {
        this.values.addElement(obj);
    }

    public Query buildHibernateQuery(Session session) {
        Query qry = session.createQuery(this.sql.toString());
        for (int i = 0; i < this.values.size(); ++i) {
            qry.setParameter(i, this.values.elementAt(i));
        }
        return qry;
    }

    public Query buildHibernatePaginatedQuery(Session session, RequestOptions requestOptions) {
        Query query = this.buildHibernateQuery(session);
        if (requestOptions != null && requestOptions.hasPagination()) {
            query.setFirstResult(requestOptions.getFirstResult());
            query.setMaxResults(requestOptions.getNbOfResults());
        }
        return query;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.sql.toString());
        buffer.append("\n\n");
        for (int i = 0; i < this.values.size(); ++i) {
            Object obj = this.values.elementAt(i);
            buffer.append(i + 1);
            buffer.append("\t");
            buffer.append(obj.getClass().getName());
            buffer.append("\t");
            buffer.append(obj.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static List sortAndPaginateByCriteria(HibernateTemplate template, RequestOptions requestOptions, DetachedCriteria detachedCriteria) {
        List result;
        if (requestOptions != null) {
            if (requestOptions.hasSortOption()) {
                if (requestOptions.isSortAscendingly()) {
                    detachedCriteria.addOrder(Order.asc((String)requestOptions.getSortCriteria()));
                } else {
                    detachedCriteria.addOrder(Order.desc((String)requestOptions.getSortCriteria()));
                }
            }
            result = requestOptions.hasPagination() ? template.findByCriteria(detachedCriteria, requestOptions.getFirstResult(), requestOptions.getNbOfResults()) : template.findByCriteria(detachedCriteria);
        } else {
            result = template.findByCriteria(detachedCriteria);
        }
        return result;
    }

    public static ISearch createSearchContext(Class<?> clazz, String[] criterii, String[] properties, RequestOptions requestOptions, String predicate) {
        Search search = new Search();
        search.setSearchClass(clazz);
        search.setDistinct(true);
        if (criterii != null && properties != null && criterii.length > 0 && properties.length > 0) {
            for (String criteria : criterii) {
                Filter filter = Filter.or((Filter[])new Filter[0]);
                for (String property : properties) {
                    if (PREDICATE_EQUALS.equalsIgnoreCase(predicate)) {
                        if (requestOptions != null && requestOptions.isCaseSensitive()) {
                            filter.add(Filter.equal((String)property, (Object)criteria));
                            continue;
                        }
                        filter.add(Filter.iequal((String)property, (Object)criteria));
                        continue;
                    }
                    if (!PREDICATE_LIKE.equalsIgnoreCase(predicate)) continue;
                    if (requestOptions != null && requestOptions.isCaseSensitive()) {
                        filter.add(Filter.like((String)property, (String)(WILDCARD + criteria + WILDCARD)));
                        continue;
                    }
                    filter.add(Filter.ilike((String)property, (String)(WILDCARD + criteria + WILDCARD)));
                }
                search.addFilterAnd(new Filter[]{filter});
            }
        }
        if (requestOptions != null) {
            if (requestOptions.hasPagination()) {
                search.setFirstResult(requestOptions.getFirstResult());
                search.setMaxResults(requestOptions.getNbOfResults());
            }
            if (requestOptions.hasSortOption()) {
                Sort sort = new Sort();
                sort.setProperty(requestOptions.getSortCriteria());
                if (requestOptions.isSortAscendingly()) {
                    sort.setDesc(false);
                } else {
                    sort.setDesc(true);
                }
                search.addSort(sort);
            }
            if (requestOptions.hasFetchOption()) {
                search.addFetch(requestOptions.getFetchCriteria());
            }
        }
        return search;
    }

    public static class Parameter {
        private String name;
        private Object value;
        private String predicate;

        public Parameter(String name, Object value, String predicate) {
            this.name = name;
            this.value = value;
            this.predicate = predicate;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getPredicate() {
            return this.predicate;
        }

        public void setPredicate(String predicate) {
            this.predicate = predicate;
        }
    }
}

