/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.BindingOperationTO;
import org.ow2.dragon.api.to.deployment.BindingTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.ProtocolTO;
import org.ow2.dragon.api.to.deployment.RatingTO;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.deployment.TransportTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.api.to.specification.ServiceInterfaceTO;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.ow2.dragon.api.to.specification.SpecifiedOperationTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Comment;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.Rating;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.Standard;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.DiscoveryUrl;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.PhoneNumber;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment;
import org.ow2.dragon.persistence.bo.technology.Node;
import org.ow2.dragon.persistence.bo.technology.Processor;
import org.ow2.dragon.persistence.dao.RequestOptions;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransfertObjectAssemblerImpl
implements TransfertObjectAssembler {
    private OrganizationUnitDAO organizationUnitDAO;
    private PostDAO postDAO;
    public static final String STREET_NUMBER_KEY = "streetNumber";
    public static final String COMPLEMENT_KEY = "complement";
    public static final String STREET_KEY = "street";
    public static final String COUNTRY_KEY = "country";
    public static final String STATE_KEY = "state";
    public static final String ZIPCODE_KEY = "zipcode";
    public static final String CITY_KEY = "city";

    public void setOrganizationUnitDAO(OrganizationUnitDAO organizationUnitDAO) {
        this.organizationUnitDAO = organizationUnitDAO;
    }

    public void setPostDAO(PostDAO postDAO) {
        this.postDAO = postDAO;
    }

    @Override
    public ServiceSpecificationTO toServiceSpecTO(ServiceSpecification serviceSpecification) {
        ServiceSpecificationTO serviceSpecificationTO = null;
        if (serviceSpecification != null) {
            serviceSpecificationTO = new ServiceSpecificationTO();
            serviceSpecificationTO.setId(serviceSpecification.getId());
            serviceSpecificationTO.setName(serviceSpecification.getName().getName());
            serviceSpecificationTO.setFileName(serviceSpecification.getOverviewDocs().get(0).getFileName());
        }
        return serviceSpecificationTO;
    }

    public BindingOperationTO toBindingOpTO(BindingOperation bindingOperation) {
        BindingOperationTO bindingOperationTO = null;
        if (bindingOperation != null) {
            bindingOperationTO = new BindingOperationTO();
            bindingOperationTO.setId(bindingOperation.getId());
            bindingOperationTO.setSignature(bindingOperation.getSignature());
            bindingOperationTO.setStyle(bindingOperation.getStyle().toString());
            bindingOperationTO.setPattern(bindingOperation.getSpecifiedOp().getTransmission().toString());
        }
        return bindingOperationTO;
    }

    @Override
    public BindingTO toBindingTO(Binding binding) {
        BindingTO bindingTO = null;
        if (binding != null) {
            Set<Transport> transports;
            bindingTO = new BindingTO();
            bindingTO.setId(binding.getId());
            bindingTO.setName(binding.getFullName());
            Set<Protocol> protocols = binding.getProtocols();
            if (protocols != null) {
                HashSet<ProtocolTO> protocolTOs = new HashSet<ProtocolTO>();
                for (Protocol protocol : protocols) {
                    protocolTOs.add(this.toProtocolTO(protocol));
                }
                bindingTO.setProtocols(protocolTOs);
            }
            if ((transports = binding.getTransports()) != null) {
                HashSet<TransportTO> transportTOs = new HashSet<TransportTO>();
                for (Transport transport : transports) {
                    transportTOs.add(this.toTransportTO(transport));
                }
                bindingTO.setTransports(transportTOs);
            }
            bindingTO.setServiceInterface(this.toServiceInterfaceTO(binding.getServiceInterface()));
            Set<BindingOperation> bindingOperations = binding.getBindingOps();
            if (bindingOperations != null) {
                ArrayList<BindingOperationTO> bindingOperationsTO = new ArrayList<BindingOperationTO>();
                for (BindingOperation bindingOperation : bindingOperations) {
                    bindingOperationsTO.add(this.toBindingOpTO(bindingOperation));
                }
                bindingTO.setBindingOps(bindingOperationsTO);
            }
        }
        return bindingTO;
    }

    @Override
    public EndpointTO toEndpointTO(Endpoint endpoint, String user) {
        EndpointTO endpointTO = null;
        if (endpoint != null) {
            Node hostNode;
            endpointTO = new EndpointTO();
            endpointTO.setBinding(this.toBindingTO(endpoint.getBinding()));
            endpointTO.setId(endpoint.getId());
            endpointTO.setName(endpoint.getName());
            endpointTO.setNetworkAddress(endpoint.getNetworkAddress());
            if (endpoint.getBinding() != null) {
                Set<Transport> transports;
                Set<Protocol> protocols = endpoint.getBinding().getProtocols();
                if (protocols != null) {
                    HashSet<ProtocolTO> protocolTOs = new HashSet<ProtocolTO>();
                    for (Protocol protocol : protocols) {
                        protocolTOs.add(this.toProtocolTO(protocol));
                    }
                    endpointTO.setProtocols(protocolTOs);
                }
                if ((transports = endpoint.getBinding().getTransports()) != null) {
                    HashSet<TransportTO> transportTOs = new HashSet<TransportTO>();
                    for (Transport transport : transports) {
                        transportTOs.add(this.toTransportTO(transport));
                    }
                    endpointTO.setTransports(transportTOs);
                }
            }
            if ((hostNode = endpoint.getHostNode()) != null) {
                if (hostNode instanceof Processor) {
                    endpointTO.setHostProcessorId(hostNode.getId());
                } else {
                    ExecutionEnvironment execEnv = (ExecutionEnvironment)hostNode;
                    endpointTO.setHostExecEnvId(execEnv.getId());
                    if (execEnv.getHostProcessor() != null) {
                        endpointTO.setHostProcessorId(execEnv.getHostProcessor().getId());
                    }
                }
            }
            endpointTO.setTechService(this.toTechServiceTO(endpoint.getTechnicalService(), null));
            if (user != null) {
                Set<Rating> ratings = endpoint.getRatings();
                Rating userRating = null;
                float globalRating = 0.0f;
                for (Rating ratingTemp : ratings) {
                    globalRating += (float)ratingTemp.getMyRating();
                    if (ratingTemp.getUserName().compareTo(user) != 0) continue;
                    userRating = ratingTemp;
                }
                if (userRating == null) {
                    userRating = new Rating(user);
                }
                if (ratings.size() != 0) {
                    endpointTO.setGlobalRating(globalRating / (float)ratings.size());
                } else {
                    endpointTO.setGlobalRating(0.0f);
                }
                endpointTO.setRatingTO(this.toRatingTO(userRating));
            }
            endpointTO.setCategories(this.toCategoriesTO(endpoint.getCategoryBag()));
            endpointTO.setComments(this.toCommentsTO(endpoint.getComments()));
            endpointTO.setTags(new HashSet<String>(endpoint.getTags()));
        }
        return endpointTO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void toOrganizationUnitBO(OrganizationUnitTO organizationUnitTO, OrganizationUnit organizationUnitBO) throws OrganizationException {
        this.setAddresses(organizationUnitTO, organizationUnitBO);
        if (organizationUnitTO.getDiscoveryURL() != null) {
            organizationUnitBO.getDiscoveryUrls().clear();
            DiscoveryUrl discoveryUrl = new DiscoveryUrl();
            discoveryUrl.setUrl(organizationUnitTO.getDiscoveryURL());
            discoveryUrl.setUseType("homepage");
            organizationUnitBO.addDiscoveryUrl(discoveryUrl);
        }
        organizationUnitBO.setId(organizationUnitTO.getId());
        organizationUnitBO.setLegalEntity(organizationUnitTO.getIsLegalEntity());
        if (organizationUnitTO.getMotherOrganization() != null && organizationUnitTO.getMotherOrganization().getId() != null) {
            OrganizationUnit motherOrganization = (OrganizationUnit)this.organizationUnitDAO.get(organizationUnitTO.getMotherOrganization().getId());
            if (motherOrganization == null) throw new OrganizationException("Your are trying to connect an organization to an other non existing organization");
            organizationUnitBO.setParentOrganization(motherOrganization);
        } else {
            organizationUnitBO.setParentOrganization(null);
        }
        if (organizationUnitTO.getEmailAddress() != null) {
            organizationUnitBO.getEmailAddresses().clear();
            Email email = new Email();
            email.setEmail(organizationUnitTO.getEmailAddress());
            organizationUnitBO.addEmail(email);
        }
        organizationUnitBO.getNames().clear();
        Name name = new Name();
        name.setLangCode("en");
        name.setName(organizationUnitTO.getName());
        organizationUnitBO.addName(name);
        organizationUnitBO.setType(organizationUnitTO.getType());
    }

    private void setAddresses(OrganizationUnitTO organizationUnitTO, OrganizationUnit organizationUnitBO) {
        organizationUnitBO.getAddresses().clear();
        Address address = new Address();
        this.addAddressLine(address, STREET_NUMBER_KEY, null, organizationUnitTO.getStreetNumber());
        this.addAddressLine(address, STREET_KEY, null, organizationUnitTO.getStreet());
        this.addAddressLine(address, COMPLEMENT_KEY, null, organizationUnitTO.getComplement());
        this.addAddressLine(address, COUNTRY_KEY, null, organizationUnitTO.getCountry());
        this.addAddressLine(address, STATE_KEY, null, organizationUnitTO.getState());
        this.addAddressLine(address, ZIPCODE_KEY, null, organizationUnitTO.getZipcode());
        this.addAddressLine(address, CITY_KEY, null, organizationUnitTO.getCity());
        organizationUnitBO.addAddress(address);
    }

    private void addAddressLine(Address address, String keyName, String keyValue, String line) {
        AddressLine addressLine = new AddressLine();
        addressLine.setAddressLine(line);
        addressLine.setKeyName(keyName);
        addressLine.setKeyValue(keyValue);
        address.addAddressLine(addressLine);
    }

    @Override
    public OrganizationUnitTO toOrganizationUnitTO(OrganizationUnit organizationUnitBO) {
        OrganizationUnitTO organizationUnitTO = null;
        if (organizationUnitBO != null) {
            organizationUnitTO = new OrganizationUnitTO();
            List<DiscoveryUrl> discoveryUrls = organizationUnitBO.getDiscoveryUrls();
            if (discoveryUrls != null && !discoveryUrls.isEmpty()) {
                for (DiscoveryUrl discoveryUrl : discoveryUrls) {
                    if (!"homepage".equals(discoveryUrl.getUseType())) continue;
                    organizationUnitTO.setDiscoveryURL(discoveryUrl.getUrl());
                    break;
                }
            }
            organizationUnitTO.setId(organizationUnitBO.getId());
            organizationUnitTO.setIsLegalEntity(organizationUnitBO.isLegalEntity());
            organizationUnitTO.setMotherOrganization(this.toOrganizationUnitTO(organizationUnitBO.getParentOrganization()));
            organizationUnitTO.setCategories(this.toCategoriesTO(organizationUnitBO.getCategoryBag()));
            organizationUnitTO.setIdentifiers(this.toIdentifiersTO(organizationUnitBO.getIdentifierBag()));
            organizationUnitTO.setName(organizationUnitBO.getNames().get(0).getName());
            List<Email> emailAddresses = organizationUnitBO.getEmailAddresses();
            if (emailAddresses != null && !emailAddresses.isEmpty()) {
                organizationUnitTO.setEmailAddress(emailAddresses.get(0).getEmail());
            }
            organizationUnitTO.setType(organizationUnitBO.getType());
            this.setAddressesTO(organizationUnitTO, organizationUnitBO);
        }
        return organizationUnitTO;
    }

    private void setAddressesTO(OrganizationUnitTO organizationUnitTO, OrganizationUnit organizationUnitBO) {
        Address address = organizationUnitBO.getAddresses().get(0);
        List<AddressLine> addressLines = address.getAddressLines();
        for (AddressLine addressLine : addressLines) {
            if (STREET_NUMBER_KEY.equals(addressLine.getKeyName())) {
                organizationUnitTO.setStreetNumber(addressLine.getAddressLine());
                continue;
            }
            if (STREET_KEY.equals(addressLine.getKeyName())) {
                organizationUnitTO.setStreet(addressLine.getAddressLine());
                continue;
            }
            if (COUNTRY_KEY.equals(addressLine.getKeyName())) {
                organizationUnitTO.setCountry(addressLine.getAddressLine());
                continue;
            }
            if (STATE_KEY.equals(addressLine.getKeyName())) {
                organizationUnitTO.setState(addressLine.getAddressLine());
                continue;
            }
            if (ZIPCODE_KEY.equals(addressLine.getKeyName())) {
                organizationUnitTO.setZipcode(addressLine.getAddressLine());
                continue;
            }
            if (CITY_KEY.equals(addressLine.getKeyName())) {
                organizationUnitTO.setCity(addressLine.getAddressLine());
                continue;
            }
            if (!COMPLEMENT_KEY.equals(addressLine.getKeyName())) continue;
            organizationUnitTO.setComplement(addressLine.getAddressLine());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void toPersonBO(PersonTO personTO, Person personBO) throws OrganizationException {
        personBO.getEmailAddresses().clear();
        Email email = new Email();
        email.setEmail(personTO.getEmail());
        personBO.addEmail(email);
        personBO.setContact(personTO.isContact());
        personBO.setFirstName(personTO.getFirstname());
        personBO.setLastName(personTO.getLastname());
        personBO.setLocation(personTO.getLocalization());
        personBO.setMiddleName(personTO.getMiddlename());
        personBO.getNames().clear();
        Name name = new Name();
        name.setLangCode("en");
        name.setName(personTO.getFirstname() + " " + personTO.getMiddlename() + " " + personTO.getLastname());
        personBO.addName(name);
        if (personTO.getOrganization() != null && personTO.getOrganization().getId() != null) {
            OrganizationUnit motherOrganization = (OrganizationUnit)this.organizationUnitDAO.get(personTO.getOrganization().getId());
            if (motherOrganization == null) throw new OrganizationException("Your are trying to connect a person to a non existing organization");
            personBO.setParentOrganization(motherOrganization);
        } else {
            personBO.setParentOrganization(null);
        }
        personBO.setId(personTO.getId());
        personBO.getPhoneNumbers().clear();
        PhoneNumber phoneNumber = new PhoneNumber();
        phoneNumber.setPhoneNumber(personTO.getPhone());
        personBO.addPhoneNumber(phoneNumber);
        if (personTO.getPost() != null) {
            Post post = (Post)this.postDAO.get(personTO.getPost().getId());
            if (post == null) throw new OrganizationException("Your are trying to connect a person to a non existing post");
            personBO.setPost(post);
        }
        personBO.setTitle(personTO.getTitle());
    }

    @Override
    public PersonTO toPersonTO(Person person) {
        PersonTO personTO = null;
        if (person != null) {
            Post post;
            personTO = new PersonTO();
            List<Email> emailAddresses = person.getEmailAddresses();
            if (emailAddresses != null && !emailAddresses.isEmpty()) {
                personTO.setEmail(emailAddresses.get(0).getEmail());
            }
            personTO.setContact(person.isContact());
            personTO.setFirstname(person.getFirstName());
            personTO.setId(person.getId());
            personTO.setLastname(person.getLastName());
            personTO.setLocalization(person.getLocation());
            personTO.setMiddlename(person.getMiddleName());
            personTO.setOrganization(this.toOrganizationUnitTO(person.getParentOrganization()));
            List<PhoneNumber> phoneNumbers = person.getPhoneNumbers();
            if (phoneNumbers != null && !phoneNumbers.isEmpty()) {
                personTO.setPhone(phoneNumbers.get(0).getPhoneNumber());
            }
            if ((post = person.getPost()) != null) {
                personTO.setPost(this.toPostTO(post));
            }
            personTO.setTitle(person.getTitle());
        }
        return personTO;
    }

    @Override
    public void toPostBO(PostTO postTO, Post postBO) throws OrganizationException {
        postBO.setDescription(postTO.getDescription());
        postBO.setName(postTO.getName());
        postBO.setNature(postTO.getNature());
        postBO.setId(postTO.getId());
        postBO.setContact(postTO.isContact());
    }

    @Override
    public PostTO toPostTO(Post post) {
        PostTO postTO = null;
        if (post != null) {
            postTO = new PostTO();
            postTO.setDescription(post.getDescription());
            postTO.setId(post.getId());
            postTO.setName(post.getName());
            postTO.setNature(post.getNature());
            postTO.setContact(post.isContact());
        }
        return postTO;
    }

    public ProtocolTO toProtocolTO(Set<Standard> standards) {
        ProtocolTO protocolTO = new ProtocolTO();
        if (standards != null) {
            for (Standard standard : standards) {
            }
        }
        return protocolTO;
    }

    @Override
    public RequestOptions toPartyRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.PARTY_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("names.name");
            requestOptions.setFetchCriteria("names");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toPersonRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null) {
            if (SortCriteria.PARTY_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
                requestOptions.setSortCriteria("names.name");
                requestOptions.setFetchCriteria("names");
            } else if (SortCriteria.PERSON_LASTNAME.equals((Object)requestOptionsTO.getSortCriteria())) {
                requestOptions.setSortCriteria("lastName");
            }
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toPostRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.POST_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("name");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toEndpointRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.ENDPOINT_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("name");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toServiceRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.SERVICE_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("fullName");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toAgreementRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.AGREEMENT_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("name");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toExecEnvManRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.EXEC_ENV_MAN_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("name");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toExecEnvRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.EXEC_ENV_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("name");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toFederationRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.FED_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("name");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toProcessorRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.PROCESSOR_NAME.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("name");
        }
        return requestOptions;
    }

    @Override
    public RequestOptions toLinkRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.toRequestOptions(requestOptionsTO);
        if (requestOptions != null && SortCriteria.LINK_TYPE.equals((Object)requestOptionsTO.getSortCriteria())) {
            requestOptions.setSortCriteria("type");
        }
        return requestOptions;
    }

    private RequestOptions toRequestOptions(RequestOptionsTO requestOptionsTO) {
        RequestOptions result = null;
        if (requestOptionsTO != null) {
            result = new RequestOptions();
            result.setFirstResult(requestOptionsTO.getFirstResult());
            result.setNbOfResults(requestOptionsTO.getNbOfResults());
            result.setSortAscendingly(requestOptionsTO.isSortAscendingly());
            result.setCaseSensitive(requestOptionsTO.isCaseSensitive());
        }
        return result;
    }

    @Override
    public ServiceInterfaceTO toServiceInterfaceTO(ServiceInterface serviceInterface) {
        ServiceInterfaceTO serviceInterfaceTO = null;
        if (serviceInterface != null) {
            serviceInterfaceTO = new ServiceInterfaceTO();
            serviceInterfaceTO.setId(serviceInterface.getId());
            serviceInterfaceTO.setName(serviceInterface.getFullName());
            Set<SpecifiedOperation> specifiedOperations = serviceInterface.getSpecifiedOps();
            if (specifiedOperations != null) {
                ArrayList<SpecifiedOperationTO> specifiedOperationsTO = new ArrayList<SpecifiedOperationTO>();
                for (SpecifiedOperation specifiedOperation : specifiedOperations) {
                    specifiedOperationsTO.add(this.toSpecifiedOperationTO(specifiedOperation));
                }
                serviceInterfaceTO.setSpecifiedOps(specifiedOperationsTO);
            }
        }
        return serviceInterfaceTO;
    }

    public SpecifiedOperationTO toSpecifiedOperationTO(SpecifiedOperation specifiedOperation) {
        SpecifiedOperationTO specifiedOperationTO = null;
        if (specifiedOperation != null) {
            specifiedOperationTO = new SpecifiedOperationTO();
            specifiedOperationTO.setId(specifiedOperation.getId());
            specifiedOperationTO.setIsAtomicTransaction(specifiedOperation.isAtomicTransaction());
            specifiedOperationTO.setIsCanParticipateInTransaction(specifiedOperation.isCanParticipateInTransaction());
            specifiedOperationTO.setIsNoneUpdating(specifiedOperation.isNonUpdating());
            specifiedOperationTO.setIsTransactionCoordNeeded(specifiedOperation.isTransactionCoordNeeded());
            specifiedOperationTO.setName(specifiedOperation.getName());
            specifiedOperationTO.setPurpose(specifiedOperation.getPurpose());
            specifiedOperationTO.setTransactionCoordIsBy(specifiedOperation.getTransactionCoordIsBy());
            specifiedOperationTO.setTransmission(specifiedOperation.getTransmission().toString());
        }
        return specifiedOperationTO;
    }

    @Override
    public void toTechServiceBO(TechnicalServiceTO technicalServiceTO, TechnicalService technicalServiceBO) {
        this.setName(technicalServiceBO, technicalServiceTO.getName());
        this.setPurpose(technicalServiceBO, technicalServiceTO.getPurpose());
        this.setRating(technicalServiceBO, technicalServiceTO.getRatingTO());
        this.setComments(technicalServiceBO, technicalServiceTO.getComments());
        technicalServiceBO.setTags(technicalServiceTO.getTags());
    }

    private void setComments(TechnicalService technicalServiceBO, List<CommentTO> comments) {
        ArrayList<Comment> commentsBO = new ArrayList<Comment>();
        this.toCommentsBO(comments, commentsBO);
        technicalServiceBO.setComments(commentsBO);
    }

    private void setRating(TechnicalService technicalServiceBO, RatingTO rating) {
        Iterator<Rating> iter = technicalServiceBO.getRatings().iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            Rating ratingTemp = iter.next();
            if (ratingTemp.getUserName().compareTo(rating.getUserName()) != 0) continue;
            ratingTemp.setMyRating(rating.getMyRating());
            found = true;
        }
        if (!found && rating.getMyRating() > 0) {
            Rating ratingBO = new Rating(rating.getUserName(), rating.getMyRating());
            technicalServiceBO.getRatings().add(ratingBO);
        }
    }

    private void setPurpose(TechnicalService technicalServiceBO, String purpose) {
        technicalServiceBO.getDescriptions().clear();
        Description description = new Description();
        description.setLangCode("en");
        description.setDescription(purpose);
        technicalServiceBO.addDescription(description);
    }

    private void setName(TechnicalService technicalServiceBO, String name) {
        technicalServiceBO.setFullName(name);
        technicalServiceBO.getNames().clear();
        QName servQname = QName.valueOf(name);
        Name nameObj = new Name();
        nameObj.setLangCode("en");
        nameObj.setName(servQname.getLocalPart());
        technicalServiceBO.addName(nameObj);
        this.setServiceCategory(technicalServiceBO, "service local name", servQname.getLocalPart());
        this.setServiceCategory(technicalServiceBO, "service namespace", servQname.getNamespaceURI());
    }

    private void setServiceCategory(TechnicalService service, String categoryName, String categoryValue) {
        CategoryBag bag = service.getCategoryBag();
        if (bag == null) {
            bag = new CategoryBag();
            service.setCategoryBag(bag);
        }
        List<KeyedReference> keyedReferences = bag.getKeyedReferences();
        boolean serviceCategoryExist = false;
        if (keyedReferences != null) {
            for (KeyedReference keyedReference : keyedReferences) {
                if (!categoryName.equals(keyedReference.getKeyName())) continue;
                keyedReference.setKeyValue(categoryValue);
                serviceCategoryExist = true;
                break;
            }
        }
        if (!serviceCategoryExist) {
            this.addKeyedReference(bag, categoryName, categoryValue, null);
        }
    }

    private void addKeyedReference(CategoryBag bag, String name, String value, TModel tModel) {
        KeyedReference keyedReference = new KeyedReference();
        keyedReference.setKeyName(name);
        keyedReference.setKeyValue(value);
        keyedReference.setTmodel(tModel);
        bag.addKeyedReference(keyedReference);
    }

    @Override
    public TechnicalServiceTO toTechServiceTO(TechnicalService technicalService, String user) {
        TechnicalServiceTO technicalServiceTO = null;
        if (technicalService != null) {
            technicalServiceTO = new TechnicalServiceTO();
            technicalServiceTO.setId(technicalService.getId());
            technicalServiceTO.setName(technicalService.getFullName());
            List<Description> descriptions = technicalService.getDescriptions();
            if (descriptions != null && !descriptions.isEmpty()) {
                technicalServiceTO.setPurpose(descriptions.get(0).getDescription());
            }
            if (user != null) {
                Set<Rating> ratings = technicalService.getRatings();
                Rating userRating = null;
                float globalRating = 0.0f;
                for (Rating ratingTemp : ratings) {
                    globalRating += (float)ratingTemp.getMyRating();
                    if (ratingTemp.getUserName().compareTo(user) != 0) continue;
                    userRating = ratingTemp;
                }
                if (userRating == null) {
                    userRating = new Rating(user);
                }
                if (ratings.size() != 0) {
                    technicalServiceTO.setGlobalRating(globalRating / (float)ratings.size());
                } else {
                    technicalServiceTO.setGlobalRating(0.0f);
                }
                technicalServiceTO.setRatingTO(this.toRatingTO(userRating));
            }
            technicalServiceTO.setCategories(this.toCategoriesTO(technicalService.getCategoryBag()));
            technicalServiceTO.setComments(this.toCommentsTO(technicalService.getComments()));
            technicalServiceTO.setTags(new HashSet<String>(technicalService.getTags()));
        }
        return technicalServiceTO;
    }

    @Override
    public List<KeyedRefTO> toCategoriesTO(CategoryBag categoryBag) {
        List<KeyedReference> keyedRefs;
        ArrayList<KeyedRefTO> result = new ArrayList<KeyedRefTO>();
        if (categoryBag != null && (keyedRefs = categoryBag.getKeyedReferences()) != null) {
            for (KeyedReference keyedReference : keyedRefs) {
                KeyedRefTO keyedRefTO = new KeyedRefTO();
                if (keyedReference.getTmodel() != null) {
                    keyedRefTO.settModelName(keyedReference.getTmodel().getName().getName());
                } else {
                    keyedRefTO.settModelName("Undefined");
                }
                keyedRefTO.setKefRefId(keyedReference.getId());
                keyedRefTO.setName(keyedReference.getKeyName());
                keyedRefTO.setValue(keyedReference.getKeyValue());
                result.add(keyedRefTO);
            }
        }
        return result;
    }

    @Override
    public List<KeyedRefTO> toIdentifiersTO(List<KeyedReference> identifierBag) {
        ArrayList<KeyedRefTO> result = new ArrayList<KeyedRefTO>();
        if (identifierBag != null) {
            for (KeyedReference keyedReference : identifierBag) {
                KeyedRefTO keyedRefTO = new KeyedRefTO();
                if (keyedReference.getTmodel() != null) {
                    keyedRefTO.settModelName(keyedReference.getTmodel().getName().getName());
                } else {
                    keyedRefTO.settModelName("Undefined");
                }
                keyedRefTO.setKefRefId(keyedReference.getId());
                keyedRefTO.setName(keyedReference.getKeyName());
                keyedRefTO.setValue(keyedReference.getKeyValue());
                result.add(keyedRefTO);
            }
        }
        return result;
    }

    @Override
    public SimpleFileTO toSimpleFileTO(SimpleFile simpleFile) {
        SimpleFileTO simpleFileTO = null;
        if (simpleFile != null) {
            simpleFileTO = new SimpleFileTO();
            simpleFileTO.setAuthor(simpleFile.getAuthor());
            if (simpleFile.getFileType() != null) {
                simpleFileTO.setFileType(simpleFile.getFileType().toString());
            }
            simpleFileTO.setId(simpleFile.getId());
            simpleFileTO.setTitle(simpleFile.getTitle());
            simpleFileTO.setFileName(simpleFile.getFileName());
        }
        return simpleFileTO;
    }

    @Override
    public RatingTO toRatingTO(Rating rating) {
        RatingTO ratingTO = null;
        if (rating != null) {
            ratingTO = new RatingTO();
            ratingTO.setId(rating.getId());
            ratingTO.setMyRating(rating.getMyRating());
            ratingTO.setUserName(rating.getUserName());
        }
        return ratingTO;
    }

    @Override
    public void toRatingBO(RatingTO ratingTO, Rating ratingBO) {
        ratingBO.setId(ratingTO.getid());
        ratingBO.setMyRating(ratingTO.getMyRating());
        ratingBO.setUserName(ratingTO.getUserName());
    }

    @Override
    public List<CommentTO> toCommentsTO(List<Comment> comments) {
        ArrayList<CommentTO> commentsTO = null;
        if (comments != null) {
            commentsTO = new ArrayList<CommentTO>();
            for (Comment commentTemp : comments) {
                CommentTO commentTOTemp = new CommentTO();
                commentTOTemp.setContent(commentTemp.getContent());
                commentTOTemp.setId(commentTemp.getId());
                commentTOTemp.setUserName(commentTemp.getUserName());
                commentTOTemp.setDate(commentTemp.getDate());
                commentsTO.add(0, commentTOTemp);
            }
        }
        return commentsTO;
    }

    @Override
    public void toCommentsBO(List<CommentTO> commentsTO, List<Comment> commentsBO) {
        Iterator<CommentTO> iter = commentsTO.iterator();
        commentsBO.clear();
        while (iter.hasNext()) {
            Comment commentTemp = new Comment();
            CommentTO commentTOTemp = iter.next();
            commentTemp.setContent(commentTOTemp.getContent());
            commentTemp.setDate(commentTOTemp.getDate());
            commentTemp.setUserName(commentTOTemp.getUserName());
            commentTemp.setId(commentTOTemp.getId());
            commentsBO.add(commentTemp);
        }
    }

    private void setComments(Endpoint endpointBO, List<CommentTO> comments) {
        ArrayList<Comment> commentsBO = new ArrayList<Comment>();
        this.toCommentsBO(comments, commentsBO);
        endpointBO.setComments(commentsBO);
    }

    private void setRating(Endpoint endpointBO, RatingTO rating) {
        Iterator<Rating> iter = endpointBO.getRatings().iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            Rating ratingTemp = iter.next();
            if (ratingTemp.getUserName().compareTo(rating.getUserName()) != 0) continue;
            ratingTemp.setMyRating(rating.getMyRating());
            found = true;
        }
        if (!found && rating.getMyRating() > 0) {
            Rating ratingBO = new Rating(rating.getUserName(), rating.getMyRating());
            endpointBO.getRatings().add(ratingBO);
        }
    }

    @Override
    public void toEndpointBO(EndpointTO endpointTO, Endpoint endpointBO) {
        this.setComments(endpointBO, endpointTO.getComments());
        this.setRating(endpointBO, endpointTO.getRatingTO());
        endpointBO.setTags(endpointTO.getTags());
    }

    @Override
    public IdentifierTO toIdentifierTO(Identifier identifierBO) {
        IdentifierTO identifierTO = null;
        if (identifierBO != null) {
            identifierTO = new IdentifierTO(identifierBO.getId(), identifierBO.getName().getName(), null);
            List<Description> descriptionsBO = identifierBO.getDescriptions();
            if (descriptionsBO != null && !descriptionsBO.isEmpty()) {
                identifierTO.setDescription(descriptionsBO.get(0).getDescription());
            }
        }
        return identifierTO;
    }

    @Override
    public CategoryTO toCategoryTO(Category categoryBO) {
        CategoryTO categoryTO = null;
        if (categoryBO != null) {
            categoryTO = new CategoryTO(categoryBO.getId(), categoryBO.getName().getName(), null);
            List<Description> descriptionsBO = categoryBO.getDescriptions();
            if (descriptionsBO != null && !descriptionsBO.isEmpty()) {
                categoryTO.setDescription(descriptionsBO.get(0).getDescription());
            }
        }
        return categoryTO;
    }

    @Override
    public List<CategoryValueTO> toCategoryValuesTO(List<CategoryValue> valuesBO) {
        ArrayList<CategoryValueTO> result = new ArrayList<CategoryValueTO>();
        if (valuesBO != null && !valuesBO.isEmpty()) {
            for (CategoryValue categoryValueBO : valuesBO) {
                result.add(this.toCategoryValueTO(categoryValueBO));
            }
        }
        return result;
    }

    private CategoryValueTO toCategoryValueTO(CategoryValue categoryValueBO) {
        CategoryValueTO categoryValueTO = null;
        if (categoryValueBO != null) {
            categoryValueTO = new CategoryValueTO(categoryValueBO.getId(), categoryValueBO.getValue(), categoryValueBO.getDescription());
        }
        return categoryValueTO;
    }

    @Override
    public ProtocolTO toProtocolTO(Protocol protocol) {
        ProtocolTO result = null;
        if (protocol != null) {
            result = new ProtocolTO();
            result.setName(protocol.getName().getName());
            result.setId(protocol.getId());
        }
        return result;
    }

    @Override
    public TransportTO toTransportTO(Transport transport) {
        TransportTO result = null;
        if (transport != null) {
            result = new TransportTO();
            result.setName(transport.getName().getName());
            result.setId(transport.getId());
        }
        return result;
    }
}

