/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PostManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.organization.PostSearchProperties;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.DAOLayerException;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.util.SearchHelper;
import org.ow2.dragon.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostManagerImpl
implements PostManager {
    private TransfertObjectAssembler transfertObjectAssembler;
    private GenericUnifiedDAO<Post, String> postDAO;
    private OrganizationUnitDAO organizationUnitDAO;
    private GenericUnifiedDAO<Person, String> personUnifiedDAO;

    @Override
    @CheckAllArgumentsNotNull
    public String createPost(PostTO postTO) throws OrganizationException {
        this.validatePostBeforeCreation(postTO);
        Post postBO = new Post();
        this.transfertObjectAssembler.toPostBO(postTO, postBO);
        return this.postDAO.save(postBO).getId();
    }

    private void validatePostBeforeCreation(PostTO postTO) throws OrganizationException {
        if (postTO.getName() == null) {
            throw new OrganizationException("Post name must be specified");
        }
        List<Post> posts = this.postDAO.searchEquals(new String[]{postTO.getName()}, new String[]{"name"}, null);
        if (posts != null && !posts.isEmpty()) {
            throw new OrganizationException("A post with the same name already exists");
        }
    }

    private void validatePostBeforeUpdate(PostTO postTO) throws OrganizationException {
        if (StringHelper.isNullOrEmpty((String)postTO.getName())) {
            throw new OrganizationException("You're trying to update a post with a null or empty name");
        }
        List<Post> posts = this.postDAO.searchEquals(new String[]{postTO.getName()}, new String[]{"name"}, null);
        if (posts != null && !posts.isEmpty() && !posts.get(0).getId().equals(postTO.getId())) {
            throw new OrganizationException("A post with the same name already exists");
        }
    }

    @Override
    @CheckArgumentsNotNull
    public List<PostTO> searchPost(String searchCriteria, List<PostSearchProperties> searchedProperties, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        List<Post> posts;
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createSearchProperties(searchedProperties);
        try {
            posts = this.postDAO.searchORMResult(criteria, properties, this.transfertObjectAssembler.toPostRequestOptions(requestOptionsTO));
        }
        catch (DAOLayerException e) {
            throw new OrganizationException("You must specified non empty search criteria and properties.", e);
        }
        this.toPostsTO(result, posts);
        for (PostTO post : result) {
            post.setPostInUse(this.isPostInUse(post.getId()));
        }
        return result;
    }

    private String[] createSearchProperties(List<PostSearchProperties> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains((Object)PostSearchProperties.NAME)) {
                propertiesList.add("name");
            }
            if (searchedProperties.contains((Object)PostSearchProperties.NATURE)) {
                propertiesList.add("nature");
            }
            if (searchedProperties.contains((Object)PostSearchProperties.DESCRIPTION)) {
                propertiesList.add("description");
            }
        } else {
            propertiesList.add("name");
            propertiesList.add("nature");
            propertiesList.add("description");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    public List<PostTO> getAllPosts(RequestOptionsTO requestOptionsTO) {
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        List<Post> posts = this.postDAO.getAll(this.transfertObjectAssembler.toPostRequestOptions(requestOptionsTO));
        this.toPostsTO(result, posts);
        for (PostTO post : result) {
            try {
                post.setPostInUse(this.isPostInUse(post.getId()));
            }
            catch (OrganizationException e) {}
        }
        return result;
    }

    @Override
    @CheckAllArgumentsNotNull
    public PostTO getPost(String postId) throws OrganizationException {
        Post postBO = this.postDAO.get(postId);
        if (postBO == null) {
            throw new OrganizationException("No post found for the given id: " + postId);
        }
        PostTO postTO = this.toPostTO(postBO);
        return postTO;
    }

    @Override
    public List<PostTO> getPostsNotLinkedToOrganization(String orgId, RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        OrganizationUnit org = (OrganizationUnit)this.organizationUnitDAO.get(orgId);
        Set<Object> postsInOrg = new HashSet();
        if (org == null) {
            throw new OrganizationException("No organization with id: " + orgId);
        }
        postsInOrg = org.getPosts();
        List<Post> allPost = this.postDAO.getAll(this.transfertObjectAssembler.toPostRequestOptions(requestOptionsTO));
        if (allPost != null) {
            if (!postsInOrg.isEmpty()) {
                allPost.removeAll(postsInOrg);
            }
            for (Post post : allPost) {
                result.add(this.toPostTO(post));
            }
        }
        return result;
    }

    @Override
    public List<PostTO> getPostsNotLinkedToPersons(RequestOptionsTO requestOptionsTO) throws OrganizationException {
        ArrayList<PostTO> result = new ArrayList<PostTO>();
        List<Post> allPost = this.postDAO.getAll(this.transfertObjectAssembler.toPostRequestOptions(requestOptionsTO));
        if (allPost != null) {
            for (Post post : allPost) {
                if (this.isPostInUse(post.getId())) continue;
                result.add(this.transfertObjectAssembler.toPostTO(post));
            }
        }
        return result;
    }

    private boolean isPostInUse(String postId) throws OrganizationException {
        Post post = this.postDAO.get(postId);
        if (post == null) {
            throw new OrganizationException("No post found for the given id: " + postId);
        }
        List<Person> persons = this.personUnifiedDAO.searchEquals(new String[]{post.getName()}, new String[]{"post.name"}, null);
        List orgs = this.organizationUnitDAO.searchEquals(new String[]{post.getName()}, new String[]{"posts.name"}, null);
        return persons != null && !persons.isEmpty() || orgs != null && !orgs.isEmpty();
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removePost(String postId) throws OrganizationException {
        if (!this.isPostInUse(postId)) {
            this.postDAO.remove((Post)((Object)postId));
        }
    }

    public void setOrganizationUnitDAO(OrganizationUnitDAO organizationUnitDAO) {
        this.organizationUnitDAO = organizationUnitDAO;
    }

    public void setPostDAO(GenericUnifiedDAO<Post, String> postDAO) {
        this.postDAO = postDAO;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    private void toPostsTO(List<PostTO> result, Collection<Post> posts) {
        if (posts != null && !posts.isEmpty()) {
            for (Post post : posts) {
                result.add(this.toPostTO(post));
            }
        }
    }

    private PostTO toPostTO(Post post) {
        return this.transfertObjectAssembler.toPostTO(post);
    }

    @Override
    @CheckAllArgumentsNotNull
    public String updatePost(PostTO postTO) throws OrganizationException {
        if (postTO.getId() == null) {
            throw new NullPointerException("Post id must be specified");
        }
        Post post = this.postDAO.get(postTO.getId());
        if (post == null) {
            throw new OrganizationException("Your are trying to update a non existing Person with id: " + postTO.getId());
        }
        this.validatePostBeforeUpdate(postTO);
        this.transfertObjectAssembler.toPostBO(postTO, post);
        this.postDAO.save(post);
        return post.getId();
    }

    public void setPersonUnifiedDAO(GenericUnifiedDAO<Person, String> personUnifiedDAO) {
        this.personUnifiedDAO = personUnifiedDAO;
    }
}

