/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.sla;

import com.ebmwebsourcing.addressing.addressing4agreement.monitoring.api.EndpointReferenceType;
import com.ebmwebsourcing.agreement.definition.WSAgreementFactory;
import com.ebmwebsourcing.agreement.definition.api.Agreement;
import com.ebmwebsourcing.agreement.definition.api.AgreementLifeCycle;
import com.ebmwebsourcing.agreement.definition.api.WSAgreementException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.metadata.MetadataServiceException;
import org.ow2.dragon.api.service.sla.SLAManager;
import org.ow2.dragon.api.service.sla.SLAServiceException;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.sla.ManagedAgreement;
import org.ow2.dragon.persistence.dao.DAOLayerException;
import org.ow2.dragon.persistence.dao.GenericUnifiedDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.ow2.dragon.service.sla.SLATransfertObjectAssembler;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.SearchHelper;
import org.ow2.dragon.util.StringHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLAManagerImpl
implements SLAManager {
    private MetadataService metadataService;
    private GenericUnifiedDAO<ManagedAgreement, String> managedAgreementUnifiedDAO;
    private SLATransfertObjectAssembler slatransfertObjectAssembler;
    private TransfertObjectAssembler transfertObjectAssembler;
    private TechServiceManager techServiceManager;

    private void createAlarm(String probesNS, String protocolNS, String prefixProbes, String prefixProtocol, Document doc, Party entity, String type, Element alarmElmt) {
        String email = null;
        String name = null;
        if (entity != null) {
            if (entity instanceof Person) {
                email = ((Person)entity).getEmailAddresses().get(0).getEmail();
                name = ((Person)entity).getFirstName() + " " + ((Person)entity).getLastName();
            } else if (entity instanceof OrganizationUnit) {
                email = ((OrganizationUnit)entity).getEmailAddresses().get(0).getEmail();
                name = ((OrganizationUnit)entity).getNames().get(0).getName();
            }
            if (email != null && name != null) {
                Element toElmt = doc.createElementNS(probesNS, "to");
                toElmt.setPrefix(prefixProbes);
                toElmt.setAttribute("name", name);
                toElmt.setAttribute("type", type);
                Element protocolElmt = doc.createElementNS(probesNS, "protocol");
                protocolElmt.setPrefix(prefixProbes);
                protocolElmt.setAttributeNS(protocolNS, "type", "mail");
                Element addressElmt = doc.createElementNS(protocolNS, "address");
                addressElmt.setPrefix(prefixProtocol);
                addressElmt.setTextContent(email);
                protocolElmt.appendChild(addressElmt);
                toElmt.appendChild(protocolElmt);
                alarmElmt.appendChild(toElmt);
            }
        }
    }

    @Override
    public String createJBIXml(ManagedAgreementTO maTO) throws SLAServiceException {
        String jbiXmlForSu = null;
        return jbiXmlForSu;
    }

    @Override
    public String createManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException {
        String res = null;
        try {
            ManagedAgreement a = this.slatransfertObjectAssembler.toManagedAgreementBO(managedAgreementTO);
            String buffer = WSAgreementFactory.newInstance().newWSAgreementWriter().writeAgreement(managedAgreementTO.getAgreement());
            SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML, buffer.getBytes());
            a.setAgreementFile(agreementFile);
            res = this.managedAgreementUnifiedDAO.save(a).getId();
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException(e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }
        return res;
    }

    @Override
    public String createProbeSettingsXml(ManagedAgreementTO maTO) throws SLAServiceException {
        String res = null;
        return res;
    }

    private String[] createSearchProperties(List<String> searchedProperties) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        if (searchedProperties != null && !searchedProperties.isEmpty()) {
            if (searchedProperties.contains("name")) {
                propertiesList.add("name");
            }
            if (searchedProperties.contains("initiator")) {
                propertiesList.add("initiator");
            }
            if (searchedProperties.contains("responder")) {
                propertiesList.add("responder");
            }
        } else {
            propertiesList.add("name");
            propertiesList.add("initiator");
            propertiesList.add("responder");
        }
        return propertiesList.toArray(new String[0]);
    }

    @Override
    public String exportServiceDefFile(String id) throws SLAServiceException {
        String result = null;
        try {
            ManagedAgreement ag = this.managedAgreementUnifiedDAO.get(id);
            if (ag == null) {
                throw new SLAServiceException("Impossible to find managed agreement with id: " + id);
            }
            InputStream inputStream = null;
            try {
                inputStream = this.metadataService.loadMetadataContentAsInputStream(ag.getAgreementFile().getId());
                result = StringHelper.toString((InputStream)inputStream);
            }
            catch (MetadataServiceException e) {
                throw new WSDLServiceException("Can't load agreement file content", e);
            }
            catch (IOException e) {
                throw new WSDLServiceException("Can't convert agreement file content to String", e);
            }
        }
        catch (Exception e) {
            throw new SLAServiceException("Can't retrieve sla agreement", e);
        }
        return result;
    }

    @Override
    public List<ManagedAgreementTO> getAllManagedAgreements(RequestOptionsTO requestOptionsTO) throws SLAServiceException {
        ArrayList<ManagedAgreementTO> result = new ArrayList<ManagedAgreementTO>();
        List<ManagedAgreement> agreements = this.managedAgreementUnifiedDAO.getAll(this.transfertObjectAssembler.toAgreementRequestOptions(requestOptionsTO));
        try {
            if (agreements != null && !agreements.isEmpty()) {
                for (ManagedAgreement agreement : agreements) {
                    ManagedAgreementTO maTO = this.slatransfertObjectAssembler.toManagedAgreementTO(agreement);
                    InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(agreement.getAgreementFile().getId());
                    Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader().readAgreement(new URI("."), new InputSource(inputStream));
                    maTO.setAgreement(a);
                    if (a instanceof AgreementLifeCycle) {
                        ((AgreementLifeCycle)a).setState(AgreementLifeCycle.State.fromValue((String)maTO.getState()));
                    }
                    result.add(maTO);
                }
            }
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException("Cannot convert agreement to agreement TO", e);
        }
        catch (URISyntaxException e) {
            throw new SLAServiceException("Cannot convert agreement to agreement TO", e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException("Cannot convert agreement to agreement TO", e);
        }
        return result;
    }

    @Override
    public ManagedAgreementTO getManagedAgreement(String id) throws SLAServiceException {
        ManagedAgreementTO agreementTO = null;
        ManagedAgreement ag = this.managedAgreementUnifiedDAO.get(id);
        if (ag == null) {
            throw new SLAServiceException("Impossible to find agreement with id: " + id);
        }
        try {
            agreementTO = this.slatransfertObjectAssembler.toManagedAgreementTO(ag);
            InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(ag.getAgreementFile().getId());
            Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader().readAgreement(new URI("."), new InputSource(inputStream));
            agreementTO.setAgreement(a);
            if (a instanceof AgreementLifeCycle) {
                ((AgreementLifeCycle)a).setState(AgreementLifeCycle.State.fromValue((String)agreementTO.getState()));
            }
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException("Can't parse sla agreement", e);
        }
        catch (URISyntaxException e) {
            throw new SLAServiceException("Can't parse sla agreement", e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException("Can't parse sla agreement", e);
        }
        return agreementTO;
    }

    public GenericUnifiedDAO<ManagedAgreement, String> getManagedAgreementUnifiedDAO() {
        return this.managedAgreementUnifiedDAO;
    }

    public SLATransfertObjectAssembler getSlatransfertObjectAssembler() {
        return this.slatransfertObjectAssembler;
    }

    public TechServiceManager getTechServiceManager() {
        return this.techServiceManager;
    }

    public TransfertObjectAssembler getTransfertObjectAssembler() {
        return this.transfertObjectAssembler;
    }

    @Override
    public String importServiceDefFile(Document domDocument) throws SLAServiceException {
        return null;
    }

    @Override
    public String importServiceDefFile(Element domElement) throws SLAServiceException {
        return null;
    }

    @Override
    public String importServiceDefFile(InputSource inputSource) throws SLAServiceException {
        return null;
    }

    @Override
    public String importServiceDefFile(String slaURI) throws SLAServiceException {
        String storedSLAId = null;
        try {
            SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML, URI.create(slaURI));
            System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            ManagedAgreement managedAgreement = null;
            InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(agreementFile.getId());
            Agreement agreement = WSAgreementFactory.newInstance().newWSAgreementReader().readAgreement(URI.create(slaURI), new InputSource(inputStream));
            managedAgreement = this.isEditable(agreement) ? new ManagedAgreement(true) : new ManagedAgreement(false);
            managedAgreement.setAgreementFile(agreementFile);
            storedSLAId = this.managedAgreementUnifiedDAO.save(managedAgreement).getId();
            managedAgreement.setAgreementFile(agreementFile);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException("Can't register sla file to persistent storage", e);
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException("Can't create sla agreement", e);
        }
        return storedSLAId;
    }

    private boolean isEditable(Agreement ag) throws SLAServiceException {
        boolean res = true;
        try {
            if (ag.getContext() != null) {
                if (!(ag.getContext().getInitiator() instanceof EndpointReferenceType)) {
                    res = false;
                }
                if (!(ag.getContext().getResponder() instanceof EndpointReferenceType)) {
                    res = false;
                }
            }
        }
        catch (WSAddressingException e) {
            throw new SLAServiceException(e);
        }
        if (res) {
            // empty if block
        }
        return res;
    }

    @Override
    public void removeManagedAgreement(String id) throws SLAServiceException {
        this.managedAgreementUnifiedDAO.remove((ManagedAgreement)((Object)id));
    }

    @Override
    public List<ManagedAgreementTO> searchManagedAgreement(String searchCriteria, List<String> searchedProperties, RequestOptionsTO options) throws SLAServiceException {
        List<ManagedAgreement> agreementsBO;
        ArrayList<ManagedAgreementTO> result = new ArrayList<ManagedAgreementTO>();
        String[] criteria = SearchHelper.splitSearchCriteria((String)searchCriteria);
        String[] properties = this.createSearchProperties(searchedProperties);
        try {
            agreementsBO = this.managedAgreementUnifiedDAO.searchORMResult(criteria, properties, this.transfertObjectAssembler.toAgreementRequestOptions(options));
        }
        catch (DAOLayerException e) {
            throw new SLAServiceException("You must specified non empty search criteria and properties.", e);
        }
        try {
            if (agreementsBO != null && !agreementsBO.isEmpty()) {
                for (ManagedAgreement managedAgreement : agreementsBO) {
                    ManagedAgreementTO mabTO = this.slatransfertObjectAssembler.toManagedAgreementTO(managedAgreement);
                    InputStream inputStream = this.metadataService.loadMetadataContentAsInputStream(managedAgreement.getAgreementFile().getId());
                    Agreement a = WSAgreementFactory.newInstance().newWSAgreementReader().readAgreement(new URI("."), new InputSource(inputStream));
                    mabTO.setAgreement(a);
                    if (a instanceof AgreementLifeCycle) {
                        ((AgreementLifeCycle)a).setState(AgreementLifeCycle.State.fromValue((String)mabTO.getState()));
                    }
                    result.add(mabTO);
                }
            }
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException(e);
        }
        catch (URISyntaxException e) {
            throw new SLAServiceException(e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }
        return result;
    }

    public void setManagedAgreementUnifiedDAO(GenericUnifiedDAO<ManagedAgreement, String> managedAgreementUnifiedDAO) {
        this.managedAgreementUnifiedDAO = managedAgreementUnifiedDAO;
    }

    public void setMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public void setSlatransfertObjectAssembler(SLATransfertObjectAssembler slatransfertObjectAssembler) {
        this.slatransfertObjectAssembler = slatransfertObjectAssembler;
    }

    public void setTechServiceManager(TechServiceManager techServiceManager) {
        this.techServiceManager = techServiceManager;
    }

    public void setTransfertObjectAssembler(TransfertObjectAssembler transfertObjectAssembler) {
        this.transfertObjectAssembler = transfertObjectAssembler;
    }

    @Override
    public String updateManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException {
        ManagedAgreement managedAgreement = this.managedAgreementUnifiedDAO.get(managedAgreementTO.getId());
        if (managedAgreement == null) {
            throw new SLAServiceException("Your are trying to update a non existing agreement with id: " + managedAgreementTO.getId());
        }
        try {
            this.slatransfertObjectAssembler.toManagedAgreementBO(managedAgreementTO, managedAgreement);
            this.managedAgreementUnifiedDAO.save(managedAgreement);
            String buffer = WSAgreementFactory.newInstance().newWSAgreementWriter().writeAgreement(managedAgreementTO.getAgreement());
            this.metadataService.deleteMetadata(managedAgreement.getAgreementFile().getId());
            SimpleFile agreementFile = this.metadataService.storeMetadata(ContentType.XML, buffer.getBytes());
            managedAgreement.setAgreementFile(agreementFile);
        }
        catch (WSAgreementException e) {
            throw new SLAServiceException(e);
        }
        catch (MetadataServiceException e) {
            throw new SLAServiceException(e);
        }
        return managedAgreement.getId();
    }

    public MetadataService getMetadataService() {
        return this.metadataService;
    }
}

