/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * TModelManager.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.service.common;

import java.util.List;

import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.CategoryValueTO;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.springframework.transaction.annotation.Transactional;

/**
 * This API allows to manage categories and identifier systems associated to
 * Organizations, Endpoints, Services. Method arguments must be non null, unless
 * the contrary is explicitly specified.
 * 
 * @author ofabre
 * 
 */
@Transactional
public interface TModelManager {

    /**
     * Retrieve all categories that could be linked to tech services
     * 
     * @return a {@link List} of {@link CategoryTO} that could be linked to
     *         {@link TechnicalService}. Can't be null, could be empty
     */
    @Transactional(readOnly = true)
    List<CategoryTO> loadServiceCategories();

    /**
     * Retrieve all categories that could be linked to endpoints
     * 
     * @return a {@link List} of {@link CategoryTO} that could be linked to
     *         {@link Endpoint}. Can't be null, could be empty
     */
    @Transactional(readOnly = true)
    List<CategoryTO> loadEndpointCategories();

    /**
     * Retrieve all categories that could be linked to orgs
     * 
     * @return a {@link List} of {@link CategoryTO} that could be linked to
     *         {@link OrganizationUnit}. Can't be null, could be empty
     */
    @Transactional(readOnly = true)
    List<CategoryTO> loadOrganizationCategories();

    /**
     * Load values for a given category
     * 
     * @param categoryId
     *            a {@link Category} identifier
     * @return all available {@link CategoryValueTO} for a given
     *         {@link Category}
     */
    @Transactional(readOnly = true)
    List<CategoryValueTO> loadCategoryValues(String categoryId);

    /**
     * Retrieve all identifier systems that could be linked to orgs
     * 
     * @return a {@link List} of {@link IdentifierTO} that could be linked to
     *         {@link OrganizationUnit}. Can't be null, could be empty
     */
    @Transactional(readOnly = true)
    List<IdentifierTO> loadOrganizationIdentifierSystems();

}
