/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * WSDLImporter.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.service.sla;

import java.net.URI;
import java.util.List;

import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.sla.ManagedAgreementTO;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

/**
 * @author nsalatge - eBM WebSourcing
 * 
 */
@Transactional
public interface SLAManager {

 
    /**
     * ManagedAgreement Management
     */
    String createManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException;

  
    @Transactional(readOnly = true)
    ManagedAgreementTO getManagedAgreement(final String id) throws SLAServiceException;


    @Transactional(readOnly = true)
    List<ManagedAgreementTO> getAllManagedAgreements(RequestOptionsTO requestOptionsTO)
            throws SLAServiceException;
    
    @Transactional(readOnly = true)
    List<ManagedAgreementTO> getAllManagedAgreementsFromServiceId(String serviceId)
            throws SLAServiceException;
    
    @Transactional(readOnly = true)
    List<ManagedAgreementTO> getAllManagedAgreementsFromEndpointId(String endpointId)
            throws SLAServiceException;

 
    String importAgreementDefFile(Document domDocument) throws SLAServiceException;


    /**
     * import WS-agreement description
     * 
     * @param wsdlURI
     *            the uri of ws-agreement description
     * @return the id where the agreement is stored
     * @throws SLAServiceException
     *             error to import
     */
    String importAgreementDefFile(URI slaURI) throws SLAServiceException;
    
 
    void removeManagedAgreement(String agreementId) throws SLAServiceException;

    @Transactional(readOnly = true)
    List<ManagedAgreementTO> searchManagedAgreement(String searchCriteria, List<String> searchedProperties, RequestOptionsTO iOptions)
            throws SLAServiceException;

    String updateManagedAgreement(ManagedAgreementTO managedAgreementTO) throws SLAServiceException;

    
    
}
