/**
 * 
 */
package org.ow2.dragon.api.service.wsdm;

import java.util.List;
import java.util.Map;

import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.wsdm.QoSMetricTO;
import org.springframework.transaction.annotation.Transactional;

/**
 * A manager of qos metric. Provides methods to 
 * create, retrieve, delete or update qos metric
 * @author aruffie
 *
 */
@Transactional
public interface QoSMetricManager {
    /**
     * Allow to save in database new
     * QoSMetric object, by providing
     * a QoSMetricTO
     * @param qoSMetricTO
     * @throws DeploymentException
     */
    public void saveQoSMetric(final QoSMetricTO qoSMetricTO) throws DeploymentException;
    
    /**
     * Allow to remove a QoSMetric by
     * providing the linked binding
     * operation identifier
     * @param String bindingOperationId
     * @throws DeploymentException
     */
    public void removeQoSMetric(final String bindingOperationId) throws DeploymentException;
    
    /**
     * Allow to get a specific QoSMetricTO
     * by providing the binding operation
     * identifier
     * @param String bindingOperationId
     * @return
     * @throws DeploymentException
     */
    public QoSMetricTO getQoSMetric(final String bindingOperationId) throws DeploymentException;

    /**
     * Allow to recover all QoSMetrics
     * stored in database
     * @return List<QoSMetricTO
     * @throws DeploymentException
     */
    public List<QoSMetricTO> getAllQoSMetrics() throws DeploymentException;
    
    /**
     * Allow to update a QoSMetricBO by
     * providing a QoSMetricTO
     * @param QoSMetricTO qoSMetricTO
     * @throws DeploymentException
     */
    public void updateQoSMetric(final QoSMetricTO qoSMetricTO) throws DeploymentException;
    
    /**
     * Allow to calculate QoSMetric for a
     * given endpoint
     * @param EndpointTO endpointTO
     * @return QoSMetricTO
     * @throws DeploymentException
     */
    public QoSMetricTO getQoSMetricForEndpoint(final String endpointTO) throws DeploymentException;
    
    /**
     * Allow to calculate QoSMetric for a
     * given technical service
     * @param techServiceTO
     * @return
     * @throws DeploymentException
     */
    public QoSMetricTO getQoSMetricForTechnicalService(final String techServiceTO) throws DeploymentException;
     
    /**
     * Allow to calculate QoSMetric for a 
     * given binding
     * @param BindingTO bindingTO
     * @return QoSMetricTO
     * @throws DeploymentException
     */
    public QoSMetricTO getQoSMetricForBinding(final String bindingTO) throws DeploymentException;
    
    public Map<String,String> getCurrentMessage(final String address) throws QoSMetricServiceException;
    
    public EndpointTO subscribe(final String endpointId, final String responseAddress) throws QoSMetricServiceException;

    public EndpointTO unSubscribe(final String endpointId, final String responseAddress) throws QoSMetricServiceException;  
}
