/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * EndpointTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.util.UDDIStandardTModelKeys;

/**
 * This type gives the description of an access point for a service. It is part
 * of a {@link TechnicalServiceTO}
 * 
 * @author ambarthe - eBM WebSourcing
 * 
 */

public class EndpointTO {

    private TechnicalServiceTO techService;

    private BindingTO binding;

    private String id;

    private String name;

    private String networkAddress;

    // Could be Dev, Test, QA...
    private String state;

    private Set<ProtocolTO> protocols;

    private Set<TransportTO> transports;

    private String wsdlFile;

    private String hostProcessorId;

    private String hostExecEnvId;

    private List<KeyedRefTO> categories;

    // Duplicate info with one of the categories
    private String logicalEnvironment;

    // Added By TIAR abderrahmane
    private RatingTO ratingTO;

    private float globalRating;

    private List<CommentTO> comments;

    private Set<String> tags;
    
    // added for monitoring
    private boolean wsdmMonitoring;
    
    private boolean subscription;
    
    private String subscriptionAddr;
    
    private String resourcesUuidType;

    /**
     * @return the RatingTO
     */
    public RatingTO getRatingTO() {
        if (ratingTO == null) {
            ratingTO = new RatingTO();
        }
        return this.ratingTO;
    }

    /**
     * @return the globalRating
     */
    public float getGlobalRating() {
        return this.globalRating;
    }

    /**
     * @param the
     *            RatingTO the ratingTO to set
     */
    public void setRatingTO(final RatingTO ratingTO) {
        this.ratingTO = ratingTO;
    }

    /**
     * @param the
     *            new global rating the global rating to set
     */
    public void setGlobalRating(final float globalRating) {
        this.globalRating = globalRating;
    }

    /**
     * @return the set of tags
     */
    public Set<String> getTags() {
        if (tags == null) {
            this.tags = new HashSet<String>();
        }
        return this.tags;
    }

    /**
     * @param tags
     *            the tags (Strings) to set.
     */
    public void setTags(final Set<String> tags) {
        this.tags = tags;
    }

    /**
     * @return the list of comments
     */
    public List<CommentTO> getComments() {
        if (comments == null) {
            comments = new ArrayList<CommentTO>();
        }
        return this.comments;
    }

    /**
     * @param comments
     *            the list of CommentTO to set.
     */
    public void setComments(List<CommentTO> comments) {
        this.comments = comments;
    }

    // End of what's added By TIAR

    /**
     * @return the binding
     */
    public BindingTO getBinding() {
        return this.binding;
    }

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @return the networkAddress
     */
    public String getNetworkAddress() {
        return this.networkAddress;
    }

    /**
     * @return the service
     */
    public TechnicalServiceTO getTechService() {
        return this.techService;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    /**
     * @param binding
     *            the binding to set
     */
    public void setBinding(final BindingTO binding) {
        this.binding = binding;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * @param networkAddress
     *            the networkAddress to set
     */
    public void setNetworkAddress(final String networkAddress) {
        this.networkAddress = networkAddress;
    }

    /**
     * @param service
     *            the service to set
     */
    public void setTechService(final TechnicalServiceTO service) {
        this.techService = service;
    }

    public void setWsdlFile(final String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getHostProcessorId() {
        return hostProcessorId;
    }

    public void setHostProcessorId(String hostProcessorId) {
        this.hostProcessorId = hostProcessorId;
    }

    public String getHostExecEnvId() {
        return hostExecEnvId;
    }

    public void setHostExecEnvId(String hostExecEnvId) {
        this.hostExecEnvId = hostExecEnvId;
    }

    public List<KeyedRefTO> getCategories() {
        return categories;
    }

    public void setCategories(List<KeyedRefTO> categories) {
        this.categories = categories;
    }

    public String getProtocol() {
        StringBuffer result = new StringBuffer("");

        if (protocols != null) {
            // Communication protocol...
            for (ProtocolTO protocolTO : protocols) {
                if (protocolTO.getId().equals(UDDIStandardTModelKeys.PROTOCOL_SOAP_V3)) {
                    result.append("SOAP1.1 over ");
                } else if (protocolTO.getId().equals(UDDIStandardTModelKeys.PROTOCOL_SOAP12_V3)) {
                    result.append("SOAP1.2 over ");
                } else if (protocolTO.getId().equals(UDDIStandardTModelKeys.PROTOCOL_HTTP_V3)) {
                    result.append("HTTP over ");
                }
            }
            // ... over transport protocol
            for (TransportTO transportTO : transports) {
                if (transportTO.getId().equals(UDDIStandardTModelKeys.TRANSPORT_FTP_V3)) {
                    result.append("FTP");
                } else if (transportTO.getId().equals(UDDIStandardTModelKeys.TRANSPORT_HTTP_V3)) {
                    result.append("HTTP");
                } else if (transportTO.getId().equals(UDDIStandardTModelKeys.TRANSPORT_SMTP_V3)) {
                    result.append("SMTP");
                }
            }

        }

        return result.toString();
    }

    public Set<ProtocolTO> getProtocols() {
        return protocols;
    }

    public void setProtocols(Set<ProtocolTO> protocols) {
        this.protocols = protocols;
    }

    public Set<TransportTO> getTransports() {
        return transports;
    }

    public void setTransports(Set<TransportTO> transports) {
        this.transports = transports;
    }

    /**
     * @return the state
     */
    public String getState() {
        return state;
    }

    /**
     * @param state
     *            the state to set
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * @return the logicalEnvironment
     */
    public String getLogicalEnvironment() {
        return logicalEnvironment;
    }

    /**
     * @param logicalEnvironment
     *            the logicalEnvironment to set
     */
    public void setLogicalEnvironment(String logicalEnvironment) {
        this.logicalEnvironment = logicalEnvironment;
    }

    
    
    public boolean isWsdmMonitoring() {
        return wsdmMonitoring;
    }

    public void setWsdmMonitoring(boolean wsdmMonitoring) {
        this.wsdmMonitoring = wsdmMonitoring;
    }
    
    public boolean isSubscription() {
        return subscription;
    }

    public void setSubscription(boolean subscription) {
        this.subscription = subscription;
    }

    public String getSubscriptionAddr() {
        return subscriptionAddr;
    }

    public void setSubscriptionAddr(String subscriptionAddr) {
        this.subscriptionAddr = subscriptionAddr;
    }

    /**
     * @return the resourcesUuidType
     */
    public String getResourcesUuidType() {
        return resourcesUuidType;
    }

    /**
     * @param resourcesUuidType the resourcesUuidType to set
     */
    public void setResourcesUuidType(String resourcesUuidType) {
        this.resourcesUuidType = resourcesUuidType;
    }
}
