/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * SpecifiedOperationTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.specification;

/**
 * A Specified Operation is the description of an operation provided by a
 * service. It is part of a {@link ServiceInterfaceTO}
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class SpecifiedOperationTO {

    // ==========================================================
    // === Attributes
    // ==========================================================
    private String id;

    private String name;

    private String purpose;

    private String transmission;

    private String style;

    private boolean isNoneUpdating;

    private boolean isAtomicTransaction;

    private boolean canParticipateInTransaction;

    private boolean isTransactionCoordNeeded;

    private String transactionCoordIsBy;

    /*
     * Getters and setters
     */

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the isAtomicTransaction
     */
    public boolean getIsAtomicTransaction() {
        return this.isAtomicTransaction;
    }

    /**
     * @return the canParticipateInTransaction
     */
    public boolean getIsCanParticipateInTransaction() {
        return this.canParticipateInTransaction;
    }

    /**
     * @return the isNoneUpdating
     */
    public boolean getIsNoneUpdating() {
        return this.isNoneUpdating;
    }

    /**
     * @return the isTransactionCoordNeeded
     */
    public boolean getIsTransactionCoordNeeded() {
        return this.isTransactionCoordNeeded;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @return the purpose
     */
    public String getPurpose() {
        return this.purpose;
    }

    public String getStyle() {
        return this.style;
    }

    /**
     * @return the transactionCoordIsBy
     */
    public String getTransactionCoordIsBy() {
        return this.transactionCoordIsBy;
    }

    /**
     * @return the transmission
     */
    public String getTransmission() {
        return this.transmission;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @param isAtomicTransaction
     *            the isAtomicTransaction to set
     */
    public void setIsAtomicTransaction(final boolean isAtomicTransaction) {
        this.isAtomicTransaction = isAtomicTransaction;
    }

    /**
     * @param canParticipateInTransaction
     *            the canParticipateInTransaction to set
     */
    public void setIsCanParticipateInTransaction(final boolean canParticipateInTransaction) {
        this.canParticipateInTransaction = canParticipateInTransaction;
    }

    /**
     * @param isNoneUpdating
     *            the isNoneUpdating to set
     */
    public void setIsNoneUpdating(final boolean isNoneUpdating) {
        this.isNoneUpdating = isNoneUpdating;
    }

    /**
     * @param isTransactionCoordNeeded
     *            the isTransactionCoordNeeded to set
     */
    public void setIsTransactionCoordNeeded(final boolean isTransactionCoordNeeded) {
        this.isTransactionCoordNeeded = isTransactionCoordNeeded;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * @param purpose
     *            the purpose to set
     */
    public void setPurpose(final String purpose) {
        this.purpose = purpose;
    }

    public void setStyle(final String style) {
        this.style = style;
    }

    /**
     * @param transactionCoordIsBy
     *            the transactionCoordIsBy to set
     */
    public void setTransactionCoordIsBy(final String transactionCoordIsBy) {
        this.transactionCoordIsBy = transactionCoordIsBy;
    }

    /**
     * @param transmission
     *            the transmission to set
     */
    public void setTransmission(final String transmission) {
        this.transmission = transmission;
    }
}
