/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * VersionedSpecificationTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.specification;

/**
 * A Versioned Specification is a versioned description of something
 * 
 * @author ambarthe - eBM WebSourcing
 * 
 */

public class VersionedSpecificationTO {

    // ==========================================================
    // === Attributes
    // ==========================================================
    private String id;

    private String name;

    private String technicalName;

    private String versionNr;

    private boolean revisionNr;

    private boolean issueNr;

    private VersionedSpecificationTO motherVersionedSpecification;

    /*
     * Getters and setters
     */

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @return the motherVersionedSpecification
     */
    public VersionedSpecificationTO getMotherVersionedSpecification() {
        return this.motherVersionedSpecification;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @return the technicalName
     */
    public String getTechnicalName() {
        return this.technicalName;
    }

    /**
     * @return the versionNr
     */
    public String getVersionNr() {
        return this.versionNr;
    }

    /**
     * @return the issueNr
     */
    public boolean isIssueNr() {
        return this.issueNr;
    }

    /**
     * @return the revisionNr
     */
    public boolean isRevisionNr() {
        return this.revisionNr;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @param issueNr
     *            the issueNr to set
     */
    public void setIssueNr(final boolean issueNr) {
        this.issueNr = issueNr;
    }

    /**
     * @param motherVersionedSpecification
     *            the motherVersionedSpecification to set
     */
    public void setMotherVersionedSpecification(
            final VersionedSpecificationTO motherVersionedSpecification) {
        this.motherVersionedSpecification = motherVersionedSpecification;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * @param revisionNr
     *            the revisionNr to set
     */
    public void setRevisionNr(final boolean revisionNr) {
        this.revisionNr = revisionNr;
    }

    /**
     * @param technicalName
     *            the technicalName to set
     */
    public void setTechnicalName(final String technicalName) {
        this.technicalName = technicalName;
    }

    /**
     * @param versionNr
     *            the versionNr to set
     */
    public void setVersionNr(final String versionNr) {
        this.versionNr = versionNr;
    }

}
