/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ExecutionEnvironmentTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.technology;

/**
 * An Execution Environment is a software that could expose services. Examples
 * of execution environments: Application Server (JBoss, Jonas, WebSphere,
 * etc.), ESB (PEtALS, ServiceMix, OpenESB, JBoss ESB, etc.).
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class ExecutionEnvironmentTO extends NodeTO {

    private String envType;

    private String roleInFederation;

    private String hostProcessorId;

    private String parentFederationId;

    public String getEnvType() {
        return this.envType;
    }

    public String getHostProcessorId() {
        return this.hostProcessorId;
    }

    public String getParentFederationId() {
        return this.parentFederationId;
    }

    public String getRoleInFederation() {
        return this.roleInFederation;
    }

    public void setEnvType(final String envType) {
        this.envType = envType;
    }

    public void setHostProcessorId(final String hostProcessorId) {
        this.hostProcessorId = hostProcessorId;
    }

    public void setParentFederationId(final String parentFederationId) {
        this.parentFederationId = parentFederationId;
    }

    public void setRoleInFederation(final String roleInFederation) {
        this.roleInFederation = roleInFederation;
    }

}
