/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * NodeTO.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.api.to.technology;

/**
 * An abstraction of {@link ExecutionEnvironment}, {@link Processor}, etc. A
 * node hosts Endpoints.
 * 
 * @author ofabre - eBM Websourcing
 * 
 */
public class NodeTO {

    private String nodeId;

    private String name;

    private String type;

    private String ipv4Address;

    public String getIpv4Address() {
        return this.ipv4Address;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getType() {
        return this.type;
    }

    public void setIpv4Address(final String ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setNodeId(final String nodeId) {
        this.nodeId = nodeId;
    }

    public void setType(final String type) {
        this.type = type;
    }

}
