/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * User.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.administration;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.common.NonSearchableBaseObject;
import org.ow2.dragon.persistence.bo.organization.Person;

@Entity(name = "org.ow2.dragon.persistence.bo.administration.User")
@Table(name = "MasterUser")
public class User extends NonSearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = -6979069718270125935L;

    private String name;

    private String password;

    private List<RoleGroup> listRoleGroup;

    private Person person;

    public User() {
        super();
        this.listRoleGroup = new ArrayList<RoleGroup>();
    }

    @Column(unique = true, nullable = false)
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(nullable = false)
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ManyToMany(fetch = FetchType.LAZY)
    public List<RoleGroup> getListRoleGroup() {
        return listRoleGroup;
    }

    public void setListRoleGroup(List<RoleGroup> listRoleGroup) {
        this.listRoleGroup = listRoleGroup;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void addRoleGroup(RoleGroup roleGroup) {
        this.getListRoleGroup().add(roleGroup);
        roleGroup.getListUser().add(this);
    }

    public void removeRoleGroup(RoleGroup roleGroup) {
        this.getListRoleGroup().remove(roleGroup);
        roleGroup.getListUser().remove(this);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof User))
            return false;
        User castOther = (User) other;
        return new EqualsBuilder().append(name, castOther.name).isEquals();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(name).toHashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("id", this.name)
                .toString();
    }
}
