/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Category.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;

import org.hibernate.annotations.Cascade;

/**
 * @author ofabre
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.common.Category")
public class Category extends TModel {

    /**
     * 
     */
    private static final long serialVersionUID = -9026365907115777970L;

    private List<CategoryValue> values;

    public Category() {
        super();
        this.values = new ArrayList<CategoryValue>();
    }

    public void addValue(CategoryValue value) {
        this.values.add(value);
        value.setCategory(this);
    }

    public void removeValue(CategoryValue value) {
        this.values.remove(value);
        value.setCategory(null);
    }

    @OneToMany(cascade = CascadeType.ALL, mappedBy = "category")
    @Cascade( { org.hibernate.annotations.CascadeType.DELETE_ORPHAN })
    public List<CategoryValue> getValues() {
        return values;
    }

    public void setValues(List<CategoryValue> values) {
        this.values = values;
    }

}
