/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CategoryValue.java
 * -------------------------------------------------------------------------
 */

package org.ow2.dragon.persistence.bo.common;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * @author ofabre
 * 
 */
@Entity(name = "org.ow2.dragon.persistence.bo.common.CategoryValue")
public class CategoryValue extends NonSearchableBaseObject {

    /**
     * 
     */
    private static final long serialVersionUID = 8386423689463679219L;

    public CategoryValue() {
        super();
    }

    public CategoryValue(String value, String description) {
        super();
        this.value = value;
        this.description = description;
    }

    private Category category;

    private String value;

    private String description;

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof CategoryValue))
            return false;
        CategoryValue castOther = (CategoryValue) other;
        return new EqualsBuilder().append(value, castOther.value).append(description,
                castOther.description).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(value).append(description).toHashCode();
    }

    @ManyToOne
    public Category getCategory() {
        return category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

}
