/**
 * Dragon - SOA Governance Platform.
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * Comment.java
 * -------------------------------------------------------------------------
 */
 
package org.ow2.dragon.persistence.bo.common;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * @author atiar (Abderrahmane TIAR)
 * 
 */

@Entity(name = "org.ow2.dragon.persistence.bo.common.Comment")
@Table (name = "Comments")
public class Comment extends NonSearchableBaseObject{
    
    /**
     * 
     */
    private static final long serialVersionUID = 6196289295799074991L;
    
    private String userName ;
    private Date date ;
    private String content;
    
    public Comment() {
        super();
    }
    
    public Comment(String content, String user ) {
        super() ;
        this.userName = user ; 
        this.content = content ;
        this.date = new Date() ;
    }
    
    public void setContent (String content) {
        this.content = content ;
    }
    
    public void setUserName (String user) {
        this.userName = user ;
    }
    
    public void setDate (Date date) {
        this.date = date ;
    }
    
    @Column(nullable = false)
    public String getUserName () {
        return this.userName ;
    }
    
    // 2^16 = 65 536
    @Column(length = 65536)
    @Lob
    public String getContent() { 
        return this.content ;
    }
    @Column(name="CommentDate")
    public Date getDate() {
        return this.date ;
    }
    
    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Comment))
            return false;
        Comment castOther = (Comment) other;
        return new EqualsBuilder().append(userName, castOther.userName)
                .append(this.getId(), castOther.getId()).
                append(content, castOther.content).
                append(date, castOther.date).isEquals();
    }
    
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(userName).append(this.getId()).
        append(content).append(date).toHashCode();
    }
    
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("id", this.getId()).
        append("user", userName).append("content", content).append("date",date).toString();
    }
}